<?php
/*
 * shopping/setting/delivery/Load.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-09-22
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_setting_delivery_Load extends system_login_ModuleBase {
	function shopping_setting_delivery_Load() {
	}
	function execute( & $request ) {
		// 配送無料金額
		$deliveryFreeCondition	= 10000;
		if( defined('SHOPPING_DELIVERY_FREE_PRICE') ){
			$deliveryFreeCondition	= SHOPPING_DELIVERY_FREE_PRICE;
		}
		// クール便を含む場合の取り扱い
		$deliveryTypeOperation	= 0;
		if( defined('SHOPPING_DELIVERY_TYPE_OPERATION') ) {
			$deliveryTypeOperation	= SHOPPING_DELIVERY_TYPE_OPERATION;
		}
		// ラッピング選択肢
		$rappingSettingUri	= SHOPPING_RAPPING_FILE_URI;
		$wrappingStrings	= system_DataFileWriter::getContents( $request, $rappingSettingUri );
		$wrappingInfoHash	= array();
		if( strlen($wrappingStrings) > 0 ) {
			$wrappingStrings	= str_replace("\r\n","\n",$wrappingStrings);
			$wrappingStrings	= str_replace("\r","\n",$wrappingStrings);
			$wrappingLines	= explode("\n",$wrappingStrings);
			foreach( $wrappingLines as $key => $line ) {
				$line	= trim($line);
				if( strlen($line) > 0 ) {
					$elmArray	= array();
					$infoHash	= array();
					if( strpos($line,':') !== false ) {
						$elmArray	= explode(':',$line);
						$infoHash['price']	= array_pop($elmArray);
						$infoHash['name']	= implode(':',$elmArray);
					} else if( strpos($line,',') !== false ) {
						$elmArray	= explode(',',$line);
						$infoHash['price']	= array_pop($elmArray);
						$infoHash['name']	= implode(',',$elmArray);
					} else {
						$infoHash['price']	= 0;
						$infoHash['name']	= $line;
					}
					array_push($wrappingInfoHash,$infoHash);
				}
			}
		}
		
		// ラッピングフリーワード２
		$deliveryWrappingShowFreeWords	= 'off';
		if( defined('SHOPPING_DELIVERY_RAPPING_FREEWORD') ) {
			$deliveryWrappingShowFreeWords	= SHOPPING_DELIVERY_RAPPING_FREEWORD;
		}
		// お届け希望時間帯
		$wishfulTimeUri	= SHOPPING_WISHFUL_TIME_FILE_URI;
		$wishfulTimes	= system_DataFileWriter::getContents( $request, $wishfulTimeUri );
		$wishfulTimes	= str_replace("\r\n","\n",$wishfulTimes);
		$wishfulTimes	= str_replace("\r","\n",$wishfulTimes);
		$wishfulTimeArray	= array();
		$lines				= explode("\n",$wishfulTimes);
		foreach( $lines as $line ) {
			$line	= trim($line);
			if( strlen($line) > 0 ) {
				array_push($wishfulTimeArray,$line);
			}
		}
		
		// お届け希望日
		$deliveryWishfulDayStart	= null;
		$deliveryWishfulDayEnd		= null;
		if( defined('SHOPPING_DELIVERY_WISHFUL_DAY_START')
			&& preg_match('/^[0-9]{1,2}$/',SHOPPING_DELIVERY_WISHFUL_DAY_START) > 0 ) {
			$deliveryWishfulDayStart	= SHOPPING_DELIVERY_WISHFUL_DAY_START;
		}
		if( defined('SHOPPING_DELIVERY_WISHFUL_DAY_END')
			&& preg_match('/^[0-9]{1,2}$/',SHOPPING_DELIVERY_WISHFUL_DAY_END) > 0 ) {
			$deliveryWishfulDayEnd		= SHOPPING_DELIVERY_WISHFUL_DAY_END;
		}
		// お届け希望日の配列を作成
		$wishfulDayArray	= array();
		for( $num=$deliveryWishfulDayStart; $num<=$deliveryWishfulDayEnd; $num++ ) {
			$targetTime	= strtotime('+'.$num.' day');
			$dateString	= date('Y年m月d日',$targetTime);
			$dateString	.= '('.$GLOBALS['WEEK_DAY_NAME_ARRAY'][date('w',$targetTime)].')';
			array_push($wishfulDayArray,$dateString);
		}
		
		$request->setAttribute('shopping.setting.delivery.freeCondition',$deliveryFreeCondition);
		$request->setAttribute('shopping.setting.delivery.typeOperation',$deliveryTypeOperation);
		$request->setAttribute('shopping.setting.delivery.wrappingOptions',$wrappingStrings);
		$request->setAttribute('shopping.setting.delivery.wrappingInfoHash',$wrappingInfoHash);
		$request->setAttribute('shopping.setting.delivery.showFreeWord',$deliveryWrappingShowFreeWords);
		$request->setAttribute('shopping.setting.delivery.wishfulDayStart',$deliveryWishfulDayStart);
		$request->setAttribute('shopping.setting.delivery.wishfulDayEnd',$deliveryWishfulDayEnd);
		$request->setAttribute('shopping.setting.delivery.wishfulDayArray',$wishfulDayArray);
		$request->setAttribute('shopping.setting.delivery.wishfulTimes',$wishfulTimes);
		$request->setAttribute('shopping.setting.delivery.wishfulTimeArray',$wishfulTimeArray);
	}
}
?>