<?php
/*
 * shopping/product/unit/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(dirname(__FILE__))))
.DIRECTORY_SEPARATOR.'file'
.DIRECTORY_SEPARATOR.'Uploader.class.php');
class shopping_product_unit_Execute extends system_login_ModuleBase {
	function shopping_product_unit_Execute(){
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$unitNumber					= stripslashes( $_GET['shpun'] );
		$sessionObjectName			= 'shopping.product.unit.modify.object.'.$unitNumber;
		$sessionConfirmName			= 'shopping.product.unit.modify.confirm.'.$unitNumber;
		$loginUserObject			= $this->getLoginUserObject( $request );
		$shoppingProductUnitObject	= $request->getSession($sessionObjectName);
		$confirmResult				= $request->getSession($sessionConfirmName);
		$compareShoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');

		// 編集権限の確認
		if( $this->isLogin( $request ) ) {
			if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
				// 管理者ログインは編集可
			} else {
				if ( $loginUserObject->member_class >= 53 ) {
					// 会員種別が商品販売会員は編集可
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		} else {
			$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
		}

		if( !$request->isError() ) {
			// パッケージ設定読み込み
			$shoppingPackageConfigObject	= spider_Controller::createObject('shopping_PackageConfig');
			if( $shoppingPackageConfigObject->load( $request ) ) {
			} else {
				$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_ERROR,array());
				return;
			}
			
			if( 'OK' != $confirmResult ) {
				$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			} else if ( get_class($shoppingProductUnitObject) != get_class($compareShoppingProductUnitObject) ){
				$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				// 作成前に再度妥当性検査をおこなう
				$shoppingProductUnitObject->validate( $request );
				// 所有者IDは商品と同じにする
				$shoppingProductUnitObject->shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
				if( $dbo->loadById( $shoppingProductUnitObject->shoppingProductObject, $shoppingProductUnitObject->product_id ) ) {
					$shoppingProductUnitObject->owner_id	= $shoppingProductUnitObject->shoppingProductObject->owner_id;
					// 検索データ連携
					$shoppingProductUnitObject->shoppingProductObject->loadRelatedSearchData( $dbo );
				}
				if( !$request->isError() ) {
					// ログインしている場合としていない場合の振り分け
					if( $this->isLogin( $request ) ) {
						// ログインしているなら編集ユーザーのユニークIDを設定
						$shoppingProductUnitObject->modifier_id	= $loginUserObject->getUniqueId();
					}
					// 削除するファイルがあるなら先に削除
					if( is_array($shoppingProductUnitObject->fileIdArray_org) ) {
						foreach( $shoppingProductUnitObject->fileIdArray_org as $key => $orgFileId ) {
							if( !is_array($shoppingProductUnitObject->fileIdArray) || !in_array($orgFileId,$shoppingProductUnitObject->fileIdArray) ) {
								// 新しいファイルID配列にないなら削除処理
								$oldFileBinObject			= spider_Controller::createObject('file_DaoFileBin');
								if( $dbo->loadById( $oldFileBinObject, $orgFileId) ) {
									if( $oldFileBinObject->deleteFileAll( $request ) ) {
										$dbo->delete( $oldFileBinObject );
									} else {
										$request->addLocaledError('system.error.common.file.delete',SPIDER_LOG_LEVEL_FATAL,array(''));
									}
								} else {
									$request->addLocaledError('system.error.common.file.read',SPIDER_LOG_LEVEL_FATAL,array(''));
								}
							}
						}
					}
					// アップロードファイルがあるなら登録
					if( is_object($shoppingProductUnitObject->uploader) ) {
						if( $shoppingProductUnitObject->uploader->insert( $request, $loginUserObject ) ) {
							foreach( $shoppingProductUnitObject->uploader->fileBinObjectHash as $key => $fileBinObject ) {
								$shoppingProductUnitObject->fileIdArray[$key]	= $fileBinObject->file_id;
							}
						}
					}
					// エラーがないなら商品販売単位登録と更新
					if( strlen(trim($shoppingProductUnitObject->unit_number)) > 0 ) {
						// 商品販売単位番号が設定済みなら更新
						if( $shoppingProductUnitObject->canEditData( $request, $loginUserObject ) ) {
							if( $this->lockData( $request, $shoppingProductUnitObject ) ) {
								// 編集ロックを再取得できたら更新
								$shoppingProductUnitObject->updated_date	= date('Y-m-d H:i:s');
								if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() ) {
									// 管理者ログイン以外の場合、ステータスを新規に設定
									$shoppingProductUnitObject->status_flag = 0;
								}
								if( $dbo->update($shoppingProductUnitObject,false) ) {
								} else {
									$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
								}
								$this->unlockData( $request, $shoppingProductUnitObject );
							} else {
								$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
							}
						} else {
							$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
						}
					} else {
						// 商品販売単位番号がないなら新規挿入
						$shoppingProductUnitObject->updated_date	= date('Y-m-d H:i:s');
						$shoppingProductUnitObject->registered_date	= date('Y-m-d H:i:s');
						if ( strlen(trim($shoppingProductUnitObject->unit_id)) == 0 ) {
							// 商品販売単位IDが未入力の場合、IDを自動生成する
							if( !$dbo->setNextId( $shoppingProductUnitObject, 'SHPUA{num:5}' ) ) {
								$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array(''));
							} else {
								if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() ) {
									// 管理者ログイン以外の場合、ステータスを新規に設定
									$shoppingProductUnitObject->status_flag = 0;
								}
							}
						}
						if( !$request->isError() ) {
							// エラーがなければ、インサート
							if( $dbo->insert($shoppingProductUnitObject) ){
								// インサートに成功したら
								if( $this->isLogin( $request ) ) {
									// ログインしている場合
									if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
										// 管理者ログインの場合は特に何もしない
									} else {
									}
								} else {
								}
							} else {
								$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(''));
							}
						}
					}
				}
			}
		}
		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('shopping.product.unit.unit_object',		$shoppingProductUnitObject);
	}
}
?>