<?php
/*
 * shopping/product/unit/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'file'
.DIRECTORY_SEPARATOR.'Uploader.class.php');
class shopping_product_Execute extends system_login_ModuleBase {
	function shopping_product_Execute(){
	}
	function execute( & $request ) {
		
		$dbo					= $request->getAttribute( 'dbo' );
		$productNumber			= stripslashes( $_GET['shpdn'] );
		$searchDataId			= stripslashes( $_GET['schdi'] );
		$sessionObjectName		= 'shopping.product.modify.object.'.$productNumber.'.'.$searchDataId;
		$sessionConfirmName		= 'shopping.product.modify.confirm.'.$productNumber.'.'.$searchDataId;
		$loginUserObject		= $this->getLoginUserObject( $request );
		$shoppingProductObject	= $request->getSession($sessionObjectName);
		$confirmResult			= $request->getSession($sessionConfirmName);
		$compareShoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');

		// 編集権限の確認
		if( $this->isLogin( $request ) ) {
			if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
				// 管理者ログインは編集可
			} else {
				if ( $loginUserObject->member_class >= 53 ) {
					// 会員種別が商品販売会員は編集可
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		} else {
			$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
		}

		if( !$request->isError() ) {
			// パッケージ設定読み込み
			$shoppingPackageConfigObject	= spider_Controller::createObject('shopping_PackageConfig');
			if( $shoppingPackageConfigObject->load( $request ) ) {
			} else {
				$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_ERROR,array());
				return;
			}
			
			if( 'OK' != $confirmResult ) {
				$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			} else if ( get_class($shoppingProductObject) != get_class($compareShoppingProductObject) ){
				$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				// 作成前に再度妥当性検査をおこなう
				$shoppingProductObject->validate( $request );
				if( !$request->isError() ) {
					// ログインしている場合としていない場合の振り分け
					if( $this->isLogin( $request ) ) {
						// ログインしているなら編集ユーザーのユニークIDを設定
						$shoppingProductObject->modifier_id	= $loginUserObject->getUniqueId();
					}
					// 削除するファイルがあるなら先に削除
					if( is_array($shoppingProductObject->fileIdArray_org) ) {
						foreach( $shoppingProductObject->fileIdArray_org as $key => $orgFileId ) {
							if( !is_array($shoppingProductObject->fileIdArray) || !in_array($orgFileId,$shoppingProductObject->fileIdArray) ) {
								// 新しいファイルID配列にないなら削除処理
								$oldFileBinObject			= spider_Controller::createObject('file_DaoFileBin');
								if( $dbo->loadById( $oldFileBinObject, $orgFileId) ) {
									if( $oldFileBinObject->deleteFileAll( $request ) ) {
										$dbo->delete( $oldFileBinObject );
									} else {
										$request->addLocaledError('system.error.common.file.delete',SPIDER_LOG_LEVEL_FATAL,array(''));
									}
								} else {
									$request->addLocaledError('system.error.common.file.read',SPIDER_LOG_LEVEL_FATAL,array(''));
								}
							}
						}
					}
					// アップロードファイルがあるなら登録
					if( is_object($shoppingProductObject->uploader) ) {
						if( $shoppingProductObject->uploader->insert( $request, $loginUserObject ) ) {
							foreach( $shoppingProductObject->uploader->fileBinObjectHash as $key => $fileBinObject ) {
								$shoppingProductObject->fileIdArray[$key]	= $fileBinObject->file_id;
							}
						}
					}
					// 検索データ連携
					if( $shoppingProductObject->loadSearchData( $request, $loginUserObject )
					&& !is_null($shoppingProductObject->searchDataObject) ){
						// 読み込みできたなら所有者は検索データに合わせる
						$shoppingProductObject->owner_id	= $shoppingProductObject->searchDataObject->owner_id;
					} else {
						// 関連検索データがない場合はログイン者のIDを所有者にする
						$shoppingProductObject->owner_id	= $loginUserObject->getUniqueId();
					}
					// エラーがないならデータ登録と更新
					if( strlen(trim($shoppingProductObject->product_number)) > 0 ) {
						// データ番号が設定済みなら更新
						if( $shoppingProductObject->canEditData( $request, $loginUserObject ) ) {
							if( $this->lockData( $request, $shoppingProductObject ) ) {
								// 編集ロックを再取得できたら更新
								$shoppingProductObject->updated_date	= date('Y-m-d H:i:s');
//								if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() ) {
//									// 管理者ログイン以外の場合、ステータスを新規に設定
//									$shoppingProductObject->status_flag = 0;
//								}
								if( $dbo->update($shoppingProductObject,false) ) {
									// 販売単位同時作成入力があるなら処理
									$this->insertShoppingProductUnitObject( $request, $shoppingProductObject );
								} else {
									$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
								}
								$this->unlockData( $request, $shoppingProductObject );
							} else {
								$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
							}
						} else {
							$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
						}
					} else {
						// データ番号がないなら新規挿入
						$shoppingProductObject->updated_date	= date('Y-m-d H:i:s');
						$shoppingProductObject->registered_date	= date('Y-m-d H:i:s');
						if ( strlen(trim($shoppingProductObject->product_id)) == 0 ) {
							// データIDが未入力の場合、IDを自動生成する
							if( !$dbo->setNextId( $shoppingProductObject, 'PDTDA{num:5}' ) ) {
								$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array(''));
							} else {
//								if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() ) {
//									// 管理者ログイン以外の場合、ステータスを新規に設定
//									$shoppingProductObject->status_flag = 0;
//								}
							}
						}
						if( !$request->isError() ) {
							// エラーがなければ、インサート
							if( $dbo->insert($shoppingProductObject) ){
								// インサートに成功したら
								if( $this->isLogin( $request ) ) {
									// ログインしている場合
									if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
										// 管理者ログインの場合は特に何もしない
									} else {
									}
								} else {
								}
								// 販売単位同時作成入力があるなら処理
								$this->insertShoppingProductUnitObject( $request, $shoppingProductObject );
							} else {
								$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(''));
							}
						}
					}
				}
			}
		}

		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('shopping.product.product_object',		$shoppingProductObject);
	}
	/**
	 * 販売単位を同時作成する入力がある場合にオブジェクトに設定する（新規商品作成の場合のみ）
	 */
	function insertShoppingProductUnitObject( & $request, & $shoppingProductObject ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$loginUserObject		= $this->getLoginUserObject( $request );
		if( is_array($shoppingProductObject->unitObjectArray) && count($shoppingProductObject->unitObjectArray) == 1 ) {
			foreach( $shoppingProductObject->unitObjectArray as $number => $shoppingProductUnitObject ) {
				$shoppingProductUnitObject->owner_id		= $shoppingProductObject->owner_id;
				$shoppingProductUnitObject->updated_date	= date('Y-m-d H:i:s');
//				if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() ) {
//					// 管理者ログイン以外の場合、ステータスを新規に設定
//					$shoppingProductUnitObject->status_flag = 0;
//				}
				if( strlen($shoppingProductUnitObject->unit_number) == 0 ) {
					// 新規作成の場合
					$shoppingProductUnitObject->product_id		= $shoppingProductObject->product_id;
					$shoppingProductUnitObject->registered_date	= date('Y-m-d H:i:s');
					if ( strlen(trim($shoppingProductUnitObject->unit_id)) == 0 ) {
						// 商品販売単位IDが未入力の場合、IDを自動生成する
						if( !$dbo->setNextId( $shoppingProductUnitObject, 'SHPUA{num:5}' ) ) {
							$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array(''));
						} else {
						}
					}
					if( !$request->isError() ) {
						if( $dbo->insert($shoppingProductUnitObject) ){
						} else {
							$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(''));
						}
					}
				} else {
					// 更新の場合
					if( $dbo->update($shoppingProductUnitObject) ){
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			}
		}
	}
}
?>