<?php
/*
 * shopping/order/step/ConfirmAdminColumn.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Hiroki Koga
 * Last Update: 2010-09-07
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'DaoShoppingOrder.class.php' );
class shopping_order_step_ConfirmAdminColumn extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */	
	function shopping_order_step_ConfirmAdminColumn() {
		array_push($this->require_module_array,'shopping.LoadConfig');
		array_push($this->require_module_array,'shopping.order.option.LoadList');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
		if( isset($_GET['shpoi']) && strlen(trim($_GET['shpoi'])) > 0 ) {
			array_push($this->require_module_array,'shopping.order.CartAdmin');
		} else {
			array_push($this->require_module_array,'shopping.order.Cart');
		}
		array_push($this->require_module_array,'shopping.order.step.ConfirmStock');
	}
	/**
	 * executeメソッド
	 */
	function execute( & $request ) {
		$dbo		= $request->getAttribute( 'dbo' );
		$redirect	= $request->getParam('redirect','post');
		// カートオブジェクトの取得
		$shoppingOrderObject	= $request->getAttribute('shopping.order.orderObject');
		
		// 管理者カラム情報
		$deliveryCode	= $_POST['delivery_code'];
		$deliveryCode	= str_replace("\r\n","\n",$deliveryCode);
		$deliveryCode	= str_replace("\r","\n",$deliveryCode);
		$shoppingOrderObject->delivery_code = $deliveryCode;
		$shoppingOrderObject->admin_note	= $_POST['admin_note'];
		
		// 申し込み日時
		unset($shoppingOrderObject->columnErrorHash['order_date']);
		if( isset($_POST['order_date']) && strlen(trim($_POST['order_date'])) > 0 ) {
			$shoppingOrderObject->order_date	= mb_convert_kana(trim(stripslashes($_POST['order_date'])),'a');
			if( preg_match('/^(19[0-9][0-9]|20[0-3][0-9])\\-(|[01])[0-9]\\-(|[0-3])[0-9]\\s[0-9]{2}\\:[0-9]{2}\\:[0-9]{2}$/',$shoppingOrderObject->order_date) == 0 ) {
				$shoppingOrderObject->addColumnError($request,'order_date', 'shopping.error.cart.admin.invalidorderdate');
			} else if( strtotime($shoppingOrderObject->order_date) === false ) {
				$shoppingOrderObject->addColumnError($request,'order_date', 'shopping.error.cart.admin.invalidorderdate');
			}
		}
		
		// 妥当性検査：伝票番号
		$deliveryCodeArray	= array();
		if ( strlen(trim($deliveryCode))>0 ) {
			$deliveryCodeArray	= explode("\n",$deliveryCode);
			$newDeliveryCodeArray	= array();
			foreach ( $deliveryCodeArray as $cDeliveryCode ) {
				if ( strlen(trim($cDeliveryCode))>0 ) {
					array_push($newDeliveryCodeArray,$cDeliveryCode);
				}
			}
			$deliveryCodeArray = $newDeliveryCodeArray;
		}
		if( count($deliveryCodeArray)==0 ) {
		} else {
			$existDeliveryCodeArray = array();
			foreach( $deliveryCodeArray as $num=>$cDeliveryCode ) {
				if ( $num < 10 ) {
					if( strlen($cDeliveryCode) > 16 ) {
						$shoppingOrderObject->addColumnError($request,'delivery_code', 'shopping.error.cart.admin.invaliddeliverycode');
					}
				} else {
					$shoppingOrderObject->addColumnError($request,'delivery_code', 'shopping.error.cart.admin.invaliddeliverycode');
					break;
				}
				if ( in_array($cDeliveryCode,$existDeliveryCodeArray) ) {
					$shoppingOrderObject->addColumnError($request,'delivery_code', 'shopping.error.cart.admin.invaliddeliverycode');
				} else {
					array_push($existDeliveryCodeArray,$cDeliveryCode);
				}
			}
		}

		// 妥当性検査:管理者メモ
		if( strlen($shoppingOrderObject->admin_note) == 0 ) {
		} else if( strlen($shoppingOrderObject->admin_note) > 1500 ) {
			$shoppingOrderObject->addColumnError($request,'admin_note', 'shopping.error.cart.admin.memo.overlength');
		}
		
		if( $request->isError()
		&& preg_match('/^([fF](|[aA][lL][sS][eE])|[nN][oO](|[nN][eE]))$/',$redirect) == 0 ) {
			if( strlen($_SERVER['HTTP_REFERER']) > 0 ) {
				$request->redirectTo($_SERVER['HTTP_REFERER']);
			} else if( preg_match('/^\\.\\//',trim($_POST['referer'])) > 0 ) {
				$request->redirectTo(trim($_POST['referer']));
			}
		} else {
			$confirmResult	= 'OK';
			$shoppingOrderObject->columnErrorHash	= array();
		}
		$request->setAttribute('shopping.order.orderObject',	$shoppingOrderObject );
	}
}
?>