<?php
/*
 * shopping/order/step/ConfirmAddress.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-10-04
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'DaoShoppingOrder.class.php');
class shopping_order_step_ConfirmAddress extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_step_ConfirmAddress() {
		array_push($this->require_module_array,'shopping.LoadConfig');
		array_push($this->require_module_array,'shopping.order.option.LoadList');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
		if( isset($_GET['shpoi']) && strlen(trim($_GET['shpoi'])) > 0 ) {
			array_push($this->require_module_array,'shopping.order.CartAdmin');
		} else {
			array_push($this->require_module_array,'shopping.order.Cart');
		}
		array_push($this->require_module_array,'shopping.order.step.ConfirmStock');
		// 下位互換モジュール呼び出し
		array_push($this->require_module_array,'shopping.order.step.ConfirmAddressOption');
	}
	/**
	 * executeメソッド
	 */
	function execute( & $request ) {
		// 属性の取得
		$dbo					= $request->getAttribute( 'dbo' );
		$redirect			= $request->getParam('redirect','post');
		$loginUserObject		= $this->getLoginUserObject( $request );
		// カートオブジェクトの取得
		$shoppingOrderObject	= $request->getAttribute('shopping.order.orderObject');
		// 申し込み時のカート内基本検査
		if( !is_object($shoppingOrderObject) || $shoppingOrderObject->getAllItemCount($request) == 0 ) {
			// 商品選択がなければエラー
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			return false;
		}
		$shoppingOrderObject->optimize();
		
		// 現在の申し込みで住所入力が必要か確認
		$shoppingOrderObject->requireAddress	= false;
		$deliveryTypeArray	= $shoppingOrderObject->getDeliveryTypeArray( $request );
		foreach( $deliveryTypeArray as $deliveryType ) {
			if( $deliveryType < 10 || $deliveryType >= 200 ) {
				$shoppingOrderObject->requireAddress	= true;
				break;
			}
		}
		// 申し込み情報
		// 入力：宛先情報
		$memberObject	= & $shoppingOrderObject->memberObject;
		$copytoaddressArray					= $request->getParam('copytoaddress','post','array');
		$copytoaddress2Array				= $request->getParam('copytoaddress2','post','array');
		$addressNameArray					= $request->getParam('address_name','post','array'); 
		$addressKanaArray					= $request->getParam('address_kana','post','array');
		$companyNameArray					= $request->getParam('address_company_name','post','array'); 
		$sectionNameArray					= $request->getParam('address_section_name','post','array'); 
		$addressTelephoneNumberArray		= $request->getParam('address_telephone_number','post','array');
		$addressTelephoneNumberAreaArray	= $request->getParam('address_telephone_number_area','post','array');
		$addressTelephoneNumberCityArray	= $request->getParam('address_telephone_number_city','post','array');
		$addressTelephoneNumberLocalArray	= $request->getParam('address_telephone_number_local','post','array');
		$addressZipCodeArray				= $request->getParam('address_zip_code','post','array');
		$addressZipCodePreArray				= $request->getParam('address_zip_code_pre','post','array');
		$addressZipCodePstArray				= $request->getParam('address_zip_code_pst','post','array');
		$addressPrefectureNumberArray		= $request->getParam('address_prefecture_number','post','array');
		$addressAddressArray				= $request->getParam('address_address','post','array');
		$addressBuildingArray				= $request->getParam('address_building','post','array');
		$addressEmailArray					= $request->getParam('address_email','post','array');
		
		foreach( $shoppingOrderObject->shoppingOrderAddressObjectArray as $num => $addressObject ) {
			$shoppingOrderAddressObject	= & $shoppingOrderObject->shoppingOrderAddressObjectArray[$num];
			if( !$shoppingOrderObject->requireAddress
				|| $shoppingOrderObject->buying_flag == 1
				|| preg_match('/^([yY](|[eE][sS])|[tT](|[rR][uU][eE]))$/', $copytoaddressArray[$num] ) > 0 ) {
				// 住所入力を必要としない商品または登録情報コピーの場合memberObjectに設定された値をそのまま設定
				$shoppingOrderAddressObject->copytoaddress		= true;
				$shoppingOrderAddressObject->copytoaddress2		= false;
				$shoppingOrderAddressObject->address_name		= $memberObject->family_name.$memberObject->first_name;
				$shoppingOrderAddressObject->address_kana		= $memberObject->family_kana.$memberObject->first_kana;
				$shoppingOrderAddressObject->telephone_number	= $memberObject->telephone_number;
				$shoppingOrderAddressObject->telephone_number_area		= $memberObject->telephone_number_area;
				$shoppingOrderAddressObject->telephone_number_city		= $memberObject->telephone_number_city;
				$shoppingOrderAddressObject->telephone_number_local		= $memberObject->telephone_number_local;
				$shoppingOrderAddressObject->zip_code			= $memberObject->zip_code;
				$shoppingOrderAddressObject->zip_code_pre		= $memberObject->zip_code_pre;
				$shoppingOrderAddressObject->zip_code_pst		= $memberObject->zip_code_pst;
				$shoppingOrderAddressObject->prefecture_number	= $memberObject->prefecture_number;
				$shoppingOrderAddressObject->address			= $memberObject->address;
				$shoppingOrderAddressObject->building			= $memberObject->building;
				$shoppingOrderAddressObject->email				= $memberObject->email;
			} else if( preg_match('/^([yY](|[eE][sS])|[tT](|[rR][uU][eE]))$/', $copytoaddress2Array[$num] ) > 0 ) {
				// 登録情報２をコピーの場合
				$shoppingOrderAddressObject->copytoaddress		= false;
				$shoppingOrderAddressObject->copytoaddress2		= true;
				$shoppingOrderAddressObject->address_name		= $memberObject->family_name.$memberObject->first_name;
				$shoppingOrderAddressObject->address_kana		= $memberObject->family_kana.$memberObject->first_kana;
				$shoppingOrderAddressObject->telephone_number	= $memberObject->telephone_number2;
				$shoppingOrderAddressObject->telephone_number_area		= $memberObject->telephone_number2_area;
				$shoppingOrderAddressObject->telephone_number_city		= $memberObject->telephone_number2_city;
				$shoppingOrderAddressObject->telephone_number_local		= $memberObject->telephone_number2_local;
				$shoppingOrderAddressObject->zip_code			= $memberObject->zip_code2;
				$shoppingOrderAddressObject->zip_code_pre		= $memberObject->zip_code2_pre;
				$shoppingOrderAddressObject->zip_code_pst		= $memberObject->zip_code2_pst;
				$shoppingOrderAddressObject->prefecture_number	= $memberObject->prefecture_number2;
				$shoppingOrderAddressObject->address			= $memberObject->address2;
				$shoppingOrderAddressObject->building			= $memberObject->building2;
				$shoppingOrderAddressObject->email				= $memberObject->email;
			} else {
				// 住所入力が必要な場合
				$shoppingOrderAddressObject->copytoaddress				= false;
				$shoppingOrderAddressObject->copytoaddress2				= false;
				$shoppingOrderAddressObject->address_name				= $addressNameArray[$num];
				$shoppingOrderAddressObject->address_kana				= $addressKanaArray[$num];
				$shoppingOrderAddressObject->company_name				= $companyNameArray[$num];
				$shoppingOrderAddressObject->section_name				= $sectionNameArray[$num];
				$shoppingOrderAddressObject->telephone_number			= $addressTelephoneNumberArray[$num];
				$shoppingOrderAddressObject->telephone_number_area		= $addressTelephoneNumberAreaArray[$num];
				$shoppingOrderAddressObject->telephone_number_city		= $addressTelephoneNumberCityArray[$num];
				$shoppingOrderAddressObject->telephone_number_local		= $addressTelephoneNumberLocalArray[$num];
				$shoppingOrderAddressObject->zip_code					= $addressZipCodeArray[$num];
				$shoppingOrderAddressObject->zip_code_pre				= $addressZipCodePreArray[$num];
				$shoppingOrderAddressObject->zip_code_pst				= $addressZipCodePstArray[$num];
				$shoppingOrderAddressObject->prefecture_number			= $addressPrefectureNumberArray[$num];
				$shoppingOrderAddressObject->address					= $addressAddressArray[$num];
				$shoppingOrderAddressObject->building					= $addressBuildingArray[$num];
				$shoppingOrderAddressObject->email						= $addressEmailArray[$num];
			}
		}
		// 入力情報を整理
		$shoppingOrderObject->optimize();
		
		// 入力値の整理と妥当性検査
		$shoppingOrderObject->validateAddress( $request );
		$shoppingOrderObject->calculated	= false;

		if( $request->isError()
		&& preg_match('/^([fF](|[aA][lL][sS][eE])|[nN][oO](|[nN][eE]))$/',$redirect) == 0 ) {
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS);
			if( strlen($_SERVER['HTTP_REFERER']) > 0 ) {
				$request->redirectTo($_SERVER['HTTP_REFERER']);
			} else if( preg_match('/^\\.\\//',trim($_POST['referer'])) > 0 ) {
				$request->redirectTo(trim($_POST['referer']));
			}
		} else {
			$confirmResult	= 'OK';
			$shoppingOrderObject->columnErrorHash	= array();
			$request->setSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS,$confirmResult);
		}
		$request->setAttribute('shopping.order.orderObject',	$shoppingOrderObject );
	}
}
?>