<?php
/*
 * shopping/order/SaveSettleAdmin.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_order_SaveSettleAdmin extends system_login_ModuleBase {
	
	function shopping_order_SaveSettleAdmin() {
		array_push($this->require_module_array,'database2.Transaction');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
	}
	function execute( & $request ) {
		$dbo			= $request->getAttribute( 'dbo' );
		$orderId		= $request->getParam('order_id','post');
		$discountAdmin	= $request->getParam('discount_admin','post');
		$loginUserObject	= $this->getLoginUserObject( $request );
		if( strlen($orderId) == 0 ) {
			$request->addLocaledError('shopping.error.order.required',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else if( strlen($discountAdmin) == 0 ) {
			$request->addLocaledError('shopping.error.cart.admin.money.required',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else if( preg_match('/^(\\-|\\+|)[0-9]{1,6}$/',$discountAdmin) == 0 ) {
			$request->addLocaledError('shopping.error.cart.admin.money.invalid',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else {
			$shoppingOrderObject	= spider_Controller::createObject('shopping_DaoShoppingOrder');
			if( $dbo->loadById( $shoppingOrderObject, $orderId, true ) ) {
				$oldPaymentTotal	= $shoppingOrderObject->payment_total;
				$oldDiscountAdmin	= $shoppingOrderObject->discount_admin;
				$operationType	= 0;
				if( !$request->isError() ) {
					$operationType	= $shoppingOrderObject->confirmModifyPermittion( $request, $loginUserObject );
				}
				if( $operationType == 0 || $operationType == 2 ) {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				} else {
					// 読み込みができたら管理者調整金額カラムに適用
					$shoppingOrderObject->discount_admin	= $discountAdmin;
					// 金額の再計算
					$shoppingOrderObject->calculate( $request, true );
					// 履歴テキストの追記
					$historyNote	.= '\\'.number_format($oldDiscountAdmin)
					.' -> \\'.number_format($shoppingOrderObject->discount_admin)
					.'に変更され、お支払い金額が\\'.number_format($oldPaymentTotal)
					.'から\\'.number_format($shoppingOrderObject->payment_total).'になりました。';
					// 更新日と状態の変更
					$shoppingOrderObject->updated_date	= date('Y-m-d H:i:s');
					if( $dbo->update( $shoppingOrderObject ) ) {
						if(!$shoppingOrderObject->writeHistoryNote( $request, '管理者調整金額変更', $historyNote, '', $loginUserObject )){
							$request->addLocaledError('shopping.error.order.failtohistory',SPIDER_LOG_LEVEL_FATAL,array(''));
						}
					} else {
						$request->addLocaledError('shopping.error.order.save',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			} else {
				$request->addLocaledError('shopping.error.order.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
			$request->setAttribute('shopping.order.shoppingOrderObject',	$shoppingOrderObject );
		}
	}
}
?>