<?php
/*
 * shopping/order/Optimize.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-09-21
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
/**
 * Oprimizeモジュール
 * $requestに属性登録されているshopping_DaoShoppingOrderオブジェクトを表示するための
 * データを整えます。
 */
class shopping_order_Optimize extends system_login_ModuleBase {
	function shopping_order_Optimize() {
		if( isset($_GET['shpoi']) && strlen(trim($_GET['shpoi'])) > 0 ) {
			array_push($this->require_module_array,'shopping.order.CartAdmin');
		} else {
			array_push($this->require_module_array,'shopping.order.Cart');
		}
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute('dbo');
		$shoppingOrderObject	= $request->getAttribute('shopping.order.orderObject');
		$loginUserObject		= $this->getLoginUserObject( $request );
		if( is_object($shoppingOrderObject) ) {
			// カート内を現在の情報で再計算
			$shoppingOrderObject->calculate( $request, true );
			/* version 1.1互換コード	 */
			$this->_setEnvironmentFor11x( $request, $shoppingOrderObject );
			// 表示用に属性登録
			$request->setAttribute('shopping.order.orderObject',	$shoppingOrderObject );
			// 妥当性結果の属性登録
			$confirmResultPurchaser		= $request->getSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_PURCHASER);
			$confirmResultAddress		= $request->getSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS);
			$confirmResultDelivery		= $request->getSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_DELIVERY_OLD);
			$request->setAttribute('shopping.order.confirmResultPurchaser',	$confirmResultPurchaser);
			$request->setAttribute('shopping.order.confirmResultAddress',	$confirmResultAddress);
			$request->setAttribute('shopping.order.confirmResultDelivery',	$confirmResultDelivery);
		
		}
	}
	/**
	 * for alternating version 1.1
	 * @deprecated 1.2
	 */
	function _setEnvironmentFor11x( & $request, & $shoppingOrderObject ) {
		// お届け先情報の設定
		if ( count($shoppingOrderObject->shoppingOrderAddressObjectArray) > 0 ) {
			$shoppingOrderAddressObject	= $shoppingOrderObject->shoppingOrderAddressObjectArray[0];
			$wrappingInfoHash		= $request->getAttribute('shopping.setting.delivery.wrappingInfoHash');
			if( !is_array($wrappingInfoHash) ) {
				// 配送設定が読み込まれていない場合は強制コール
				require_once(dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR.'setting'
					.DIRECTORY_SEPARATOR.'delivery'.DIRECTORY_SEPARATOR.'Load.class.php');
				shopping_setting_delivery_Load::execute( $request );
				$wrappingInfoHash		= $request->getAttribute('shopping.setting.delivery.wrappingInfoHash');
			}
			$oldWrappingType	= 0;
			foreach( $wrappingInfoHash as $key => $infoHash ) {
				if( $infoHash['name'] == $shoppingOrderAddressObject->wrapping_type ) {
					$oldWrappingType	= $key;
					break;
				}
			}
		}

		// 現在申込内容で住所入力が必要か確認
		$shoppingOrderObject->requireAddress	= false;
		$deliveryTypeArray	= $shoppingOrderObject->getDeliveryTypeArray( $request );
		foreach( $deliveryTypeArray as $deliveryType ) {
			if( $deliveryType < 10 || $deliveryType >= 200 ) {
				$shoppingOrderObject->requireAddress	= true;
				break;
			}
		}
		
		// メール送信ドメインの作成
		if( !defined('SHOPPING_MAIL_ADDRESS_FROM') || strlen(SHOPPING_MAIL_ADDRESS_FROM) == 0 ){
			$mailTemplateInfo	= shopping_PackageConfig::getMailTemplateInformation( $request, 'SHOPMAILTHANKSNW', 'example@docomo.co.jp' );
			define('SHOPPING_MAIL_ADDRESS_FROM',$mailTemplateInfo['fromAddress']);
		}
	}
}
?>