<?php
/*
 * shopping/order/Load.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_order_Load extends system_login_ModuleBase {
	
	function shopping_order_Load() {
		array_push($this->require_module_array,'shopping.LoadConfig');
		array_push($this->require_module_array,'shopping.order.settlement.LoadListExists');
	}
	function execute( & $request ) {
		
		$dbo					= $request->getAttribute( 'dbo' );
		$orderNumber			= stripslashes($_GET['shpon']);
		$orderId				= stripslashes($_GET['shpoi']);
		$sessionObjectName		= SHOPPING_SESSION_NAME_ORDER_OBJECT;
		$sessionConfirmName		= 'shopping.order.order_confirm';
		$shoppingOrderObject	= spider_Controller::createObject('shopping_DaoShoppingOrder');
		$request->removeSession($sessionObjectName);
		$request->removeSession($sessionConfirmName);
		
		if( preg_match('/^[0-9]+$/',$orderNumber) > 0 ) {
			// 番号があるなら読み込み
			if( $dbo->loadByNumber( $shoppingOrderObject, $orderNumber, true ) ) {
			} else {
				$request->addLocaledError('shopping.error.order.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else if( preg_match('/^[0-9a-zA-Z\\-\\_\\.]+$/',$orderId) > 0 ) {
			// IDがあるなら読み込み
			if( $dbo->loadById( $shoppingOrderObject, $orderId, true ) ) {
			} else {
				$request->addLocaledError('shopping.error.order.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else {
			$request->addLocaledError('shopping.error.order.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		
		// 決済状態同期
		$enableSynchronize	= false;
		$settleMethodObject			= null;
		$settleMethodObjectArray	= $request->getAttribute('shopping.order.settlement.methodExistsObjectArray');
		if( is_array($settleMethodObjectArray) ) {
			foreach( $settleMethodObjectArray as $methodObject ) {
				if( $shoppingOrderObject->settle_method == $methodObject->getMethodNumber() ) {
					$settleMethodObject	= $methodObject;
					break;
				}
			}
		}
		if( !is_null($settleMethodObject) ) {
			if( $settleMethodObject->enableSynchronize( $shoppingOrderObject ) ) {
				$enableSynchronize	= true;
				$settleMethodObject->settleSynchronize( $request, $shoppingOrderObject );
			} else {
				$enableSynchronize	= false;
			}
		} else {
			$request->addLocaledError('shopping.error.order.failtoloadplugin',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		
		$request->setAttribute('shopping.order.orderObject',	$shoppingOrderObject );
		$request->setAttribute('shopping.order.enableSynchronize',	$enableSynchronize );
	}
}
?>