<?php
/*
 * member/member/reject/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 ポイント入力確認用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_reject_Confirm extends system_login_ModuleBase {
	function member_member_reject_Confirm() {
		array_push($this->require_module_array,'database2.Connect');
		array_push( $this->require_module_array, 'member.mail.reject.LoadList' );
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$memberId				= stripslashes( $_GET['mi'] );
		$sessionObjectName		= 'member.member.reject.modify.object.'.$memberId;
		$sessionConfirmName		= 'member.member.reject.modify.confirm.'.$memberId;
		$memberObject			= spider_Controller::createObject('member_DaoMember');
		$compareMemberObject	= spider_Controller::createObject('member_DaoMember');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);
		if( strlen(trim($memberId)) > 0 ) {
			// 会員IDが指定されているなら編集の為読み込み
			if( $dbo ->loadById( $memberObject, $memberId ) ) {
				// 読み込めたら編集可能か確認
				if( $memberObject->canEditData( $request, $loginUserObject ) ) {
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
					return false;
				}
				// 読み込めたらロック状態を確認する
				$this->lockData( $request, $memberObject );
			} else {
				$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				return false;
			}
		} else {
			$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// member_idが設定済みならロック処理
		if( strlen($memberObject->member_id ) > 0 ) {
			if( false === $this->lockData( $request, $memberObject ) ) {
				$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				return false;
			}
		}
		// 入力値のセットとチェック
		if( !is_array($_POST['rejectListIdArray']) ) {
			$memberObject->rejectListIdArray	= array();
			if( strlen(trim($_POST['rejectListIdArray'])) > 0 ) {
				array_push($memberObject->rejectListIdArray,trim($_POST['rejectListIdArray']));
			}
		} else {
			$memberObject->rejectListIdArray	= array();
			foreach( $_POST['rejectListIdArray'] as $listId ) {
				if( strlen(trim($listId)) > 0 ) {
					array_push($memberObject->rejectListIdArray,trim($listId));
				}
			}
		}
		$rejectListObjectArray	= $request->getAttribute('member.mail.reject.data_array');
		foreach( $memberObject->rejectListIdArray as $listId ) {
			$isExists	= false;
			foreach( $rejectListObjectArray as $rejectListObject ) {
				if( $rejectListObject->list_id == $listId ) {
					$isExists	= true;
					break;
				}
			}
			if( !$isExists ) {
				$request->addLocaledError('member.error.dao.magazine.invalidmagazinetype',SPIDER_LOG_LEVEL_FATAL,array());
			}
		}
		
		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$memberObject);
		$request->setAttribute('member.member.reject.memberObject',$memberObject);
	}
}
?>