<?php
/*
 * member/mail/template/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール テンプレート作成 入力確認用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @subpackage template テンプレートパッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_template_Confirm extends system_login_ModuleBase {
	function member_mail_template_Confirm(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo						= $request->getAttribute( 'dbo' );
		$templateNumber				= $request->getParam('tpln','get');
		$sessionObjectName		= 'member.mail.template.modify.object.'.$templateNumber;
		$sessionConfirmName		= 'member.mail.template.modify.confirm.'.$templateNumber;
		$mailTemplateObject			= spider_Controller::createObject('member_DaoMemberMailTemplate');
		$compare_template			= spider_Controller::createObject('member_DaoMemberMailTemplate');
		$loginUserObject			= $this->getLoginUserObject( $request );
		
		if( strlen(trim($templateNumber)) > 0 ) {
			// IDが指定されているなら編集の為読み込み
			if( $dbo->loadByNumber($mailTemplateObject, $templateNumber ) ) {
				if( $loginUserObject->getUniqueId() != 'SYSADMIN'
					&& $mailTemplateObject->open_flag != 0
					&& $mailTemplateObject->owner_id != $loginUserObject->getUniqueId() ) {
					// 公開フラグが共有になっていない場合は所有者でなければエラー
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
					return;
				} else {
					$this->lockData( $request, $mailTemplateObject );
				}
			} else {
				$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
			}
		}
		// 入力値のセットとチェック
		$mailTemplateObject->template_name		= $request->getParam('template_name');
		if( strlen($mailTemplateObject->template_number) == 0 ) {
			// 新規登録時のみ入力値を設定
			$mailTemplateObject->template_type		= $request->getParam('template_type');
		}
		$mailTemplateObject->template_id		= $request->getParam('template_id');
		$mailTemplateObject->open_flag			= $request->getParam('open_flag');
		$mailTemplateObject->list_id			= $request->getParam('list_id');
		$mailTemplateObject->subject			= $request->getParam('subject');
		$mailTemplateObject->subject_mobile		= $request->getParam('subject_mobile');
		$mailTemplateObject->text_body_default	= $request->getParam('text_body_default');
		$mailTemplateObject->text_body_mobile	= $request->getParam('text_body_mobile');
		$mailTemplateObject->html_body_default	= $request->getParam('html_body_default');
		$mailTemplateObject->html_body_mobile	= $request->getParam('html_body_mobile');
		$mailTemplateObject->description		= $request->getParam('description');
		$mailTemplateObject->mail_from_name		= $request->getParam('mail_from_name');
		$mailTemplateObject->mail_from_address	= $request->getParam('mail_from_address');
		$mailTemplateObject->mail_reply_address	= $request->getParam('mail_reply_address');
		$mailTemplateObject->mail_return_path	= $request->getParam('mail_return_path');
		$mailTemplateObject->bgcolor			= $request->getParam('bgcolor');
		if( strlen($mailTemplateObject->template_id) == 0 ) {
			$request->addLocaledError('member.error.mail.template.requireid',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( strlen($mailTemplateObject->template_id) > 240 ) {
			$request->addLocaledError('member.error.mail.template.invalidid',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			$sql	= 'SELECT COUNT(template_number) FROM '.TABLE_NAME_MEMBER_MAIL_TEMPLATE
			.' WHERE template_id='.$dbo->quote($mailTemplateObject->template_id);
			if( strlen($templateNumber)>0 && preg_match('/^[0-9]+$/',$templateNumber) > 0){
				$sql	.= ' AND template_number<>'.$templateNumber;
			}
			$tcount = $dbo->queryOne($sql);
			if( false === $tcount ){
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
			} else if( $tcount>0 ){
				$request->addLocaledError('member.error.mail.template.duplicatedid',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		if( strlen($mailTemplateObject->template_name) == 0 ) {
			$request->addLocaledError('member.error.mail.template.requirename',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( strlen($mailTemplateObject->template_name) > 240 ) {
			$request->addLocaledError('member.error.mail.template.invalidname',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( '1' != $mailTemplateObject->template_type ) {
			$mailTemplateObject->template_type	= 0;
		}
		if( strlen($mailTemplateObject->open_flag) == 0 ) {
			$mailTemplateObject->open_flag	= 0;
		} else if( preg_match('/^[0-9]{1,3}$/',$mailTemplateObject->open_flag) == 0 ) {
			$request->addLocaledError('member.error.mail.template.invalidshare',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( strlen( $mailTemplateObject->template_number ) > 0 ){
			// 編集の場合、オーナー以外は共有設定を編集できない
			if( $loginUserObject->getUniqueId() != 'SYSADMIN'
				&& $mailTemplateObject->owner_id != $loginUserObject->getUniqueId() ) {
				$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		if( strlen(trim($mailTemplateObject->bgcolor)) == 0 ) {
		} else if( strlen(trim($mailTemplateObject->bgcolor)) > 8 ) {
			$request->addLocaledError('member.error.mail.invalidbgcolor',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( preg_match('/^(#|)[0-9a-fA-F]{6}$/',$mailTemplateObject->bgcolor) == 0 ) {
			$request->addLocaledError('member.error.mail.invalidbgcolor',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		
		if( $mailTemplateObject->template_type == 0 ) {
			if( strlen($mailTemplateObject->subject) == 0 ) {
				$request->addLocaledError('member.error.mail.requiresubject',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else if( strlen($mailTemplateObject->subject) > 240 ) {
				$request->addLocaledError('member.error.mail.invalidsubject',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
			if( strlen($mailTemplateObject->subject_mobile) == 0 ) {
			} else if( strlen($mailTemplateObject->subject_mobile) > 240 ) {
				$request->addLocaledError('member.error.mail.requiremsubject',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
			if( strlen($mailTemplateObject->mail_from_name) == 0 ) {
				$request->addLocaledError('member.error.mail.requirefromname',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else if( strlen($mailTemplateObject->mail_from_name) > 90 ) {
				$request->addLocaledError('member.error.mail.invalidfromname',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
			if( strlen($mailTemplateObject->mail_from_address) == 0 ) {
				$request->addLocaledError('member.error.mail.requirefrom',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else if( strlen($mailTemplateObject->mail_from_address) > 80 ) {
				$request->addLocaledError('member.error.mail.invalidfrom',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else if ( preg_match('/^([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9\._-]+)+$/',$mailTemplateObject->mail_from_address) == 0 ) {
				$request->addLocaledError('member.error.mail.invalidfrom',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
			if( strlen($mailTemplateObject->mail_reply_address) == 0 ) {
				$mailTemplateObject->mail_reply_address	= $mailTemplateObject->mail_from_address;
			} else if( strlen($mailTemplateObject->mail_reply_address) > 80 ) {
				$request->addLocaledError('member.error.mail.invalidreply',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else if ( preg_match('/^([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9\._-]+)+$/',$mailTemplateObject->mail_reply_address) == 0 ) {
				$request->addLocaledError('member.error.mail.invalidreply',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
			if( strlen($mailTemplateObject->mail_return_path) == 0 ) {
				$mailTemplateObject->mail_return_path	= $mailTemplateObject->mail_from_address;
			} else if( $mailTemplateObject->mail_return_path == 'system_auto' ) {
				$mailTemplateObject->mail_return_path	= 'system_auto';
			} else if( strlen($mailTemplateObject->mail_return_path) > 80 ) {
				$request->addLocaledError('member.error.mail.invalidreturn',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else if ( preg_match('/^([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9\._-]+)+$/',$mailTemplateObject->mail_return_path) == 0 ) {
				$request->addLocaledError('member.error.mail.invalidreturn',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else {
			$mailTemplateObject->subject			= '';
			$mailTemplateObject->subject_mobile		= '';
			$mailTemplateObject->mail_from_name		= '';
			$mailTemplateObject->mail_from_address	= '';
			$mailTemplateObject->mail_reply_address	= '';
			$mailTemplateObject->mail_return_path	= '';
		}
		
		if( strlen($mailTemplateObject->text_body_default) == 0 ) {
			$request->addLocaledError('member.error.mail.requirebody',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( strlen($mailTemplateObject->text_body_default) > 30000 ) {
			$request->addLocaledError('member.error.mail.invalidbody',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen($mailTemplateObject->text_body_mobile) > 30000 ) {
			$request->addLocaledError('member.error.mail.invalidmbody',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen($mailTemplateObject->html_body_default) > 30000 ) {
			$request->addLocaledError('member.error.mail.invalidhtmlbody',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen($mailTemplateObject->html_body_mobile) > 30000 ) {
			$request->addLocaledError('member.error.mail.invalidhtmlmbody',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen($mailTemplateObject->description) > 900 ) {
			$request->addLocaledError('member.error.mail.invalidadminmemo',SPIDER_LOG_LEVEL_FATAL,array(''));
		}

		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$resultString	= 'OK';
			$request->setSession($sessionConfirmName,$resultString);
		}
		$request->setSession($sessionObjectName,$mailTemplateObject);
		$request->setAttribute('member.mail.template.mail_template_object',$mailTemplateObject);

	}
}
?>