<?php
/*
 * member/mail/SendTest.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール 入力フォーム用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_SendTest extends system_login_ModuleBase {
	function member_mail_SendTest(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo			= $request->getAttribute( 'dbo' );
		$memberId		= $_GET['mi'];
		$selectType		= trim(stripslashes( $_GET['stype'] ));
		if( 'q' != $selectType && 's' != $selectType ) {
			$selectType		= 'm';
		}
		$sessionSuffix			= '_'.$selectType.'_';
		if(is_array($memberId)) {
			$sessionSuffix		.= implode('.',$memberId);
		} else {
			$sessionSuffix		.= trim($memberId);
		}
		$sessionObjectName	= MEMBER_SESSION_NAME_MAIL_OBJECT.$sessionSuffix;
		$sessionConfirmName	= MEMBER_SESSION_NAME_SENDMAIL_CONFIRM_RESULT.$sessionSuffix;
		$memberMailObject		= $request->getSession($sessionObjectName);
		$confirmMailObject	= spider_Controller::createObject('member_DaoMemberMail');
		$confirm_result			= $request->getSession($sessionConfirmName);
		
		if( 'OK' != $confirm_result ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( get_class( $confirmMailObject ) != get_class( $memberMailObject ) ) {
			// セッションに正しいオブジェクトがないならエラー
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			// セッションにオブジェクトがあるならテスト送信
			$targetAddresses	= trim(stripslashes($_POST['targetAddresses']));
			if( strlen($targetAddresses) == 0 ) {
//				$request->addError('テスト送信先メールアドレスを入力してください。');
			} else {
				// テスト送信先アドレスの取り出し
				$targetAddresses	= str_replace("\r\n","\n",$targetAddresses);
				$targetAddresses	= str_replace("\r","\n",$targetAddresses);
				while( false != strpos($targetAddresses,"\n\n") ) {
					$targetAddresses	= str_replace("\n\n","\n",$targetAddresses);
				}
				$targetAddressArray	= explode("\n",$targetAddresses);
				
				// テストメール送信の場合リターン先はfromに設定
				$memberMailObject->mail_return_path	= $memberMailObject->mail_from_address;
				
				// 会員パッケージ設定読み込み
				if( get_class(spider_Controller::createObject('member_PackageConfig')) != get_class($this->configuration_object) ) {
					$this->configuration_object	= spider_Controller::createObject('member_PackageConfig');
					if( $this->configuration_object->load( $request ) ) {
					} else {
						$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
				
				// 会員用メール送信オブジェクト作成
				$mailSendObject	= spider_Controller::createObject('member_mail_Send');
				
				foreach( $targetAddressArray as $targetAddress ) {
					$targetAddress	= trim($targetAddress);
					if( strlen($targetAddress) > 0 ) {
						// テスト送信用のダミー会員オブジェクトを作成
						$memberObject		= spider_Controller::createObject('member_DaoMember');
						$memberObject->pc_mail	= $targetAddress;
						$memberObject->mb_mail	= $targetAddress;
						$deliveryAddress	= $memberObject->pc_mail;
						if( 'm' == $memberMailObject->target_type ) {
							$deliveryAddress	= $memberObject->mb_mail;
						}
						if( strlen(trim($deliveryAddress)) == 0 ) {
							$request->addLocaledError('system.error.common.invalidaccess',SPIDER_LOG_LEVEL_FATAL,array(''));
							break;
						}
						$memberObject->member_id			= 'TESTSENDID';
						$memberObject->login_id				= 'TESTSENDLOGINID';
						$memberObject->login_password		= 'TESTSENDLOGINPW';
						$memberObject->view_name			= 'TESTSENDVIEWNAME';
						$memberObject->point				= 999;
						$memberObject->first_name			= '太郎';
						$memberObject->family_name			= 'テスト';
						$memberObject->first_kana			= 'タロウ';
						$memberObject->family_kana			= 'テスト';
						$memberObject->zip_code				= '000-0000';
						$memberObject->prefecture_number	= '8';
						$memberObject->address				= '豊島区';
						$memberObject->building				= '○○ビル';
						$memberObject->telephone_number		= '00-0000-0000';
						$memberObject->faximili_number		= '00-0000-0001';
						$memberObject->birth_year			= 1990;
						$memberObject->birth_month			= 1;
						$memberObject->birth_day			= 1;
						$memberObject->sex					= 1;
						$memberObject->blood_type			= 2;
						// メール内容オブジェクトを送信用にコピー
						$mailObject	 = null;
						if( preg_match('/^4/',phpversion()) > 0 ) {
							$mailObject	= $memberMailObject;
						} else {
							$mailObject	= clone $memberMailObject;
						}

						// 置換ワードに会員情報を設定
						$replaceWordHash	= array();
						$replaceWordHash['member']	= $memberObject;
						// メール送信実行
						$deliveryStatus	= $mailObject->sendMail( $request, $deliveryAddress, $replaceWordHash );
						// 送信状態ごとのエラーメッセージ
						switch ( $deliveryStatus ) {
							case 254:
								$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_FATAL,array($deliveryStatus));
								break;
							case 1:
								break;
							default:
								$request->addLocaledError('member.error.common.sendmail',SPIDER_LOG_LEVEL_FATAL,array($deliveryStatus));
								break;
						}
					}
				}
			}
		}
		$request->setAttribute('member.mail.mail_object',$memberMailObject );
	}
}
?>