<?php
/*
 * member/download/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoMember.class.php');
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
class member_download_Confirm extends system_login_ModuleBase {
	function member_download_Confirm(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		// 変数取得
		$dbo						= $request->getAttribute( 'dbo' );
		$member_class				= stripslashes( $_GET['mc'] );
		$select_type				= trim(stripslashes( $_GET['stype'] ));
		$session_name_csv_column	= MEMBER_SESSION_NAME_DOWNLOAD_CSV_COLUMN_DEFINITION . $member_class;
		if( 'q' != $select_type && 's' != $select_type ) {
			$select_type		= 'q';
		}
		// 一度に書き込む数を固定
		$write_at_once	= MEMBER_DOWNLOAD_WORK_AT_ONCE;
		// カラム定義
		$download_column_definition			= $GLOBALS['MEMBER_UPLOAD_COLUMN_DEFINITION'];
		$download_column_name_definition	= $GLOBALS['MEMBER_UPLOAD_COLUMN_NAME_DEFINITION'];
		// ダウンロードで作成する一時ファイルパス
		$downloadUri	= $request->getSession(MEMBER_SESSION_NAME_DOWNLOAD_CSV_FILE_URI);
		if ( strlen( $downloadUri ) > 0 ) {
			if ( system_DataFileWriter::delete( $request, $downloadUri, DIR_NAME_TMP ) ) {
			}
		}
		// 入力値のセット
		$vars				= get_class_vars('member_DaoMember');
		$member_object		= spider_Controller::createObject('member_DaoMember');
		$column_definition	= array();

		// 登録に必要な最低カラム数を確認
		$require_column_count	= 0;
		$not_has_required		= false;
		$has_not_numeric		= false;
		$item_key_array = array();
		foreach( $download_column_definition as $item_key => $order_number ) {
			$number = $request->getParam($item_key,'post');
			if( strlen(trim($number)) > 0 ) {
				if( is_numeric( $number ) && preg_match('/^[0-9]+$/', $number ) > 0 ) {
					$column_definition[$item_key]	= $number;
					if( $number > $require_column_count ) {
						$require_column_count	= $number;
					}
				} else {
					if( !$has_not_numeric ) {
						$request->addLocaledError('member.error.common.invalidorder',SPIDER_LOG_LEVEL_FATAL,array());
						$has_not_numeric	= true;
					}
				}
			}
		}
		if ( count($column_definition)==0 ) {
			$request->addLocaledError('system.error.common.csvdl.selectcolumn',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			asort( $column_definition );
			$request->setSession( $session_name_csv_column, $column_definition );
		}
		
		if ( !$request->isError() ) {
			// ダウンロードする対象クエリの確認
			$total_count		= 0;
			if( 'q' == $select_type ) {
				$load_count_query	= $request->getSession(MEMBER_SESSION_NAME_LOADCOUNT_QUERY);
				$load_list_query	= $request->getSession(MEMBER_SESSION_NAME_LOADLIST_QUERY);
			} else if( 's' == $select_type ) {
				$sessionSelectedHash			= $request->getSession( MEMBER_SESSION_NAME_SELECTED_LIST );
				if( !is_array($sessionSelectedHash) ) {
					$sessionSelectedHash		= array();
				}
				$query_condition	= " WHERE member_id IN ('" . implode( "','", array_keys($sessionSelectedHash) ) . "')";
				$load_count_query	= "SELECT COUNT(DISTINCT(member_id)) FROM " . TABLE_NAME_MEMBER . $query_condition;
				$load_list_query	= "SELECT DISTINCT(member_id) FROM " . TABLE_NAME_MEMBER . $query_condition;
			}
			if( strlen(trim($load_count_query)) == 0 || strlen(trim($load_count_query)) == 0 ) {
				$request->addLocaledError('system.error.common.invalidaccess',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else {
				$total_count	= $dbo->queryOne($load_count_query);
				if ( $total_count === false ) {
					$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($load_count_query));
				}
			}
		}
		$request->setAttribute(MEMBER_SESSION_NAME_DOWNLOAD_CSV_COLUMN_DEFINITION, $column_definition );
		$request->setAttribute('member.download.write_at_once', $write_at_once );
		$request->setAttribute('member.download.total_count', $total_count );
		$request->setAttribute('member.download.member_class', $member_class );
		$request->setAttribute('member.download.select_type', $select_type );
	}
}
?>