<?php
/*
 * member/DaoMemberCorrespond.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname( __FILE__ )
.DIRECTORY_SEPARATOR.'package_define.inc.php' );
require_once( dirname( __FILE__ )
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname( __FILE__ )
.DIRECTORY_SEPARATOR.'DaoMemberCorrespondComment.class.php' );
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'CharUtility.class.php' );
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'AbstractData.class.php' );
/**
 * 会員テーブルレコード対応 DAOクラス
 * 
 * @package member 会員管理パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_DaoMemberCorrespond extends database2_AbstractData {
	/** シリアル番号	*/
	var $correspond_number;
	/** 対応ID	*/
	var $correspond_id;
	/** 会員ID	*/
	var $member_id;
	/** 対応開始タイプ: 0=自己発信, 10=お客様発信	*/
	var $correspond_type	= 0;
	/** 対応方法: 0=メール, 10=電話, 20=FAX, 30=郵送, 100=訪問, 110=来社, 200=その他	*/
	var $correspond_method	= 0;
	/** 対応カテゴリID	*/
	var $category_id;
	/** 概要	*/
	var $description;
	/** 詳細	*/
	var $detail_note;
	/** 状態フラグ: 0=新規, 11=要次対応, 51=回答待ち, 101=完了, 255=削除	*/
	var $status_flag	= 0;
	/** 対応開始日	*/
	var $start_date;
	/** 最終対応日	*/
	var $correspond_date;
	/** 更新日時	*/
	var $updated_date;
	/** 登録日時	*/
	var $registered_date;
	/** 所有者ID	*/
	var $owner_id;
	/** 更新者ID	*/
	var $modifier_id;
	
	/* オブジェクト拡張	*/
	/** 対応コメント配列	*/
	var $commentObjectArray		= array();
	
	/**
	 * コンストラクタ
	 */
	function member_DaoMemberCorrespond(){
		$this->commentObjectArray		= array();
	}
	/**
	 * オプションテーブルを読み込む
	 */
	function loadRelation( $dbo ) {
		$sql	= 'SELECT * FROM '.TABLE_NAME_MEMBER_CORRESPOND_COMMENT
			.' WHERE correspond_id='.$dbo->quote($this->correspond_id)
			.' AND status_flag<200 '
			.' ORDER BY correspond_date DESC'
		;
		$object	= spider_Controller::createObject('member_DaoMemberCorrespondComment');
		$result	= $dbo->queryAll( $sql, $object );
		if( $result === false ) {
			return false;
		} else {
			$this->commentObjectArray		= $result;
		}
	}
}
?>