<?php
/*
 * design/PackageConfig.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 * 
 * design_PackageConfig
 * ver 1.0.02 build on 2010-03-31
 * 
 * [変更履歴]
 * 2010-04-13
 * テンプレート変数をビルド時にrequestオブジェクトに同名でsetAttributeするように機能を追加しました。
 * 変更クラス
 * design_DaoTemplate
 * design_template_Preview
 * 2010-03-31
 * system_package_PackageConfigBaseクラスのinstallメソッドとuninstallメソッドを呼び出すよう変更。
 * 
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'package_define.inc.php');
require_once(dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'package'
	.DIRECTORY_SEPARATOR.'PackageConfigBase.class.php' );
require_once(dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'DataFileWriter.class.php' );
require_once(dirname(__FILE__)
	.DIRECTORY_SEPARATOR.'DaoTemplate.class.php' );
if( file_exists(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'design.define.inc.php') ) {
	require_once(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'design.define.inc.php');
}
/**
 * デザインパッケージ基本情報保持クラス
 * 
 * - 概要
 *   デザインテンプレートを操作するパッケージです。
 * - バージョン
 *   1.0
 * - 対応データベース
 *   不要
 * - パッケージの詳細
 *   デザインテンプレートを操作するパッケージです。
 * 
 * @package design デザインパッケージ
 * @version 1.1.00
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.3
 * 
 */
class design_PackageConfig extends system_package_PackageConfigBase {
	function design_PackageConfig() {
		$this->definitionHash			= array(
			'DESIGN_URI'					=> '/',
		);
	}
	/**
	 * パッケージの表示順序を取得
	 * @return int パッケージ順序
	 */
	function getPackageOrder() {
		return 2;
	}
	/**
	 * パッケージの表示名を取得
	 * @return string パッケージ名称
	 */
	function getPackageViewName() {
		return 'デザイン管理';
	}
	/**
	 * パッケージ概要説明を取得します。
	 */
	function getPackageDescription() {
		return '管理パネルからデザインを変更したり、デザインテンプレートの登録・編集をおこないます。formerシリーズのデザインテンプレートの作成・編集方法は共通です。詳しくは<a href="http://sourceforge.jp/projects/shopformer/" target="_blank">shopformer</a>のプロジェクトページをご覧ください。';
	}
	/**
	 * トップページで表示するパッケージ設定のアラートメッセージを取得します
	 */
	function getAlertMessages( & $request ) {
		if( $this->isInstall() ) {
			require_once(dirname(__FILE__).'/template/LoadList.class.php');
			$loadListModule	= new design_template_LoadList();
			$loadListModule->execute($request);
			$templateHash	= $request->getAttribute('design.template.templateInfoHash');
			$needSetting	= false;
			foreach( $templateHash as $templateObject ) {
				if( !$templateObject->isSetup ) {
					$needSetting	= true;
					break;
				}
			}
			if( $needSetting ) {
				return '<p style="color:#ff6060;font-weight:bold;">設定が完了していないデザインテンプレートがあります！<br />'
					.'デザイン管理の<a href="./design/template/">デザインテンプレートの管理</a>からテンプレートの設定をおこなってください。</p>'
					.'<p style="text-align:right;"><a href="./design/template/">&gt;&gt; テンプレート設定へ</a></p>';
			}
		} else {
			return '<p style="color:#ff6060;font-weight:bold;">デザイン管理パッケージのインストールと基本設定を行ってください<br />'
				.'システム設定の<a href="./system/package/">パッケージ管理</a>でインストールできます。</p>'
				.'<p style="text-align:right;"><a href="./system/package/install/form.php?sitpi=design">&gt;&gt; デザイン管理パッケージのインストールへ</a></p>'
			;
		}
		return '';
	}
	/**
	 * パッケージ依存関係のハッシュを取得
	 * @return hash array('packageId'=>array('version','version',...))
	 */
	function getPackageDependenciesHash() {
		return array(
			'system'	=> array('1.2.00'),
		);
	}
	/*
	 * インストール関連のメソッド
	 */
	/**
	 * インストールを実行します。
	 */
	function install( & $request ) {
		if( parent::install( $request ) ) {
			$defaultFileName			= 'default.fmt';
			$devaultViewName			= '標準テンプレート';
			$defaultTemplateFilePath	= DIR_PATH_SPIDER.DIRECTORY_SEPARATOR.$defaultFileName;
			if( file_exists($defaultTemplateFilePath) ) {
				$templateObject	= new design_DaoTemplate($defaultFileName);
				if( $templateObject->recover( $request, $defaultTemplateFilePath, $devaultViewName, '', false
				,true, true, true, $defaultFileName ) ) {
					foreach( $GLOBALS['SPIDER_USER_AGENT_CLASS_HASH'] as $aKey => $aName ) {
						$templateObject->rebuild( $request, $aKey );
					}
					return true;
				} else {
					return false;
				}
			}
			return true;
		}
		return false;
	}
	/*
	 * アンインストール関連メソッド
	 */
	/**
	 * アンインストールを実行します。
	 */
	function uninstall( & $request ) {
		return parent::uninstall( $request );
	}
}
?>