<?php
/*
 * database2/Connect.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'spider'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Connection.class.php');
/**
 * spider : データベース接続用アクションモジュールクラス
 * 
 * spiderのページから呼び出して実行します。
 * 設定ファイルdefine.inc.phpに記述したデータベース接続情報を元に
 * database.Connection実装クラスのインスタンスを作成してデータベースに接続し
 * リクエスト属性「database.connection」として登録します。
 * 
 * @package database データベースパッケージ
 * @version 2.0.0
 * @author <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class database2_Connect extends spider_ModuleBase {
	function database2_Connect() {
	}
	function execute( & $request ) {	
		$databaseType	= $request->getAttribute('database.type');
		$databaseName	= $request->getAttribute('database.name');
		$databaseUser	= $request->getAttribute('database.user');
		$databasePass	= $request->getAttribute('database.pass');
		$databaseHost	= $request->getAttribute('database.host');
		$databasePort	= $request->getAttribute('database.port');
		$connection		= false;
		if( file_exists(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'database2.define.inc.php') ) {
			require_once(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'database2.define.inc.php');
		}
		if( strlen( $databaseType ) > 0
			&& strlen($databaseName) > 0
			&& strlen($databaseUser) > 0
			&& strlen($databasePass) > 0
		) {
			// 接続情報が属性登録されているなら属性情報指定のデータベースに接続
			$connection	= new database2_Connection( $request, $databaseName,
				$databaseUser, $databasePass, $databaseType, $databaseHost, $databasePort );
		} else if( defined('DATABASE_DATABASE_TYPE')
			&& defined('DATABASE_DATABASE_NAME')
			&& defined('DATABASE_DATABASE_USER')
			&& defined('DATABASE_DATABASE_PASSWORD')
		){
			// 接続情報が属性にないならdefine値にあれば接続
			$host	= null;
			if( defined('DATABASE_DATABASE_HOST') ) {
				$host	= DATABASE_DATABASE_HOST;
			} else if( is_array($GLOBALS['DATABASE_DATABASE_HOST']) ) {
				$host	= $GLOBALS['DATABASE_DATABASE_HOST'];
			}
			$port	= null;
			if( defined('DATABASE_DATABASE_PORT') ) {
				$port	= DATABASE_DATABASE_PORT;
			} else if( is_array($GLOBALS['DATABASE_DATABASE_PORT']) ) {
				$port	= $GLOBALS['DATABASE_DATABASE_PORT'];
			}
			$connection	= new database2_Connection( $request, DATABASE_DATABASE_NAME,
				DATABASE_DATABASE_USER, DATABASE_DATABASE_PASSWORD, DATABASE_DATABASE_TYPE, $host, $port );
		}
		if( $connection === false ) {
			$request->addLocaledError('database2.error.noconnect',SPIDER_LOG_LEVEL_FATAL,array());
		} else {
			$request->setAttribute('dbo', $connection );
			$request->setAttribute('database.connection', $connection );
		}
	}
	function post_process( & $request ) {
		$connection	= $request->getAttribute('database.connection');
		if( !is_null( $connection ) ) {
			$connection->disconnect();
			$connection	= null;
			$request->setAttribute('database.connection',$connection);
			$request->setAttribute('dbo',$connection);
		}
	}
}
?>