<?php
/*
 * content/DaoWidget.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-08-23
 */
require_once(dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'AbstractData.class.php');
require_once(dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
require_once( dirname(__FILE__)
	. DIRECTORY_SEPARATOR . 'package_define.inc.php' );
require_once( dirname(__FILE__)
	. DIRECTORY_SEPARATOR . 'Variable.class.php' );
class content_DaoWidget extends system_AbstractData {
	/** ウィジェットファイル名	*/
	var $file_name;
	/** ウィジェット名	*/
	var $widget_name;
	/** ウィジェット概要説明	*/
	var $description;
	/**
	 * コンストラクタ
	 */
	function content_DaoWidget( $file_name = null ) {
		if( !is_null($file_name) ) {
			$this->file_name	= $file_name;
		}
	}
	/**
	 * ファイル名の書式が正しいか確認します
	 */
	function validateFileName() {
		if( is_null($this->file_name) || strlen($this->file_name) == 0 ) {
			return false;
		} else if( preg_match('/^[0-9a-zA-Z\\_\\.]+$/',$this->file_name) == 0 ) {
			return false;
		}
		return true;
	}
	/**
	 * ウィジェット情報の保存ルートURIを取得
	 */
	function getSaveUri( & $request ) {
		return '/content/widget/'.$this->file_name;
	}
	/**
	 * 本文保存ファイルURIを取得します
	 */
	function getBodyFileUri( & $request, $agent, $dynamicUri=null ) {
		if( is_null($dynamicUri) || strlen($dynamicUri) == 0 ) {
			$dynamicUri	= '/';
		}
		if( preg_match('/^\\//',$dynamicUri) == 0 ) {
			$dynamicUri	= '/'.$dynamicUri;
		}
		if( preg_match('/\\/$/',$dynamicUri) == 0 ) {
			$dynamicUri	.= '/';
		}
		$uri	= '/'.$agent.$dynamicUri.$this->file_name;
		return $uri;
	}
	/**
	 * ウィジェットの基本情報を読み込みます
	 */
	function load( & $request ) {
		if( $this->validateFileName() ) {
			$fileUri	= $this->getSaveUri( $request ).'/info.txt';
			if( system_DataFileWriter::isExists( $request, $fileUri ) ) {
				// ファイルが存在するなら読み込み
				$strings	= system_DataFileWriter::getContents( $request, $fileUri );
				if( !$request->isError() && strlen($strings) > 0 ) {
					$strings	= str_replace("\r\n","\n",$strings);
					$strings	= str_replace("\r","\n",$strings);
					$lines		= explode("\n",$strings);
					foreach( $lines as $line ) {
						$line	= trim($line);
						if( strlen($line) > 0 ) {
							list( $varName, $varVal )	= explode("\t",$line);
							$this->$varName	= $varVal;
						}
					}
					return true;
				}
			}
		}
		return false;
	}
	/**
	 * ウィジェット情報を保存します
	 */
	function save( & $request ) {
		if( $this->validateFileName() ) {
			$fileUri	= $this->getSaveUri( $request ).'/info.txt';
			// 保存情報
			$strings	= "file_name\t".$this->file_name."\n";
			$strings	.= "widget_name\t".$this->widget_name."\n";
			$this->description	= str_replace("\r\n","\n",$this->description);
			$this->description	= str_replace("\r","\n",$this->description);
			$this->description	= str_replace("\n"," ",$this->description);
			$strings	.= "description\t".$this->description."\n";
			$writer		= new system_DataFileWriter();
			if( $writer->open( $request, $fileUri, 'w' ) ) {
				$writer->write($strings);
				$writer->close( $request );
			} else {
				return false;
			}
		} else {
			return false;
		}
		if( $request->isError() ) {
			return false;
		} else {
			return true;
		}
	}
	/**
	 * 指定エージェントのウィジェット本文を取得する
	 */
	function getBody( & $request, $agent, $dynamicUri=null ) {
		if( $this->validateFileName() ) {
			$saveRootUri	= $this->getSaveUri( $request );
			$bodyFileUri	= $saveRootUri.$this->getBodyFileUri( $request, $agent, $dynamicUri );
			$bodyFileUri	= dirname($bodyFileUri).'/body.tpl';
			if( system_DataFileWriter::isExists( $request,$bodyFileUri ) ) {
				// dataフォルダ内に指定ダイナミックパスのファイルが存在するなら
				return system_DataFileWriter::getContents($request,$bodyFileUri);
			} else if( strlen($dynamicUri) > 1 ){
				// 指定ダイナミックパスのファイルがdataフォルダ内に存在しないなら上位フォルダを確認
				$bodyFileDir	= dirname(dirname($bodyFileUri));
				while( strlen($bodyFileDir) > strlen($saveRootUri) ) {
					$bodyFileUri	= $bodyFileDir.'/'.$thid->file_name;
					if( system_DataFileWriter::isExists( $request,$bodyFileUri ) ) {
						return system_DataFileWriter::getContents($request,$bodyFileUri);
					}
					$bodyFileDir	= dirname($bodyFileDir);
				}
			}
			// dataフォルダ内に存在しなかった場合はwidgetフォルダ内を読み込む
			$bodyFileUri	= $this->getBodyFileUri( $request, $agent, $dynamicUri );
			if( system_DataFileWriter::isExists( $request,$bodyFileUri,DIR_NAME_WIDGETS ) ) {
				// dataフォルダ内に指定ダイナミックパスのファイルが存在するなら
				return system_DataFileWriter::getContents($request,$bodyFileUri,DIR_NAME_WIDGETS);
			} else if( strlen($dynamicUri) > 1 ){
				// 指定ダイナミックパスのファイルがdataフォルダ内に存在しないなら上位フォルダを確認
				$bodyFileDir	= dirname(dirname($bodyFileUri));
				while( strlen($bodyFileDir) > 1 ) {
					$bodyFileUri	= $bodyFileDir.'/'.$thid->file_name;
					if( system_DataFileWriter::isExists( $request,$bodyFileUri,DIR_NAME_WIDGETS ) ) {
						return system_DataFileWriter::getContents($request,$bodyFileUri,DIR_NAME_WIDGETS);
					}
					$bodyFileDir	= dirname($bodyFileDir);
					if('\\'==$bodyFileDir) {
						$bodyFileDir	= '/';
					}
				}
			}
		}
		return '';
	}
	/**
	 * 指定エージェントのウィジェット本文を保存する
	 */
	function saveBody( & $request, $agent, $body, $dynamicUri=null ) {
		if( $this->validateFileName() ) {
			$saveRootUri	= $this->getSaveUri( $request );
			$bodyFileUri	= $saveRootUri.$this->getBodyFileUri( $request, $agent, $dynamicUri );
			$bodyFileUri	= dirname($bodyFileUri).'/body.tpl';
			if( strlen($body) > 0 ) {
				$writer			= new system_DataFileWriter();
				if( $writer->open($request,$bodyFileUri,'w' ) ) {
					$writer->write($body);
					$writer->close($request);
					return true;
				}
			} else {
				system_DataFileWriter::delete($request,$bodyFileUri);
				return true;
			}
		}
		return false;
	}
	/**
	 * 全てのウィジェットをリビルドする
	 */
	function rebuildAll( & $request, $dynamicUri=null ) {
		if( !$this->validateFileName() ) {
			return false;
		}
		foreach( $GLOBALS['SPIDER_USER_AGENT_CLASS_HASH'] as $agent => $agentName ) {
			$this->rebuild( $request, $agent, $dynamicUri );
		}
	}
	/**
	 * 指定エージェントのウィジェットをリビルドする
	 */
	function rebuild( & $request, $agent, $dynamicUri=null ) {
		if( !$this->validateFileName() ) {
			return false;
		}
		$bodyStrings	= $this->getBody( $request, $agent, $dynamicUri );
		$bodyFileUri	= $this->getBodyFileUri( $request, $agent, $dynamicUri );
		if( strlen( $bodyStrings ) > 0 ) {
			// サイト変数を読み込む
			$variableObject	= new content_Variable( $request );
			// サイト変数の置換処理
			$keyArray	= $variableObject->getKeyArray( $request );
			if( is_array($keyArray) ) {
				foreach( $keyArray as $key ) {
					$repWord		= '{value:'.$key.'}';
					$bodyStrings	= str_replace($repWord,$variableObject->getValue( $request, $key ),$bodyStrings);
				}
				// ウィジェットディレクトリに出力
				$writer			= new system_DataFileWriter();
				if( $writer->open( $request, $bodyFileUri, 'w', DIR_NAME_WIDGETS ) ) {
					$writer->write( $bodyStrings );
					$writer->close( $request );
				}
			}
		} else {
			// 本文がないならファイルを削除する
			system_DataFileWriter::delete( $request, $bodyFileUri, DIR_NAME_WIDGETS );
		}
	}
	/**
	 * ウィジェット関連ファイルを全て削除する
	 */
	function deleteAll( & $request, $dynamicUri=null ) {
		if( !$this->validateFileName() ) {
			return false;
		}
		// 全てのファイルを削除
		$saveRootUri	= $this->getSaveUri( $request );
		foreach( $GLOBALS['SPIDER_USER_AGENT_CLASS_HASH'] as $agent => $agentName ) {
			$bodyFileUri	= $saveRootUri.$this->getBodyFileUri( $request, $agent, $dynamicUri );
			system_DataFileWriter::delete( $request, $bodyFileUri, DIR_NAME_DATA );
			$bodyFileUri	= $this->getBodyFileUri( $request, $agent, $dynamicUri );
			system_DataFileWriter::delete( $request, $bodyFileUri, DIR_NAME_WIDGETS );
		}
	}
	/**
	 * このウィジェットの本文で利用されているファイルの一覧を取得します
	 */
	function getRelatedFileUriArray( & $request, $dynamicUri=null ) {
		if( !$this->validateFileName() ) {
			return false;
		}
		$fileUriArray	= array();
		foreach( $GLOBALS['SPIDER_USER_AGENT_CLASS_HASH'] as $agent => $agentName ) {
			$body	= $this->getBody( $request, $agent, $dynamicUri );
			// 外部src
			if( preg_match_all( '/[sS][rR][cC]\\=[\'\"](\\/[^\'\"]+\\.[a-zA-Z]+)[\'\"]/'
				, $body
				, $matcheArray
				, PREG_PATTERN_ORDER ) > 0 ) {
				$fileUriArray	= array_merge($fileUriArray,$matcheArray[1]);
			}
		}
		// 重複削除
		$fileUriArray	= array_unique($fileUriArray);
		return array_unique($fileUriArray);
	}
}
?>