<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.calendar.Load}
{preset:page_title 'ショップ管理 > 営業日カレンダー'}
	<script language="JavaScript" type="text/javascript" src="/js/reserve.js" charset="UTF-8"></script>
	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">ショップ管理</a>
		&gt; <a href="./">営業日カレンダー</a>
		{if:is_object(shopping.product.product_object)}
		&gt; <a href="../product/detail.php?shpdi={write:shopping.product.product_object->'product_id'}">{write:shopping.product.product_object->'product_name'}</a>
		{/if}
		{if:is_object(shopping.product.unit.unit_object)}
		&gt; {write:shopping.product.unit.unit_object->'unit_name'}
		{/if}
	</div>

	<h1>
		ショップ管理 &gt; 営業日カレンダー
		{if:is_object(shopping.product.product_object)}&gt; {write:shopping.product.product_object->'product_name'}{/if}
		{if:is_object(shopping.product.unit.unit_object)}&gt; {write:shopping.product.unit.unit_object->'unit_name'}{/if}
	</h1>

	{if:IS_ERROR}
	<ul class="error">
		{foreach:errors error}
			<li>{write:error}</li>
		{/foreach}
	</ul>
	{/if}
	
	<form name="sform" method="get" action="./index.php">
	<input type="hidden" name="shpdi" value="{write:shopping.calendar.productId}" />
	<input type="hidden" name="shpui" value="{write:shopping.calendar.unitId}" />
	<div style="width:96%;margin:0 auto;font-size:large;">
		<select name="sclty">
		<?php for( $year = date('Y')+1; $year>date('Y')-3; $year-- ) { ?>
			<option value="<?php echo $year; ?>"
				<?php if($year==$GLOBALS['shopping.calendar.targetYear'] ) { ?> selected<?php } ?>
			><?php echo $year; ?></option>
		<?php } ?>
		</select>年<select name="scltm" onchange="shoppingCalendarRenew();">
		<?php for( $month = 1; $month<=12; $month++ ) { ?>
			<option value="<?php echo $month; ?>"
				<?php if($month==$GLOBALS['shopping.calendar.targetMonth'] ) { ?> selected<?php } ?>
			><?php echo $month; ?></option>
		<?php } ?>
		</select>月
	</div>
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="javascript:shoppingCalendarCheckAllOn()">全て選択</a>
		/
		<a href="javascript:shoppingCalendarCheckAllOff()">全て解除</a>
		/
		<a href="javascript:shoppingCalendarCheckAllRev()">選択反転</a>
	</div>
	</form>

	<form name="mform" method="post" action="">
	<input type="hidden" name="product_id" value="{write:shopping.calendar.productId}" />
	<input type="hidden" name="unit_id" value="{write:shopping.calendar.unitId}" />
	<div id="shopping-calendar-area"></div>
	<p style="text-align:right;">
		チェックした日付の営業時間<select name="start_time">
		<?php for( $num=0; $num<=24; $num++ ) { ?>
			<option value="<?php printf('%02d',$num); ?>:00"
				<?php if( $num==9 ) { ?> selected <?php } ?>
			><?php printf('%02d',$num); ?>:00</option>
		<?php } ?>
		</select>から<select name="close_time">
		<?php for( $num=0; $num<=24; $num++ ) { ?>
			<option value="<?php printf('%02d',$num); ?>:00"
				<?php if( $num==17 ) { ?> selected <?php } ?>
			><?php printf('%02d',$num); ?>:00</option>
		<?php } ?>
		</select>を
		{if:is_object(shopping.product.unit.unit_object)}
		<input type="text" name="price_sell" size="10" value="" />円
		在庫数<input type="text" name="stock" size="3" value="" />で
		{/if}
		追加する ＞ <input type="button" value="実行" onclick="shoppingCalendarSetTime()" />
	</p>
	</form>

	<h2>期間設定</h2>
	<form name="termForm" method="post" action="">
	<input type="hidden" name="product_id" value="{write:shopping.calendar.productId}" />
	<input type="hidden" name="unit_id" value="{write:shopping.calendar.unitId}" />
	<input type="hidden" name="start_date" value="" />
	<input type="hidden" name="close_date" value="" />
	<p style="text-align:right;">
		<select name="start_date_year">
		<?php for( $year = date('Y')+1; $year>date('Y')-3; $year-- ) { ?>
			<option value="<?php echo $year; ?>"
				<?php if($year==$GLOBALS['shopping.calendar.targetYear'] ) { ?> selected<?php } ?>
			><?php echo $year; ?></option>
		<?php } ?>
		</select>年<select name="start_date_month">
		<?php for( $month = 1; $month<=12; $month++ ) { ?>
			<option value="<?php echo $month; ?>"
				<?php if($month==$GLOBALS['shopping.calendar.targetMonth'] ) { ?> selected<?php } ?>
			><?php echo $month; ?></option>
		<?php } ?>
		</select>月<select name="start_date_day">
		<?php for( $day = 1; $day<=31; $day++ ) { ?>
			<option value="<?php echo $day; ?>"
				<?php if($day==date('d')) { ?> selected<?php } ?>
			><?php echo $day; ?></option>
		<?php } ?>
		</select>日
		～
		<select name="close_date_year">
		<?php for( $year = date('Y')+1; $year>date('Y')-3; $year-- ) { ?>
			<option value="<?php echo $year; ?>"
				<?php if($year==$GLOBALS['shopping.calendar.targetYear'] ) { ?> selected<?php } ?>
			><?php echo $year; ?></option>
		<?php } ?>
		</select>年<select name="close_date_month">
		<?php for( $month = 1; $month<=12; $month++ ) { ?>
			<option value="<?php echo $month; ?>"
				<?php if($month==$GLOBALS['shopping.calendar.targetMonth'] ) { ?> selected<?php } ?>
			><?php echo $month; ?></option>
		<?php } ?>
		</select>月<select name="close_date_day">
		<?php for( $day = 1; $day<=31; $day++ ) { ?>
			<option value="<?php echo $day; ?>"
				<?php if($day==date('t')) { ?> selected<?php } ?>
			><?php echo $day; ?></option>
		<?php } ?>
		</select>日
		を<br />
		営業時間<select name="start_time">
		<?php for( $num=0; $num<=24; $num++ ) { ?>
			<option value="<?php printf('%02d',$num); ?>:00"
				<?php if( $num==9 ) { ?> selected <?php } ?>
			><?php printf('%02d',$num); ?>:00</option>
		<?php } ?>
		</select>から<select name="close_time">
		<?php for( $num=0; $num<=24; $num++ ) { ?>
			<option value="<?php printf('%02d',$num); ?>:00"
				<?php if( $num==17 ) { ?> selected <?php } ?>
			><?php printf('%02d',$num); ?>:00</option>
		<?php } ?>
		</select>を
		{if:is_object(shopping.product.unit.unit_object)}
		<input type="text" name="price_sell" size="10" value="" />円
		在庫数<input type="text" name="stock" size="3" value="" />で
		{/if}
		全て<input type="button" value="営業日にする" onclick="shoppingCalendarAddTerm()" />
	</p>
	</form>
	
	<h2>期間削除</h2>
	<form name="deleteForm" method="post" action="">
	<input type="hidden" name="product_id" value="{write:shopping.calendar.productId}" />
	<input type="hidden" name="unit_id" value="{write:shopping.calendar.unitId}" />
	<input type="hidden" name="start_date" value="" />
	<input type="hidden" name="close_date" value="" />
	<p style="text-align:right;">
		<select name="start_date_year">
		<?php for( $year = date('Y')+1; $year>date('Y')-3; $year-- ) { ?>
			<option value="<?php echo $year; ?>"
				<?php if($year==$GLOBALS['shopping.calendar.targetYear'] ) { ?> selected<?php } ?>
			><?php echo $year; ?></option>
		<?php } ?>
		</select>年<select name="start_date_month">
		<?php for( $month = 1; $month<=12; $month++ ) { ?>
			<option value="<?php echo $month; ?>"
				<?php if($month==$GLOBALS['shopping.calendar.targetMonth'] ) { ?> selected<?php } ?>
			><?php echo $month; ?></option>
		<?php } ?>
		</select>月<select name="start_date_day">
		<?php for( $day = 1; $day<=31; $day++ ) { ?>
			<option value="<?php echo $day; ?>"
				<?php if($day==date('d')) { ?> selected<?php } ?>
			><?php echo $day; ?></option>
		<?php } ?>
		</select>日
		～
		<select name="close_date_year">
		<?php for( $year = date('Y')+1; $year>date('Y')-3; $year-- ) { ?>
			<option value="<?php echo $year; ?>"
				<?php if($year==$GLOBALS['shopping.calendar.targetYear'] ) { ?> selected<?php } ?>
			><?php echo $year; ?></option>
		<?php } ?>
		</select>年<select name="close_date_month">
		<?php for( $month = 1; $month<=12; $month++ ) { ?>
			<option value="<?php echo $month; ?>"
				<?php if($month==$GLOBALS['shopping.calendar.targetMonth'] ) { ?> selected<?php } ?>
			><?php echo $month; ?></option>
		<?php } ?>
		</select>月<select name="close_date_day">
		<?php for( $day = 1; $day<=31; $day++ ) { ?>
			<option value="<?php echo $day; ?>"
				<?php if($day==date('t')) { ?> selected<?php } ?>
			><?php echo $day; ?></option>
		<?php } ?>
		</select>日
		の営業日を全て<input type="button" value="削除する" onclick="shoppingCalendarDeleteTerm()" />
	</p>
	</form>
	
<script type="text/javascript"><!--
var shoppingCalendarHttpObject;
//
// カレンダーに営業時間を設定する
//
function shoppingCalendarSetTime() {
	var elements	= document.getElementsByName('target_date[]');
	shoppingCalendarSelectdDateArray	= new Array();
	for( var num=0; num<elements.length; num++ ) {
		var checkBox	= elements[num];
		if( checkBox.checked ) {
			shoppingCalendarSelectdDateArray.push(checkBox.value);
		}
	}
	shoppingCalendarSetTimePost();
}
function shoppingCalendarSetTimePost() {
	var startTime	= document.mform.start_time.options[document.mform.start_time.selectedIndex].value;
	var closeTime	= document.mform.close_time.options[document.mform.close_time.selectedIndex].value;
	var productId	= document.mform.product_id.value;
	var unitId		= document.mform.unit_id.value;
	var priceSell	= '';
	if( document.mform.price_sell){
		priceSell	= document.mform.price_sell.value;
	}
	if( shoppingCalendarSelectdDateArray.length > 0 ) {
		var targetDate	= shoppingCalendarSelectdDateArray.shift();
		var contents	= 'start_date='+encodeURIComponent(targetDate+' '+startTime)
		+'&close_date='+encodeURIComponent(targetDate+' '+closeTime)
		+'&product_id='+encodeURIComponent(productId)
		+'&unit_id='+encodeURIComponent(unitId)
		+'&price_sell='+encodeURIComponent(priceSell);
		shoppingCalendarHttpObject	= FormerCommon.createHttpRequest(shoppingCalendarSetTimePostResult);
		if( shoppingCalendarHttpObject ) {
			FormerCommon.displayGrayOut(9999);
			shoppingCalendarHttpObject.open("POST",'./add.php',true);
			shoppingCalendarHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
			shoppingCalendarHttpObject.send(contents);
		} else {
			alert('サーバー通信作成に失敗しました!');
		}
	} else {
		shoppingCalendarRenew();
	}
}
function shoppingCalendarSetTimePostResult() {
	if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status == 200)){
	    var lines	= shoppingCalendarHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
	    	shoppingCalendarSetTimePost();
	    } else {
	    	alert(shoppingCalendarHttpObject.responseText);
	    	setTimeout(FormerCommon.displayWhiteIn, 100);
	    }
	} else if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status != 200)){
		alert('状態変更中にサーバー通信に失敗しました');
		setTimeout(FormerCommon.displayWhiteIn, 100);
	}
}
//
// カレンダーから指定の営業時間を削除する
//
function shoppingCalendarDeleteTime(scheduleNumber){
	var contents	= 'schedule_number='+encodeURIComponent(scheduleNumber);
	shoppingCalendarHttpObject	= FormerCommon.createHttpRequest(shoppingCalendarDeleteTimeResult);
	if( shoppingCalendarHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		shoppingCalendarHttpObject.open("POST",'./delete.php',true);
		shoppingCalendarHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingCalendarHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingCalendarDeleteTimeResult() {
	if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status == 200)){
	    var lines	= shoppingCalendarHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
			shoppingCalendarRenew();
	    } else {
	    	alert(shoppingCalendarHttpObject.responseText);
			setTimeout(FormerCommon.displayWhiteIn, 100);
	    }
	} else if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status != 200)){
		alert('状態変更中にサーバー通信に失敗しました');
		setTimeout(FormerCommon.displayWhiteIn, 100);
	}
}
//
// カレンダー表示を更新する
//
function shoppingCalendarRenew(){
	var targetYear	= document.sform.sclty.options[document.sform.sclty.selectedIndex].value;
	var targetMonth	= document.sform.scltm.options[document.sform.scltm.selectedIndex].value;
	var productId	= document.mform.product_id.value;
	var unitId		= document.mform.unit_id.value;
	shoppingCalendarHttpObject	= FormerCommon.createHttpRequest(shoppingCalendarRenewResult);
	if( shoppingCalendarHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		var url	= './cal.php?sclty='
		+targetYear+'&scltm='
		+targetMonth+'&shpdi='
		+encodeURIComponent(productId)
		+'&shpui='+encodeURIComponent(unitId);
		if( ( unitId && unitId.length>0 ) || productId && productId.length>0 ){
			url	+= '&sclignore=true';
		}
		shoppingCalendarHttpObject.open("GET",url,true);
		shoppingCalendarHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingCalendarRenewResult() {
	if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status == 200)){
	    var calendarArea	= document.getElementById('shopping-calendar-area');
	    if( calendarArea ) {
	    	calendarArea.innerHTML	= shoppingCalendarHttpObject.responseText;
	    }
		setTimeout(FormerCommon.displayWhiteIn, 100);
	} else if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status != 200)){
		alert('状態変更中にサーバー通信に失敗しました');
		setTimeout(FormerCommon.displayWhiteIn, 100);
	}
}

//
// 期間設定
//
function shoppingCalendarAddTerm(){
	document.termForm.start_date.value	= document.termForm.start_date_year.options[document.termForm.start_date_year.selectedIndex].value
	+'-'+document.termForm.start_date_month.options[document.termForm.start_date_month.selectedIndex].value
	+'-'+document.termForm.start_date_day.options[document.termForm.start_date_day.selectedIndex].value;
	document.termForm.close_date.value	= document.termForm.close_date_year.options[document.termForm.close_date_year.selectedIndex].value
	+'-'+document.termForm.close_date_month.options[document.termForm.close_date_month.selectedIndex].value
	+'-'+document.termForm.close_date_day.options[document.termForm.close_date_day.selectedIndex].value;
	shoppingCalendarHttpObject	= FormerCommon.createHttpRequest(shoppingCalendarTermEditResult);
	if( shoppingCalendarHttpObject ) {
		var contents	= FormerCommon.createFormContents(document.termForm);
		FormerCommon.displayGrayOut(9999);
		shoppingCalendarHttpObject.open("POST",'./addterm.php',true);
		shoppingCalendarHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingCalendarHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingCalendarDeleteTerm(){
	document.deleteForm.start_date.value	= document.deleteForm.start_date_year.options[document.deleteForm.start_date_year.selectedIndex].value
	+'-'+document.deleteForm.start_date_month.options[document.deleteForm.start_date_month.selectedIndex].value
	+'-'+document.deleteForm.start_date_day.options[document.deleteForm.start_date_day.selectedIndex].value;
	document.deleteForm.close_date.value	= document.deleteForm.close_date_year.options[document.deleteForm.close_date_year.selectedIndex].value
	+'-'+document.deleteForm.close_date_month.options[document.deleteForm.close_date_month.selectedIndex].value
	+'-'+document.deleteForm.close_date_day.options[document.deleteForm.close_date_day.selectedIndex].value;
	shoppingCalendarHttpObject	= FormerCommon.createHttpRequest(shoppingCalendarTermEditResult);
	if( shoppingCalendarHttpObject ) {
		var contents	= FormerCommon.createFormContents(document.deleteForm);
		FormerCommon.displayGrayOut(9999);
		shoppingCalendarHttpObject.open("POST",'./deleteterm.php',true);
		shoppingCalendarHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingCalendarHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingCalendarTermEditResult(){
	if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status == 200)){
		var lines	= shoppingCalendarHttpObject.responseText.cr2lf().split(LF);
		var result	= '';
		while( result.length == 0 && lines.length > 0 ) {
			result	= lines.shift();
		}
		if( 'OK' == result ) {
		} else {
			alert(shoppingCalendarHttpObject.responseText);
		}
		shoppingCalendarRenew();
	} else if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status != 200)){
		alert('サーバー通信に失敗しました');
		setTimeout(FormerCommon.displayWhiteIn, 100);
	}
}
if(window.attachEvent){
	window.attachEvent('onload',shoppingCalendarRenew);
}else{
	window.addEventListener('DOMContentLoaded',shoppingCalendarRenew,false);
}
//--></script>