<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:system.login.Require}
{module:content.variable.Load}
{module:content.LoadFolders}
{preset:page_title 'コンテンツ管理 > サイト固有値設定'}

	<div class="panc">
		<a href="../../" title="管理パネルのトップページを表示します">管理パネルトップ</a>
		&gt; <a href="../" title="コンテンツ管理トップページを表示します">コンテンツ管理</a>
		&gt; サイト固有値設定
	</div>
	<h1>コンテンツ管理 &gt; サイト固有値設定</h1>
	
	{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<p style="width:95%;margin-top:2em;text-align:right;">
		<a href="../">&gt;&gt; コンテンツ管理トップページに戻る</a>
	</p>
	{else}
	
	<form name="settingform" action="./confirm.php" method="post">
	
	<p>
		値を設定してページ下部の「変更を保存」ボタンをクリックしてください。
	</p>
	<table class="list" style="width:95%;margin:0 auto;">
	<thead>
	<tr>
		<th style="white-space:nowrap;width:3em;text-align:center;">削除</th>
		<th>変数名</th>
		<th>説明</th>
		<th>値</th>
	</tr>
	</thead>
	<tbody id="valiable-table-body">
	{set:variableHash content.variable.VariableObject->'variableHash'}
	{foreach:variableHash variableKey variableHash}
	<tr id="valrow-{write:variableHash_loop_counter}">
		<td class="variable-cell-del">
			<input type="button" value="削除"
				onclick="contentVariableDelete('valrow-{write:variableHash_loop_counter}')"
				onkeypress="contentVariableDelete('valrow-{write:variableHash_loop_counter}')" />
		</td>
		<td class="variable-cell-key">
			<input type="text" size="30" name="variable_key[]" id="valrow-{write:variableHash_loop_counter}-key" value="{write:variableKey}" />
		</td>
		<td class="variable-cell-name">
			<input type="text" size="30" name="variable_label[]" value="{write:variableHash['label']}" />
		</td>
		<td class="variable-cell-value">
			<textarea name="variable_value[]" cols="30" rows="2" style="width:98%;"
				>{write:variableHash['value']}</textarea>
		</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	<div style="width:95%;margin:0 auto;text-align:right;">
		<a href="javascript:contentVariableVariableAdd()"
			>&gt;&gt;新しい変数を追加する</a>
		&nbsp;&nbsp;
		<a href="./form.php"
			>&gt;&gt;保存された状態に戻す</a>
	</div>
	<p style="text-align:center;">
		<img alt="変更を保存する" onclick="contentVariableSave()" onkeydown="contentVariableSave()" src="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/images/button/save_01.jpg" onmouseover="this.src='/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/images/button/save_01_on.jpg'" onmouseout="this.src='/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/images/button/save_01.jpg'" style="cursor:pointer;" />
	</p>
	</form>
	<form name="sform" action="./index.php" method="get">
	<div id="design-tpl-apply-folder-select" style="display:none;visibility:hidden;">
	<select name="ccurf">
	{foreach:content.folderArray folderPath}{if:preg_match('/^\\/js/',folderPath)==0 && preg_match('/^\\/upload/',folderPath)==0 && preg_match('/^\\/file/',folderPath)==0}
		<option value="{write:folderPath}"
			{if:content.currentFoloder==folderPath} selected{/if}
			>{write:folderPath}</option>
	{/if}{/foreach}
	</select>
	</div>
	</form>

<script language="JavaScript" type="text/javascript"><!--
var contentVariableHttpObject;
function contentVariableSave() {
	var postContents	= 'command=0'
	postContents		+= FormerCommon.createFormContents(document.settingform);
	contentVariableHttpObject	= FormerCommon.createHttpRequest(contentVariableSaveResult);
	if (contentVariableHttpObject) {
		FormerCommon.displayGrayOut(9999);
		contentVariableHttpObject.open("POST",'./save.php',true);
		contentVariableHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		contentVariableHttpObject.send(postContents);
	} else {
		alert('サーバーへの接続作成に失敗しました。');
	}
}
function contentVariableSaveResult() {
	if ((contentVariableHttpObject.readyState == 4) && (contentVariableHttpObject.status == 200)){
	    var lines	= contentVariableHttpObject.responseText.cr2lf().split(LF);
	    var isError = false;
	    var error_message	= '';
	    for( var i=0; i<lines.length; i++ ){
			if( String(lines[i]).cr2lf().trim().length>0 ){
				var result	= String(lines[i]).cr2lf().trim();
				if( result == 'OK' ) {
					break;
				} else if( isError ) {
					error_message += result + "\n";
				} else {
					isError	= true;
				}
			}
		}
		if( isError ) {
			alert('保存に失敗しました!\n'+error_message);
			setTimeout(FormerCommon.displayWhiteIn, 500);
		} else {
			if( confirm('保存が完了しました。\n続けて全ページに変更を反映しますか？\n'
				+ 'サイト内のページを全て読み込む為、この処理は時間がかかる場合があります。\n') ) {
				contentVariableApplyTpl2AllPages();
			} else {
				setTimeout(FormerCommon.displayWhiteIn, 500);
			}
		}
	} else if ((contentVariableHttpObject.readyState == 4) && (contentVariableHttpObject.status != 200)){
		alert('適用時にサーバー通信でエラーが発生しました。');
		setTimeout(FormerCommon.displayWhiteIn, 500);
	} else {
	}
}
//
// 変数行の追加
//
var contentVariableVariableCurrentNum	= {write:count(variableHash)};
function contentVariableVariableAdd() {
	var tbodyObject	= document.getElementById('valiable-table-body');
	if( tbodyObject ) {
		tbodyObject.appendChild(contentVariableVariableCreateRow());
	}
}
function contentVariableVariableCreateRow() {
	contentVariableVariableCurrentNum++;
	var trObject		= document.createElement('tr');
	trObject.id			= 'valrow-' + String(contentVariableVariableCurrentNum);
	// 削除ボタン
	var tdDel			= document.createElement('td');
	tdDel.className		= 'variable-cell-del';
	var inputDel		= document.createElement('input');
	inputDel.type		= 'button';
	inputDel.value		= '削除';
	inputDel.targetId	= trObject.id;
	inputDel.onclick	= function(e) {
		contentVariableDelete(this.targetId);
	};
	inputDel.onkeypress	= function(e) {
		contentVariableDelete(this.targetId);
	};
	tdDel.appendChild(inputDel);
	trObject.appendChild(tdDel);
	
	// キー入力欄
	var tdKey			= document.createElement('td');
	tdKey.className		= 'variable-cell-key';
	var inputKey		= document.createElement('input');
	inputKey.type		= 'text';
	inputKey.name		= 'variable_key[]';
	inputKey.id			= 'valrow-' + String(contentVariableVariableCurrentNum) + '-key';
	tdKey.appendChild(inputKey);
	trObject.appendChild(tdKey);

	// 名前入力欄
	var tdName			= document.createElement('td');
	tdName.className	= 'variable-cell-name';
	var inputName		= document.createElement('input');
	inputName.type		= 'text';
	inputName.name		= 'variable_label[]';
	tdName.appendChild(inputName);
	trObject.appendChild(tdName);

	// 値入力欄
	var tdValue			= document.createElement('td');
	tdValue.className	= 'variable-cell-value';
	var inputValue		= document.createElement('textarea');
	inputValue.name		= 'variable_value[]';
	tdValue.appendChild(inputValue);
	trObject.appendChild(tdValue);
	
	return trObject;
}
//
// 変数行の削除
//
function contentVariableDelete(rowId) {
	var tbodyObject	= document.getElementById('valiable-table-body');
	if( tbodyObject ) {
		var trObject	= document.getElementById(rowId);
		var keyInput	= document.getElementById(rowId + '-key');
		if( keyInput ) {
			if( confirm(keyInput.value+'を削除します。よろしいですか？') ) {
				if( trObject ) {
					contentVariableDeleteExecute(keyInput.value)
					tbodyObject.removeChild(trObject);
				}
			}
		}
	}
}
function contentVariableDeleteExecute(key) {
	var postContents	= 'command=0'
	postContents		+= '&' + encodeURIComponent('variable_key[]') + '=' + encodeURIComponent(key);
	contentVariableHttpObject	= FormerCommon.createHttpRequest(contentVariableSaveResult);
	if (contentVariableHttpObject) {
		FormerCommon.displayGrayOut(9999);
		contentVariableHttpObject.open("POST",'./delete.php',true);
		contentVariableHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		contentVariableHttpObject.send(postContents);
	} else {
		alert('サーバーへの接続作成に失敗しました。');
	}
}

/**
 * サイト内の全ページURIを取得して指定のテンプレートを適用します
 */
var contentVariableApplyAllPageArray;
var contentVariableApplyHttpObject;
function contentVariableApplyTpl2AllPages() {
	contentVariableApplyAllPageArray	= new Array();
	document.sform.ccurf.selectedIndex	= 0;
	var folderSelectElm	= document.getElementById('design-tpl-apply-folder-select');
	if(folderSelectElm) {
		folderSelectElm.style.display	= 'none';
		folderSelectElm.style.visibility	= 'hidden';
	}
	FormerCommon.displayGrayOut(9999);
	contentVariableGetPageList();
}
/**
 * 選択されたフォルダのページ一覧を取得し、全取得が完了したら適用メソッドをコールします
 */
function contentVariableGetPageList() {
	contentVariableApplyHttpObject	= FormerCommon.createHttpRequest(contentVariableGetPageListResult);
	var currentFolder				= document.sform.ccurf.options[document.sform.ccurf.selectedIndex].value;
	if( contentVariableApplyHttpObject ) {
		var url	= './ajax_pages.php?ccurf=' + encodeURIComponent(currentFolder);
		contentVariableApplyHttpObject.open("GET",url,true);
		contentVariableApplyHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function contentVariableGetPageListResult() {
	if ((contentVariableApplyHttpObject.readyState == 4) && (contentVariableApplyHttpObject.status == 200)){
		var currentFolder	= document.sform.ccurf.options[document.sform.ccurf.selectedIndex].value;
		var currentIndex	= document.sform.ccurf.selectedIndex;
		var domDoc		= contentVariableApplyHttpObject.responseXML;
		var nodes		= domDoc.getElementsByTagName('page');
		if( nodes.length > 0 ) {
			for( var num=0; num<nodes.length; num++ ) {
				var targetPage	= nodes[num];
				var childs		= targetPage.childNodes;
				var file,title,template;
				for( var cnum=0; cnum<childs.length; cnum++ ) {
					if( childs[cnum].tagName == 'file' ) {
						file	= childs[cnum].firstChild.nodeValue;
					} else if( childs[cnum].tagName == 'title' ) {
						title	= childs[cnum].firstChild.nodeValue;
					} else if( childs[cnum].tagName == 'template' ) {
						template	= childs[cnum].firstChild.nodeValue;
					}
				}
				var fileUri	= currentFolder+'/'+file;
				if( currentFolder == '/' ) {
					fileUri	= currentFolder+file;
				}
				contentVariableApplyAllPageArray.push(fileUri);
			}
		}
		if( document.sform.ccurf.selectedIndex < document.sform.ccurf.length - 1 ) {
			document.sform.ccurf.selectedIndex++;
			contentVariableGetPageList();
		} else {
			document.sform.ccurf.selectedIndex	= 0;
			contentVariableApplyPage();
		}
	} else if ((contentVariableApplyHttpObject.readyState == 4) && (contentVariableApplyHttpObject.status != 200)){
		alert('適用時にサーバー通信でエラーが発生しました。');
	}
}

function contentVariableApplyPage() {
	var pageUri	= contentVariableApplyAllPageArray.shift();
	contentVariableApplyHttpObject	= FormerCommon.createHttpRequest(contentVariableApplyPageResult);
	if( contentVariableApplyHttpObject ) {
		var url	= './rebuild.php?uri=' + encodeURIComponent(pageUri);
		contentVariableApplyHttpObject.open("GET",url,true);
		contentVariableApplyHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function contentVariableApplyPageResult() {
	if ((contentVariableApplyHttpObject.readyState == 4) && (contentVariableApplyHttpObject.status == 200)){
		if( contentVariableApplyAllPageArray.length > 0 ) {
			contentVariableApplyPage();
		} else {
			setTimeout(FormerCommon.displayWhiteIn, 500);
			alert('ページ再構築が完了しました。');
		}
	} else if ((contentVariableApplyHttpObject.readyState == 4) && (contentVariableApplyHttpObject.status != 200)){
		alert('適用時にサーバー通信でエラーが発生しました。');
	}
	
}
//--></script>

	{/if}