<?php
/*
 * system/tools/notify/SendPassword.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 
 * 
 * @package system
 * @subpackage tools
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 */
class system_tools_notify_SendPassword extends system_login_ModuleBase {
	function system_tools_notify_SendPassword(){
	}
	function execute( & $request ) {

		$email					= trim(stripslashes( $_POST['email'] ));
		$password				= trim(stripslashes( $_POST['password'] ));
		
		// システム設定の取得
		$systemDefinePath		= DIR_PATH_DATA.DIRECTORY_SEPARATOR.'system.define.inc.php';
		if( !file_exists($systemDefinePath) ) {
			$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_ERROR,array());
			return false;
		}
		require_once($systemDefinePath);

		// 入力内容のチェック
		$session_password	= $request->getSession( 'util.tempolarypassword.password' );
		if( strlen(trim($session_password)) == 0 ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			if ( strlen( $password ) < 6 ){
				$request->addLocaledError('system.error.tools.notify.tmpkeyrequired',SPIDER_LOG_LEVEL_ERROR,array());
			} else if( $session_password != $password ) {
				$request->addLocaledError('system.error.tools.notify.tmpkeyinvalid',SPIDER_LOG_LEVEL_ERROR,array());
			}
			if ( strlen( $email ) < 1 ) {
				$request->addLocaledError('system.error.tools.notify.emcailrequired',SPIDER_LOG_LEVEL_ERROR,array());
			}
		}
		// 全てのユーザー定義クラスの読み込み
		$loginInformationObject	= null;
		if( !$request->isError() ) {
			$userClassNameArray		= system_PackageConfig::loadAllUserClassFile( $request );
			// 全ての定義クラスで優先順に指定ログインIDの情報を読み込めるか確認
			$existsUser	= false;
			foreach( $userClassNameArray as $userClassName ) {
				if( class_exists($userClassName) ) {
					$loginInformationObject	= new $userClassName;
					if( is_a($loginInformationObject,'system_login_AbstractUser') ) {
						// ユーザークラスの実装として定義されている
						if( $loginInformationObject->loadLoginUserByEmail( $request, $email ) ) {
							// 読み込みに成功したらログインユーザーオブジェクトとして扱う
							$loginInformationObject->email	= $email;
							$existsUser	= true;
							break;
						} else {
							// 読み込めなかったら次の定義クラスを確認する為エラーにしない
						}
					} else {
						// AbstractUserの実装ではない
						$request->addLocaledError('system.error.config.invalidsendclassname',SPIDER_LOG_LEVEL_ERROR,array($userClassName));
						break;
					}
				}
			}
			if( !$existsUser ) {
				// 全ての定義クラスで読み込んでもユーザーが見つからない場合はエラー
				$request->addLocaledError('system.error.login.user.invalidlogin',SPIDER_LOG_LEVEL_ERROR,array());
				$loginInformationObject	= null;
			}
		}

		// メール送信設定内容のチェック
		$mailSendObject	= null;
		if ( !$request->isError() ) {
			$send_defs	= $GLOBALS['SYSTEM_SEND_METHOD'][SYSTEM_MAIL_SEND_METHOD];
			if( !is_array( $send_defs ) ) {
				$request->addLocaledError('system.error.login.user.nomailsetting',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				$send_class_name	= $send_defs['class_name'];
				$send_view_name		= $send_defs['view_name'];
				$send_class_path	= DIR_PATH_LIB.DIRECTORY_SEPARATOR.'util'
					.DIRECTORY_SEPARATOR.'mail'.DIRECTORY_SEPARATOR.$send_class_name.'.class.php';
				if( !file_exists( $send_class_path ) ) {
					$request->addLocaledError('system.error.login.user.nomailsetting',SPIDER_LOG_LEVEL_ERROR,array());
				} else {
					require_once($send_class_path);
					$send_class_name	= 'util_mail_' . $send_class_name;
					$mailSendObject		= new $send_class_name;
					$errors				= $mailSendObject->validate_options( $GLOBALS['SYSTEM_MAIL_SEND_METHOD_OPTIONS'] );
					if( count($errors) > 0 ) {
						foreach( $errors as $msg ) {
							$request->addLocaledError($msg,SPIDER_LOG_LEVEL_ERROR,array());
						}
					}
				}
			}
		}
		// エラーがないなら送信処理
		if ( !$request->isError() && !is_null( $loginInformationObject ) ) {
			// 送信先メールアドレスを決定
			if( $loginInformationObject->sendPaswordReminder( $request, $email ) ) {
			}
		}
	}
}
?>