<?php
/*
 * system/package/uninstall/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : システム設定パッケージ 入力確認用アクションモジュールクラス
 * 
 * spiderのページから呼び出して実行します。
 * 
 * @package system
 * @subpackage package
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 * @abstract
 */
class system_package_uninstall_Execute extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */
	function system_package_uninstall_Execute(){
		// インストール済みパッケージ読み込みモジュールを先に実行
		array_push($this->require_module_array,'system.package.LoadList');
	}
	function execute( & $request ) {
		// アンインストール対象パッケージID
		$target_package_id	= $request->getParam('system_uninstall_package_id','post');
		// インストール済みパッケージID配列
		$installedPackageIdArray		= $request->getAttribute('system.package.installedPackageIdArray');
		if( strlen(trim($target_package_id)) == 0 ) {
			$request->addLocaledError('system.error.package.invalidpackage',SPIDER_LOG_LEVEL_ERROR,array($target_package_id));
		} else if( !in_array( $target_package_id, $installedPackageIdArray ) ) {
			$request->addLocaledError('system.error.package.noinstalled',SPIDER_LOG_LEVEL_ERROR,array($target_package_id));
		} else {
			// 対象のパッケージ情報クラスを取得
			$target_package_object			= $this->getPackageConfigInstance( $request, $target_package_id );
			// 対象パッケージに依存しているインストール済みパッケージを確認
			$dependentPackageObjectArray	= array();
			foreach( $installedPackageIdArray as $related_package_id ) {
				$dependentPackageObject		= $this->getPackageConfigInstance( $request, $related_package_id );
				if( $dependentPackageObject && in_array( $target_package_id, $dependentPackageObject->getPackageDependenciesIdArray() ) ) {
					array_push( $dependentPackageObjectArray, $dependentPackageObject );
				}
			}
		}
		
		if( !$request->isError() ) {
			// 依存パッケージを先にアンインストール
			foreach( $dependentPackageObjectArray as $dependentPackageObject ) {
				$dependentPackageObject->load( $request );
				if( $dependentPackageObject->uninstall( $request ) ) {
					$new_array	= array();
					foreach( $installedPackageIdArray as $pid ) {
						if( $pid != $dependentPackageObject->getPackageId() ) {
							array_push( $new_array, $pid );
						}
					}
					$installedPackageIdArray	= $new_array;
				} else {
					break;
				}
			}
			// 対象パッケージをアンインストール
			if( $target_package_object ) {
				$target_package_object->load( $request );
				if( $target_package_object->uninstall( $request ) ) {
					$new_array	= array();
					foreach( $installedPackageIdArray as $pid ) {
						if( $pid != $target_package_object->getPackageId() ) {
							array_push( $new_array, $pid );
						}
					}
					$installedPackageIdArray	= $new_array;
				} else {
					
				}
			}
		}
		$request->setAttribute('system.package.uninstall.target_package_object',$target_package_object);
		$request->setAttribute('system.package.uninstall.related_package_object_array',$dependentPackageObjectArray);

	}
	/**
	 * パッケージIDからパッケージを実体化して返します。
	 */
	function getPackageConfigInstance( & $request, $package_id ) {
		$package_config_class_file	= DIR_PATH_LIB.DIRECTORY_SEPARATOR.$package_id
			. DIRECTORY_SEPARATOR.'PackageConfig.class.php'
		;
		$package_config_class_name	= $package_id.'_PackageConfig';
		if( !file_exists( $package_config_class_file ) ) {
			$request->addLocaledError('system.error.package.nodefinedpackage',SPIDER_LOG_LEVEL_ERROR,array($package_id));
			return false;
		} else {
			// パッケージクラスファイルが存在するなら
			if( !@require_once( $package_config_class_file ) ) {
				$request->addLocaledError('system.error.package.failtoinstant',SPIDER_LOG_LEVEL_ERROR,array($package_id));
				return false;
			} else {
				// パッケージオブジェクトの作成
				$package_config_object	= new $package_config_class_name;
				return $package_config_object;
			}
		}
	}
}
?>