<?php
/*
 * system/package/install/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Form.class.php');
/**
 * spider : systemパッケージ/パッケージインストーラ 入力確認用アクションモジュールクラス
 * 
 * spiderのページから呼び出して実行します。
 * 
 * @package system
 * @subpackage package
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 * @abstract
 */
class system_package_install_Confirm extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */
	function system_package_install_Confirm(){
		// インストール済みパッケージ読み込みモジュールを先に実行
		array_push($this->require_module_array,'system.package.LoadList');
	}
	function execute( & $request ) {
		// インストール対象パッケージID
		$targetPackageId			= $request->getParam('system_install_package_id','post');
		// インストール済みパッケージID配列
		$installedPackageIdArray	= $request->getAttribute('system.package.installedPackageIdArray');
		if( strlen(trim($targetPackageId)) == 0 ) {
			$request->addLocaledError('system.error.package.invalidpackage',SPIDER_LOG_LEVEL_ERROR,array($targetPackageId));
		} else {
			// 対象のパッケージ情報クラスを取得
			$targetPackageConfigObject			= system_package_install_Form::getPackageConfigInstance( $request, $targetPackageId );
			// 要求IDの配列を初期化
			$installPackageIdArray		= array();
			// 要求パッケージオブジェクトハッシュの初期化
			$installPackageObjectHash	= array();
			if( $targetPackageConfigObject ) {
				// 要求パッケージIDの優先順配列を取得
				$installPackageIdArray		= system_package_install_Form::createRequiredPackageIdArray( $request, $targetPackageId, $installPackageIdArray );
				if( is_array($installPackageIdArray) && count($installPackageIdArray) > 0 ) {
					foreach( $installPackageIdArray as $requiredPackageId ) {
						$requiredPackageObject	= system_package_install_Form::getPackageConfigInstance( $request, $requiredPackageId );
						if( $requiredPackageObject ) {
							$requiredPackageObject->setPostValues( $request );
							$installPackageObjectHash[$requiredPackageId]	= $requiredPackageObject;
						}
					}
				} else {
					$targetPackageConfigObject->setPostValues( $request );
					$installPackageObjectHash[$targetPackageConfigObject->getPackageId()]	= $targetPackageConfigObject;
					array_push($installPackageIdArray,$targetPackageConfigObject->getPackageId());
				}
				$request->setSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_OBJECT_HASH,$installPackageObjectHash,SPIDER_SESSION_SCOPE_GLOBAL);
				if( $request->isError() ) {
					$request->removeSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_CONFIRM_RESULT,SPIDER_SESSION_SCOPE_GLOBAL);
				} else {
					$request->setSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_CONFIRM_RESULT,'OK',SPIDER_SESSION_SCOPE_GLOBAL);
				}
				$request->setAttribute('system.package.install.target_package_object',$targetPackageConfigObject);
				$request->setAttribute('system.package.install.install_id_array',$installPackageObjectHash);
				$request->setAttribute('system.package.install.install_object_hash',$installPackageObjectHash);
				// インストールの妥当性検査
				foreach( $installPackageObjectHash as $installPackageConfigObject ) {
					$installPackageConfigObject->validateDifinitionHash( $request );
				}
			}
		}
	}
}
?>