<?php
/*
 * system/package/Load.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : システム設定を読み込むするアクションモジュールクラス
 * 
 * @package system
 * @subpackage package
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 * @abstract
 */
class system_package_Load extends system_login_ModuleBase {
	function system_package_Load() {
	}
	function execute( & $request ) {
		// 対象パッケージID
		$packageId				= 'system';
		$packageConfigObject	= null;
		$isSetup				= false;
		if( isset($_GET) && isset($_GET['spid'])
			&& strlen(trim(stripslashes($_GET['spid']))) > 0 ){
			$packageId		= trim(stripslashes($_GET['spid']));
		}
		// 対象パッケージディレクトリ
		$packageDirPath		= DIR_PATH_LIB.DIRECTORY_SEPARATOR.$packageId;
		if( !is_dir( $packageDirPath ) ) {
			$request->addLocaledError('system.error.package.invalidpackage',SPIDER_LOG_LEVEL_ERROR,array($packageId));
		} else {
			// パッケージ設定オブジェクトクラスファイル
			$packageConfigClassFile	= $packageDirPath.DIRECTORY_SEPARATOR.'PackageConfig.class.php';
			if( !file_exists( $packageConfigClassFile ) ) {
				$request->addLocaledError('system.error.package.invalidpackage',SPIDER_LOG_LEVEL_ERROR,array($packageId));
			} else {
				require_once( $packageConfigClassFile );
				// パッケージ設定オブジェクトクラス名
				$packageConfigClassName	= $packageId.'_PackageConfig';
				$packageConfigObject	= new $packageConfigClassName;
				if( $packageConfigObject->load( $request ) ) {
					$isSetup			= true;
				} else {
					$request->addLocaledError('system.error.package.noinstalled',SPIDER_LOG_LEVEL_ERROR,array($packageId));
				}
			}
		}
		$request->setAttribute('system.package.isSetup',$isSetup);
		$request->setAttribute('system.package.targetPackageId',$packageId );
		$request->setAttribute('system.package.packageConfigObject',$packageConfigObject );
	}
}
?>