<?php
/*
 * shopping/product/unit/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(dirname(__FILE__))))
.DIRECTORY_SEPARATOR.'file'
.DIRECTORY_SEPARATOR.'Uploader.class.php');
class shopping_product_unit_Form extends system_login_ModuleBase {
	function shopping_product_unit_Form(){
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$unitNumber					= stripslashes( $_GET['shpun'] );
		$unitId						= stripslashes( $_GET['shpui'] );
		$productId					= stripslashes( $_GET['shpdi'] );
		$requireUnitId				= stripslashes( $_GET['shprequi'] );
		$sessionObjectName			= 'shopping.product.unit.modify.object.'.$unitNumber;
		$sessionConfirmName			= 'shopping.product.unit.modify.confirm.'.$unitNumber;
		$shoppingProductUnitObject	= $request->getSession($sessionObjectName);
		if( is_object( $shoppingProductUnitObject ) && is_object($shoppingProductUnitObject->uploader) ) {
			$shoppingProductUnitObject->uploader->deleteTempFiles( $request );
		}
		$loginUserObject				= $this->getLoginUserObject( $request );
		$compareProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
		$request->removeSession($sessionObjectName);
		$request->removeSession($sessionConfirmName);

		// 編集権限の確認
		if( $this->isLogin( $request ) ) {
			if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
				// 管理者ログインは編集可
			} else {
				if ( $loginUserObject->member_class >= 53 ) {
					// 会員種別が商品販売会員は編集可
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		} else {
			$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
		}
		
		if( !$request->isError() ) {
			if( get_class($compareProductUnitObject) == get_class($shoppingProductUnitObject) ){
				// セッションに登録済みならそのまま利用する
			} else {
				// セッションにないなら作成する
				$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
				if( strlen(trim($unitNumber)) > 0 ) {
					// IDが指定されているなら編集のため読み込み
					if( $dbo->loadByNumber( $shoppingProductUnitObject, $unitNumber ) ){
						// 検索データ連携
						$shoppingProductUnitObject->shoppingProductObject->loadRelatedSearchData( $dbo );
					} else {
						$request->addLocaledError('shopping.error.product.unit.invalidid',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else if( strlen(trim($unitId)) > 0 ) {
					// IDが指定されているなら編集のため読み込み
					if( $dbo->loadById( $shoppingProductUnitObject, $unitId ) ){
						// 検索データ連携
						$shoppingProductUnitObject->shoppingProductObject->loadRelatedSearchData( $dbo );
					} else {
						$request->addLocaledError('shopping.error.product.unit.invalidid',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else {
					// IDが指定されていないなら新規作成
					$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
					$shoppingProductUnitObject->product_id		= $productId;
					$shoppingProductUnitObject->require_unit_id	= $requireUnitId;
					// 商品情報を読み込み
					$shoppingProductUnitObject->shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
					if( $dbo->loadById( $shoppingProductUnitObject->shoppingProductObject, $productId ) ) {
						$shoppingProductUnitObject->unit_string		= $shoppingProductUnitObject->shoppingProductObject->unit_string;
						$shoppingProductUnitObject->delivery_type	= $shoppingProductUnitObject->shoppingProductObject->delivery_type;
						$shoppingProductUnitObject->memberViewableArray		= $shoppingProductUnitObject->shoppingProductObject->memberViewableArray;
						$shoppingProductUnitObject->memberPurchasableArray	= $shoppingProductUnitObject->shoppingProductObject->memberPurchasableArray;
						$shoppingProductUnitObject->owner_id	= $shoppingProductUnitObject->shoppingProductObject->owner_id;
					} else {
						$request->addLocaledError('shopping.error.product.invalidid',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
					if( defined('SHOPPING_RESERVE_ENABLE_START') && preg_match('/^[0-9]{1,3}$/',SHOPPING_RESERVE_ENABLE_START) > 0 ) {
						$shoppingProductUnitObject->rsv_permit_start	= SHOPPING_RESERVE_ENABLE_START;
					}
					if( defined('SHOPPING_RESERVE_ENABLE_LIMIT') && preg_match('/^[0-9]{1,3}$/',SHOPPING_RESERVE_ENABLE_LIMIT) > 0 ) {
						$shoppingProductUnitObject->rsv_permit_limit	= SHOPPING_RESERVE_ENABLE_LIMIT;
					}
					if( defined('SHOPPING_RESERVE_STAY_CHECKIN') && strlen(SHOPPING_RESERVE_STAY_CHECKIN) > 0 ) {
						$shoppingProductUnitObject->default_start_time	= SHOPPING_RESERVE_STAY_CHECKIN;
						if( defined('SHOPPING_RESERVE_STAY_CHECKOUT') && strlen(SHOPPING_RESERVE_STAY_CHECKOUT) > 0 ) {
							$shoppingProductUnitObject->service_term	= ( 24 - substr(SHOPPING_RESERVE_STAY_CHECKIN,0,strpos(':',SHOPPING_RESERVE_STAY_CHECKIN))
							+ substr(SHOPPING_RESERVE_STAY_CHECKOUT,0,strpos(':',SHOPPING_RESERVE_STAY_CHECKOUT)) ) * 60 * 60;
						}
					}
				}
			}
		}
		$fileObjectOrgHash	= array();
		if( !$request->isError() ) {
			// unit_numberが設定済みならロック処理
			if( strlen($shoppingProductUnitObject->unit_number ) > 0 ) {
				if ( !$shoppingProductUnitObject->canEditData( $request, $loginUserObject ) ) {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				} else if( false === $this->lockData( $request, $shoppingProductUnitObject ) ) {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else {
					// ロックを取得できたら元のダウンロードファイル情報を取得
					foreach( $shoppingProductUnitObject->fileIdArray_org as $num => $fileId ) {
						if( $num >= 100 ) {
							$fileBinObject	= spider_Controller::createObject('file_DaoFileBin');
							if( $dbo->loadById( $fileBinObject, $fileId, true ) ) {
								$fileObjectOrgHash[$num]	= $fileBinObject;
							} else {
								$request->addLocaledError('shopping.error.order.download.failtoread',SPIDER_LOG_LEVEL_FATAL,array($num-99));
							}
						}
					}
				}
			}
		}
		$request->setAttribute('shopping.product.unit.fileObjectOrgHash',		$fileObjectOrgHash);
		$request->setAttribute('shopping.product.unit.unit_object',		$shoppingProductUnitObject);
	}
}
?>