<?php
/*
 * shopping/product/unit/UnLock.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_product_UnLock extends system_login_ModuleBase {
	
	function shopping_product_UnLock() {
	}
	function execute( & $request ) {
		
		$dbo				= $request->getAttribute( 'dbo' );
		$productNumber			= stripslashes( $_GET['shpdn'] );
		$productId				= stripslashes( $_GET['shpdi'] );
		$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
		
		if ( strlen(trim($productNumber)) == 0 && strlen(trim($productId)) == 0 ) {
			$request->addLocaledError('system.error.common.data.selectunlock',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( strlen(trim($productNumber)) > 0 && preg_match('/^[0-9]+$/',$productNumber) > 0 ){
			if ( $dbo->loadByNumber( $shoppingProductObject, $productNumber ) ) {
				$this->unlockData( $request, $shoppingProductObject );
			} else {
				$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else if( strlen(trim($productId)) > 0 && preg_match('/^[0-9a-zA-Z]+$/',$productId) > 0 ){
			if ( $dbo->loadById( $shoppingProductObject, $productId ) ) {
				$this->unlockData( $request, $shoppingProductObject );
			} else {
				$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		$request->setAttribute('shopping.product.product_object',			$shoppingProductObject);
	}
}
?>