<?php
/*
 * shopping/product/unit/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'file'
.DIRECTORY_SEPARATOR.'Uploader.class.php');
class shopping_product_Form extends system_login_ModuleBase {
	function shopping_product_Form(){
	}
	function execute( & $request ) {
		$dbo						= $request->getAttribute( 'dbo' );
		$productNumber				= $request->getParam('shpdn','get');
		$productId					= $request->getParam('shpdi','get');
		$searchDataId				= $request->getParam('schdi','get');
		$sessionObjectName			= 'shopping.product.modify.object.'.$productNumber.'.'.$searchDataId;
		$sessionConfirmName			= 'shopping.product.modify.confirm.'.$productNumber.'.'.$searchDataId;
		$shoppingProductObject		= $request->getSession($sessionObjectName);
		if( is_object( $shoppingProductObject ) && is_object($shoppingProductObject->uploader) ) {
			$shoppingProductObject->uploader->deleteTempFiles( $request );
		}
		$loginUserObject			= $this->getLoginUserObject( $request );
		$compareShoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
		$request->removeSession($sessionObjectName);
		$request->removeSession($sessionConfirmName);

		// 編集権限の確認
		if( $this->isLogin( $request ) ) {
			if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
				// 管理者ログインは編集可
			} else {
				if ( $loginUserObject->member_class >= 53 ) {
					// 会員種別が商品販売会員は編集可
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		} else {
			$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
		}
		
		if( !$request->isError() ) {
			if( get_class($compareShoppingProductObject) == get_class($shoppingProductObject) ){
				// セッションに登録済みならそのまま利用する
			} else {
				// セッションにないなら作成する
				$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
				if( strlen(trim($productNumber)) > 0 ) {
					// IDが指定されているなら編集のため読み込み
					if( $dbo->loadByNumber( $shoppingProductObject, $productNumber ) ){
						// 関連商品ID
						$shoppingProductObject->loadRelatedProductId( $dbo );
						// 検索パッケージ連携
						if( $shoppingProductObject->loadSearchData( $request, $loginUserObject ) ) {
						}
					} else {
						$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else if( strlen(trim($productId)) > 0 ) {
					// IDが指定されているなら編集のため読み込み
					if( $dbo->loadById( $shoppingProductObject, $productId ) ){
						// 関連商品ID
						$shoppingProductObject->loadRelatedProductId( $dbo );
						// 検索パッケージ連携
						if( $shoppingProductObject->loadSearchData( $request, $loginUserObject ) ) {
						}
					} else {
						$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else {
					// IDが指定されていないなら新規作成
					$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
					if( isset($GLOBALS['SHOPPING_MEMBER_VIEWABLE']) && is_array($GLOBALS['SHOPPING_MEMBER_VIEWABLE']) ) {
						$shoppingProductObject->memberViewableArray		= $GLOBALS['SHOPPING_MEMBER_VIEWABLE'];
					}
					if( isset($GLOBALS['SHOPPING_MEMBER_PURCHASBLE']) && is_array($GLOBALS['SHOPPING_MEMBER_PURCHASBLE']) ) {
						$shoppingProductObject->memberPurchasableArray	= $GLOBALS['SHOPPING_MEMBER_PURCHASBLE'];
					}
					// 検索パッケージ連携
					if( strlen(trim($searchDataId)) > 0 ) {
						$shoppingProductObject->search_data_id	= $searchDataId;
						if( $shoppingProductObject->loadSearchData( $request, $loginUserObject ) ) {
							$shoppingProductObject->owner_id	= $searchDataObject->owner_id;
						}
					}
					if( isset($_GET['shppdt']) ) {
						$deliveryType		= $request->getParam('shppdt','get');
						if( preg_match('/^[0-9]{1,6}$/',$deliveryType) > 0
						&& array_key_exists($deliveryType,$GLOBALS['SHOPPING_DELIVERY_TYPE_HASH']) ) {
							$shoppingProductObject->delivery_type	= $deliveryType;
						}
					}
					// 販売単位同時作成
					$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
					$shoppingProductUnitObject->product_id				= $productId;
					$shoppingProductUnitObject->unit_string				= $shoppingProductObject->unit_string;
					$shoppingProductUnitObject->delivery_type			= $shoppingProductObject->delivery_type;
					$shoppingProductUnitObject->memberViewableArray		= $shoppingProductObject->memberViewableArray;
					$shoppingProductUnitObject->memberPurchasableArray	= $shoppingProductObject->memberPurchasableArray;
					$shoppingProductUnitObject->owner_id				= $shoppingProductObject->owner_id;
					if( defined('SHOPPING_RESERVE_ENABLE_START') && preg_match('/^[0-9]{1,3}$/',SHOPPING_RESERVE_ENABLE_START) > 0 ) {
						$shoppingProductUnitObject->rsv_permit_start	= SHOPPING_RESERVE_ENABLE_START;
					}
					if( defined('SHOPPING_RESERVE_ENABLE_LIMIT') && preg_match('/^[0-9]{1,3}$/',SHOPPING_RESERVE_ENABLE_LIMIT) > 0 ) {
						$shoppingProductUnitObject->rsv_permit_limit	= SHOPPING_RESERVE_ENABLE_LIMIT;
					}
					if( defined('SHOPPING_RESERVE_STAY_CHECKIN') && strlen(SHOPPING_RESERVE_STAY_CHECKIN) > 0 ) {
						$shoppingProductUnitObject->default_start_time	= SHOPPING_RESERVE_STAY_CHECKIN;
						if( defined('SHOPPING_RESERVE_STAY_CHECKOUT') && strlen(SHOPPING_RESERVE_STAY_CHECKOUT) > 0 ) {
							$shoppingProductUnitObject->service_term	= ( 24 - substr(SHOPPING_RESERVE_STAY_CHECKIN,0,strpos(':',SHOPPING_RESERVE_STAY_CHECKIN))
							+ substr(SHOPPING_RESERVE_STAY_CHECKOUT,0,strpos(':',SHOPPING_RESERVE_STAY_CHECKOUT)) ) * 60 * 60;
						}
					}
					$shoppingProductObject->unitObjectArray				= array();
					array_push($shoppingProductObject->unitObjectArray, $shoppingProductUnitObject );
				}
			}
		}
		if( !$request->isError() ) {
			// product_numberが設定済みならロック処理
			if( strlen($shoppingProductObject->product_number ) > 0 ) {
				if ( !$shoppingProductObject->canEditData( $request, $loginUserObject ) ) {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				} else if( false === $this->lockData( $request, $shoppingProductObject ) ) {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
		}
		$request->setAttribute('shopping.product.product_object',	$shoppingProductObject);
	}
}
?>