<?php
/*
 * shopping/package_define.inc.php
 * shoppingパッケージ変数定義用ファイル
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
/** パッケージバージョン	*/
define('SHOPPING_VERSION', '1.3.00');

/** デフォルト DBタイプ mysql / pgsql	*/
define('DATABASE_TYPE', 'mysql');
/** デフォルト DB名	*/
define('DATABASE_NAME', 'shopformer');
/** デフォルト DBユーザー	*/
define('DATABASE_USER', 'shopformer@localhost' );
/** デフォルト DBパスワード	*/
define('DATABASE_PASS', 'shopformer');
/** デフォルト データベース内部文字コード	*/
define('DATABASE_CHARSET', 'UTF-8');
/** デフォルト DBホスト	*/
define('DATABASE_HOST', 'localhost');
/** デフォルト DBポート	*/
define('DATABASE_PORT', '3306');
/** デフォルト データベース権限ユーザ	*/
define('DATABASE_MASTER_USER', 'root');
/** デフォルト データベース権限パスワード	*/
define('DATABASE_MASTER_PASSWORD', '');

/** テーブル名：ショッピングカテゴリ	*/
define('TABLE_NAME_SHOPPING_CATEGORY',	'shopping_category');
/** テーブル名：ショッピング商品	*/
define('TABLE_NAME_SHOPPING_PRODUCT',	'shopping_product');
/** テーブル名：ショッピング商品販売単位	*/
define('TABLE_NAME_SHOPPING_PRODUCT_UNIT',	'shopping_product_unit');
/** テーブル名：ショッピングカテゴリ・商品関連	*/
define('TABLE_NAME_SHOPPING_CATEGORY_PRODUCT',	'shopping_category_product');
/** テーブル名：ショッピング商品ファイル	*/
define('TABLE_NAME_SHOPPING_PRODUCT_FILE',	'shopping_product_file');
/** テーブル名：ショッピング商品ファイル	*/
define('TABLE_NAME_SHOPPING_PRODUCT_RELATION',	'shopping_product_relation');
/** テーブル名：ショッピング商品ファイル	*/
define('TABLE_NAME_SHOPPING_PRODUCT_UNIT_FILE',	'shopping_product_unit_file');
/** テーブル名：ショッピング注文	*/
define('TABLE_NAME_SHOPPING_ORDER',	'shopping_order');
/** テーブル名：ショッピング注文宛先情報	*/
define('TABLE_NAME_SHOPPING_ORDER_ADDRESS',	'shopping_order_address');
/** テーブル名：ショッピング注文商品情報	*/
define('TABLE_NAME_SHOPPING_ORDER_ITEM',	'shopping_order_item');
/** テーブル名：ショッピング注文商品ファイル	*/
define('TABLE_NAME_SHOPPING_ORDER_ITEM_FILE',	'shopping_order_item_file');
/** テーブル名：ショッピング注文オプション情報	*/
define('TABLE_NAME_SHOPPING_ORDER_OPTION',	'shopping_order_option');
/** テーブル名：ショッピング注文履歴情報	*/
define('TABLE_NAME_SHOPPING_ORDER_HISTORY',	'shopping_order_history');
/** テーブル名：ショッピング決済方法設定	*/
define('TABLE_NAME_SHOPPING_SETTLE_METHOD',		'shopping_settle_method');
/** テーブル名：ショッピング配送料設定	*/
define('TABLE_NAME_SHOPPING_DELIVERY_SETTING',	'shopping_delivery_setting');
/** テーブル名：ショッピングプロモーション	*/
define('TABLE_NAME_SHOPPING_PROMOTION',	'shopping_promotion');
/** テーブル名：ショッピングプロモーションアクセスログ	*/
define('TABLE_NAME_SHOPPING_PROMOTION_ACCESS_LOG',	'shopping_promotion_access_log');
/** テーブル名：ショッピング商品フラグ	*/
define('TABLE_NAME_SHOPPING_PRODUCT_FLAG',	'shopping_product_flag');
/** テーブル名：ショッピング商品販売単位・フラグ関連	*/
define('TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION',	'shopping_product_unit_flag_relation');
/** テーブル名：ショッピングダウンロードログ	*/
define('TABLE_NAME_SHOPPING_DOWNLOAD_LOG',	'shopping_download_log');
/** テーブル名：ショッピング商品・ブックマーク	*/
define('TABLE_NAME_SHOPPING_PRODUCT_BOOKMARK',	'shopping_product_bookmark');
/** テーブル名；ショッピング営業日カレンダー	*/
define('TABLE_NAME_SHOPPING_CALENDAR','shopping_calendar');

/** 商品画像登録最大サイズ：横幅	*/
define('SHOPPING_PRODUCT_IMAGE_MAX_WIDTH',		640 );
/** 商品画像登録最大サイズ：高さ	*/
define('SHOPPING_PRODUCT_IMAGE_MAX_HEIGHT',	640 );

/** ラッピング選択肢保存ファイルURI	*/
define('SHOPPING_RAPPING_FILE_URI',	'/shopping/rapping');
/** お届け希望時間帯選択肢保存ファイルURI	*/
define('SHOPPING_WISHFUL_TIME_FILE_URI',	'/shopping/wishful_times');
/** オプションハッシュ保存ファイルURI	*/
define('SHOPPING_OPTIONS_FILE_URI',	'/shopping/options');

/** 買い物かごオブジェクト保存セッション名	*/
define('SHOPPING_SESSION_NAME_ORDER_OBJECT','shopping.order.orderObject');
/** セッション名：購入時確認セッション：購入者情報入力	*/
define('SHOPPING_SESSION_NAME_ORDER_CONFIRM_PURCHASER','shopping.order.order_confirm_purchaser');
/** セッション名：購入時確認セッション：宛先入力	*/
define('SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS','shopping.order.order_confirm_address');
/** セッション名：購入時確認セッション：宛先追加情報入力	*/
define('SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS_OPTION','shopping.order.order_confirm_address_option');
/** セッション名：購入時確認セッション：決済方法入力	*/
define('SHOPPING_SESSION_NAME_ORDER_CONFIRM_SETTLEMENT','shopping.order.order_confirm_settlement');
/** セッション名：購入時確認セッション：注文オプション入力	*/
define('SHOPPING_SESSION_NAME_ORDER_CONFIRM_OPTIONS','shopping.order.order_confirm_options');
/** セッション名：購入時確認セッション：注文項目オプション入力	*/
define('SHOPPING_SESSION_NAME_ORDER_CONFIRM_ITEMOPTIONS','shopping.order.order_confirm_itemoptions');
/** セッション名：購入時確認セッション：通信欄入力	*/
define('SHOPPING_SESSION_NAME_ORDER_CONFIRM_COMMENT','shopping.order.order_confirm_comment');
/** セッション名：購入時確認セッション：下位互換:settlement.php入力	*/
define('SHOPPING_SESSION_NAME_ORDER_CONFIRM_DELIVERY_OLD','shopping.order.order_confirm_delivery');

/** ラベル申し込み	*/
if( !isset($GLOBALS['SHOPPING_LABEL_ORDER']) ){
	$GLOBALS['SHOPPING_LABEL_ORDER']	= '注文';
}
/** ラベル商品	*/
if( !isset($GLOBALS['SHOPPING_LABEL_PRODUCT']) ){
	$GLOBALS['SHOPPING_LABEL_PRODUCT']	= '商品';
}
/** ラベル商品	*/
if( !isset($GLOBALS['SHOPPING_LABEL_PRODUCT_UNIT']) ){
	$GLOBALS['SHOPPING_LABEL_PRODUCT_UNIT']	= '販売単位';
}
/** ラベル商品	*/
if( !isset($GLOBALS['SHOPPING_LABEL_ADDRESS_NAME']) ){
	$GLOBALS['SHOPPING_LABEL_ADDRESS_NAME']	= '宛先';
}

/** 商品ステータス種別	*/
$GLOBALS['SHOPPING_PRODUCT_STATUS_HASH']	= array(
	0		=>'新規'
	,91		=>'非公開'
	,101	=>'掲載中'
	,255	=>'削除'
);
/** 注文ステータス種別ハッシュ	*/
$GLOBALS['SHOPPING_ORDER_STATUS_HASH']	= array(
	0			=> '新規',
	5			=> '変更申請中',
	// ここからお好きな状態を作成できます 番号は重複しないようにしてください
	121		=> '納品済',
	// ここまでお好きな状態を作成できます
	191		=> 'キャンセル申請',
	201		=> 'キャンセル承認',
	255		=> '削除',
);
/** 注文決済ステータスハッシュ	*/
$GLOBALS['SHOPPING_ORDER_STATUS_SETTLE_HASH']	= array(
	0		=> '未決済',
	10		=> '請求済',
	101		=> '支払済',
	201		=> '決済失敗',
);
/** 注文プロモーションステータスハッシュ	*/
$GLOBALS['SHOPPING_ORDER_STATUS_PROMOTION_HASH']	= array(
	0		=> '未確定',
	10		=> '承認済',
	101		=> '支払済',
	255		=> '非承認',
);
/** プロモーションステータス種別	*/
$GLOBALS['SHOPPING_PROMOTION_STATUS_HASH']	= array(
	0		=>'承認前'
	,90		=>'停止中'
	,101	=>'稼働中'
	,241	=>'契約解除'
	,255	=>'強制解除'
);
/** 決済方法ハッシュ	*/
$GLOBALS['SHOPPING_SETTLEMENT_DEF_HASH']	= array(
	0	=> '代金引換',
	10	=> '銀行振込(先払い)',
	11	=> '銀行振込(月締後払い)',
	16	=> '郵便振替(先払い)',
	21	=> 'クレジットカード',
);
/** 配送種別ハッシュ	*/
$GLOBALS['SHOPPING_DELIVERY_TYPE_HASH']	= array(
	'0'		=> '通常便',
	'1'		=> 'クール便',
	'11'	=> 'ダウンロード',
	'12'	=> 'サービス',
	'113'	=> '月次課金(初月全額：解月全額)',
	'116'	=> '月次課金(初月無料：解月全額)',
	'119'	=> '月次課金(初月日割：解月全額)',
	'200'	=> '予約(日時)',
	'900'	=> '予約(宿泊)',
	'1000'	=> '予約オプション(日時)',
	'1700'	=> '予約オプション(宿泊)',
);
/** セッション名：商品検索SQL */
define('SHOPPING_SESSION_NAME_PRODUCT_SEARCH_LAST_QUERY','shopping.product.searchLastQuery');
/** CSVカラム定義	*/
$GLOBALS['SHOPPING_PRODUCT_CSV_DEFINITION']	= array(
	'product_id'		=> '商品ID',
	'product_name'		=> '商品名',
	'product_kana'		=> '商品名フリガナ',
	'unit_string'		=> '数え方',
	'categoryIdArray'	=> '商品カテゴリID(カンマ区切り)',
	'status_flag'		=> '状態',
	'delivery_type'		=> '商品種別',
	'calendar_type'		=> 'カレンダー種別',
	'member_viewable'	=> '公開設定（閲覧）',
	'member_purchasable'=> '公開設定（'.$GLOBALS['SHOPPING_LABEL_ORDER'].'）',
	'order_number'		=> '順序番号',
	'catch_copy'		=> 'キャッチコピー',
	'description'		=> '概要説明',
	'detail_comment'	=> '詳細コメント',
	'product_url'		=> '公式URL',
	'option1_name'		=> 'オプション1選択名',
	'option1_items'		=> 'オプション1選択肢',
	'option1_calculate'	=> 'オプション1金額計算',
	'option2_name'		=> 'オプション2選択名',
	'option2_items'		=> 'オプション2選択肢',
	'option2_calculate'	=> 'オプション2金額計算',
	'option3_name'		=> 'オプション3選択名',
	'option3_items'		=> 'オプション3選択肢',
	'option3_calculate'	=> 'オプション3金額計算',
	'option4_name'		=> 'オプション4選択名',
	'option4_items'		=> 'オプション4選択肢',
	'option4_calculate'	=> 'オプション4金額計算',
	'option5_name'		=> 'オプション5選択名',
	'option5_items'		=> 'オプション5選択肢',
	'option5_calculate'	=> 'オプション5金額計算',
	'wholesaler_name'	=> '卸業者名',
	'wholesaler_email'	=> '卸業者メールアドレス',
	'wholesaler_note'	=> '卸業者メモ',
	'updated_date'		=> '最終更新日',
	'registered_date'	=> '登録日',
	'search_data_id'	=> '検索データID',
	'owner_id'			=> '登録者ID',
	'relatedProductIdArray'	=> '関連商品ID(カンマ区切り)',
);
$GLOBALS['SHOPPING_PRODUCT_UNIT_CSV_DEFINITION']	= array(
	'unit_unit_id'				=> '販売単位：販売単位ID',
	'unit_unit_name'			=> '販売単位：商品名',
	'unit_unit_kana'			=> '販売単位：商品名フリガナ',
	'unit_unit_string'			=> '販売単位：商品数え方',
	'unit_status_flag'			=> '販売単位：状態',
	'unit_price_standard'		=> '販売単位：標準価格(税込)',
	'unit_price_sell'			=> '販売単位：販売価格(税込)',
	'unit_cost'					=> '販売単位：コスト',
	'unit_price_monthly'		=> '販売単位：月次課金価格(税込)',
	'unit_stock'				=> '販売単位：Web用在庫数',
	'unit_stock_display'		=> '販売単位：実在庫数',
	'unit_stock_relation'		=> '販売単位：在庫連動販売単位ID',
	'unit_stock_relation_count'	=> '販売単位：在庫連動減算数',
	'unit_order_number'			=> '販売単位：順序番号',
	'unit_discount_exception'	=> '販売単位：割引除外(0/1)',
	'unit_present_point'		=> '販売単位：付与ポイント数',
	'unit_delivery_type'		=> '販売単位：商品種別',
	'unit_calendar_type'		=> '販売単位：カレンダー種別',
	'unit_delivery_weight'		=> '販売単位：梱包目安値',
	'unit_member_viewable'		=> '販売単位：公開設定（閲覧）',
	'unit_member_purchasable'	=> '販売単位：公開設定（'.$GLOBALS['SHOPPING_LABEL_ORDER'].'）',
	'unit_order_number'			=> '販売単位：順序番号',
	'unit_catch_copy'			=> '販売単位：キャッチコピー',
	'unit_description'			=> '販売単位：概要説明',
	'unit_detail_comment'		=> '販売単位：詳細コメント',
	'unit_option1_name'			=> '販売単位：オプション1選択名',
	'unit_option1_items'		=> '販売単位：オプション1選択肢',
	'unit_option1_calculate'	=> '販売単位：オプション1金額計算',
	'unit_option2_name'			=> '販売単位：オプション2選択名',
	'unit_option2_items'		=> '販売単位：オプション2選択肢',
	'unit_option2_calculate'	=> '販売単位：オプション2金額計算',
	'unit_option3_name'			=> '販売単位：オプション3選択名',
	'unit_option3_items'		=> '販売単位：オプション3選択肢',
	'unit_option3_calculate'	=> '販売単位：オプション3金額計算',
	'unit_option4_name'			=> '販売単位：オプション4選択名',
	'unit_option4_items'		=> '販売単位：オプション4選択肢',
	'unit_option4_calculate'	=> '販売単位：オプション4金額計算',
	'unit_option5_name'			=> '販売単位：オプション5選択名',
	'unit_option5_items'		=> '販売単位：オプション5選択肢',
	'unit_option5_calculate'	=> '販売単位：オプション5金額計算',
	'unit_updated_date'			=> '販売単位：最終更新日',
	'unit_registered_date'		=> '販売単位：登録日',
	'unit_owner_id'				=> '販売単位：登録者ID',
	'unit_max_at_once'			=> '販売単位：同時注文可能数',
	'unit_rsv_permit_start'		=> '販売単位：予約可能開始日',
	'unit_rsv_permit_limit'		=> '販売単位：予約可能最終日',
	'unit_default_start_time'	=> '販売単位：チェックイン時間',
	'unit_service_term'			=> '販売単位：サービス提供時間',
);
/** セッション名：注文検索SQL */
define('SHOPPING_SESSION_NAME_ORDER_SEARCH_LAST_QUERY','shopping.order.searchLastQuery');
/** CSVカラム定義	*/
$GLOBALS['SHOPPING_ORDER_CSV_DEFINITION']	= array(
	'order_id'					=> $GLOBALS['SHOPPING_LABEL_ORDER'].'ID',
	'registered_date'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'日',
	'member_member_id'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：会員ID',
	'member_member_class'		=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：種別',
	'member_family_name'		=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：姓',
	'member_family_kana'		=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：姓フリガナ',
	'member_first_name'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：名',
	'member_first_kana'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：名フリガナ',
	'member_pc_mail'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：PCメールアドレス',
	'member_mb_mail'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：携帯メールアドレス',
	'member_zip_code'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：住所1 郵便番号',
	'member_prefecture_number'	=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：住所1 都道府県',
	'member_address'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：住所1 住所・番地',
	'member_building'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：住所1 建物名・部屋番号',
	'member_telephone_number'	=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：住所1 電話番号',
	'member_faximili_number'	=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：住所1 FAX番号',
	'member_mobile_number'		=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：携帯電話番号',
//	'member_zip_code2'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：住所2 郵便番号',
//	'member_prefecture_number2'	=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：住所2 都道府県',
//	'member_address2'				=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：住所2 住所・番地',
//	'member_building2'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：住所2 建物・部屋番号',
//	'member_telephone_number2'	=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：住所2 電話番号',
//	'member_faximili_number2'	=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：住所2 FAX番号',
	'member_company_name'		=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：会社名',
	'member_section_name'		=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：部署名',
	'member_sex'				=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：性別',
	'member_blood_type'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：血液型',
	'member_birth_year'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：生年',
	'member_birth_month'		=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：生月',
	'member_birth_day'			=> $GLOBALS['SHOPPING_LABEL_ORDER'].'者：生日',
	'address_address_name'		=> $GLOBALS['SHOPPING_LABEL_ADDRESS_NAME'].'：名',
	'address_address_kana'		=> $GLOBALS['SHOPPING_LABEL_ADDRESS_NAME'].'：名フリガナ',
	'address_zip_code'			=> $GLOBALS['SHOPPING_LABEL_ADDRESS_NAME'].'：郵便番号',
	'address_prefecture_number'	=> $GLOBALS['SHOPPING_LABEL_ADDRESS_NAME'].'：都道府県名',
	'address_address'			=> $GLOBALS['SHOPPING_LABEL_ADDRESS_NAME'].'：住所・番地',
	'address_building'			=> $GLOBALS['SHOPPING_LABEL_ADDRESS_NAME'].'：建物・部屋番号',
	'address_telephone_number'	=> $GLOBALS['SHOPPING_LABEL_ADDRESS_NAME'].'：電話番号',
	'address_wishful_date'		=> $GLOBALS['SHOPPING_LABEL_ADDRESS_NAME'].'：お届け希望日',
	'address_wishful_time'		=> $GLOBALS['SHOPPING_LABEL_ADDRESS_NAME'].'：お届け希望時間帯',
	'address_delivery_code'		=> $GLOBALS['SHOPPING_LABEL_ADDRESS_NAME'].'：伝票番号',
	'address_order_comment'		=> $GLOBALS['SHOPPING_LABEL_ADDRESS_NAME'].'：通信欄',
	'price_total'				=> '合計金額',
	'buying_flag'				=> '卸販売',
	'promotion_fee'				=> 'プロモーション報酬',
	'discount_price'			=> '割引金額',
	'payment_total'				=> '支払い金額合計',
	'cost_total'				=> '仕入れ合計金額',
	'delivery_price'			=> '配送料合計',
	'wrapping_price'			=> '包装代',
	'point_total'				=> '付与ポイント合計',
	'point_use'					=> '利用ポイント',
	'admin_note'				=> '管理者メモ',
	'promotion_code'			=> 'プロモーションコード',
	'status_flag'				=> '状態',
	'status_settle'				=> '決済',
	'status_promotion'			=> 'プロモーション状態',
	'settle_method'				=> '決済方法',
	'settle_fee'				=> '決済手数料',
	'updated_date'				=> '最終更新日',
);
$GLOBALS['SHOPPING_ORDER_UNIT_CSV_DEFINITION']	= array(
	'unit_id'	=> '商品ID',
	'unit_name'	=> '商品名',
	'price_unit'	=> '商品単価',
	'order_count'	=> $GLOBALS['SHOPPING_LABEL_ORDER'].'数',
	'total_unit_price'	=> $GLOBALS['SHOPPING_LABEL_ORDER'].'金額',
);
/** セッション名：CSVダウンロード商品情報 */
define('SHOPPING_SESSION_NAME_DOWNLOAD_ORDER_UNIT_ITEM','shopping.order.download.orderUnitItem');
/** CSVアップロード時画像フォルダのデフォルト値	*/
define('SHOPPING_PRODUCT_CSV_IMAGES_URI',	'/upload/shopping/product/' );
/** CSVアップロード時ダウンロードファイル登録フォルダのデフォルト値	*/
define('SHOPPING_PRODUCT_CSV_DL_FILES_URI',	'/upload/shopping/product/files' );
/** プロモーションランクハッシュ	*/
$GLOBALS['SHOPPING_PROMOTION_RANK_HASH']	= array(
	'0'		=> '広告出稿(Web)',
	'10'	=> '広告出稿(メール)',
	'20'	=> '広告出稿(媒体)',
	'50'	=> '直アフィリエイト',
	'60'	=> '紹介パートナー',
	'90'	=> '卸業者',
);
/** クッキー名称：プロモーションアクセスコード	*/
define('SHOPPING_COOKIE_NAME_PROMOTION_ACCESS_CODE','SPPAD');

if( file_exists(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'shopping.define.inc.php') ) {
	require_once(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'shopping.define.inc.php');
}
?>