<?php
/*
 * shopping/order/step/ConfirmSettlement.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-10-04
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'DaoShoppingOrder.class.php' );
class shopping_order_step_ConfirmSettlement extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_step_ConfirmSettlement() {
		array_push($this->require_module_array,'shopping.LoadConfig');
		array_push($this->require_module_array,'shopping.order.option.LoadList');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
		if( isset($_GET['shpoi']) && strlen(trim($_GET['shpoi'])) > 0 ) {
			array_push($this->require_module_array,'shopping.order.CartAdmin');
		} else {
			array_push($this->require_module_array,'shopping.order.Cart');
		}
		array_push($this->require_module_array,'shopping.order.step.ConfirmStock');
	}
	/**
	 * executeメソッド
	 */
	function execute( & $request ) {
		// 属性値の取得
		$loginUserObject		= $this->getLoginUserObject( $request );
		$redirect		= $request->getParam('redirect','post');
		// カートオブジェクトの取得
		$shoppingOrderObject	= $request->getAttribute('shopping.order.orderObject');
		// 利用可能な決済方法の読み込み
		$settleMethodObjectArray	= $request->getAttribute('shopping.order.settlement.methodObjectArray');
		// 決済情報
		$shoppingOrderObject->settle_method			= trim(stripslashes($_POST['settle_method']));
		// 妥当性検査:お支払方法
		unset($shoppingOrderObject->columnErrorHash['settle_method']);
		unset($shoppingOrderObject->columnErrorHash['settle_method_errors']);
		if( preg_match('/^[0-9]{1,3}$/',$shoppingOrderObject->settle_method) == 0 ) {
			$shoppingOrderObject->addColumnError($request,'settle_method','shopping.error.cart.invalidsettlemethod');
		} else {
			$methodExists	= false;
			foreach( $settleMethodObjectArray as $settleMethodObject ) {
				if( $settleMethodObject->getMethodNumber() == $shoppingOrderObject->settle_method ) {
					$methodExists	= true;
					break;
				}
			}
			if( !$methodExists ) {
				$shoppingOrderObject->addColumnError($request,'settle_method','shopping.error.cart.invalidsettlemethod');
			} else if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() && !$settleMethodObject->enable ) {
				$shoppingOrderObject->addColumnError($request,'settle_method','shopping.error.cart.closedsettlemethod');
			} else if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() && !$settleMethodObject->enableOnOrder( $request, $shoppingOrderObject ) ) {
				$shoppingOrderObject->addColumnError($request,'settle_method','shopping.error.cart.unavailabledsettlemethod');
			} else if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() && strlen($settleMethodObject->priceMinimum) > 0 && $shoppingOrderObject->payment_total < $settleMethodObject->priceMinimum ) {
				$shoppingOrderObject->addColumnError($request,'settle_method','shopping.error.cart.settlerequirelesscharge',array($settleMethodObject->priceMinimum));
			} else if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() && strlen($settleMethodObject->priceMaximum) > 0 && $shoppingOrderObject->payment_total < $settleMethodObject->priceMaximum ) {
				$shoppingOrderObject->addColumnError($request,'settle_method','shopping.error.cart.settleovermaxcharge',array($settleMethodObject->priceMaximum));
			} else if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() && is_array($settleMethodObject->memberClassArray) && count($settleMethodObject->memberClassArray) > 0 ) {
				$memberClass	= $loginUserObject->member_class;
				if( strlen($memberClass) == 0 ) { $memberClass	= 0; }
				if( !in_array($memberClass,$settleMethodObject->memberClassArray) ) {
					$shoppingOrderObject->addColumnError($request,'settle_method','shopping.error.cart.unavailabledsettlemethod');
				} else {
					// ここまででエラーがないならconfirm時に必要な処理を行う
					$settleMethodObject->confirm( $request, $shoppingOrderObject );
				}
			} else {
				if ( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() && strlen($shoppingOrderObject->order_number) > 0 ) {
					// 管理者ログインで編集時はconfirm処理は行わない
				} else {
					// ここまででエラーがないならconfirm時に必要な処理を行う
					$settleMethodObject->confirm( $request, $shoppingOrderObject );
				}
			}
		}
		// エラーがある場合は前のページにリダイレクトを設定
		if( $request->isError()
		&& preg_match('/^([fF](|[aA][lL][sS][eE])|[nN][oO](|[nN][eE]))$/',$redirect) == 0 ) {
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_SETTLEMENT);
			if( strlen($_SERVER['HTTP_REFERER']) > 0 ) {
				$request->redirectTo($_SERVER['HTTP_REFERER']);
			} else if( preg_match('/^\\.\\//',trim($_POST['referer'])) > 0 ) {
				$request->redirectTo(trim($_POST['referer']));
			}
		} else {
			$confirmResult	= 'OK';
			$shoppingOrderObject->columnErrorHash	= array();
			$shoppingOrderObject->calculated	= false;
			$request->setSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_SETTLEMENT,$confirmResult);
		}
		$request->setAttribute('shopping.order.orderObject',	$shoppingOrderObject );
	}
}
?>