<?php
/*
 * shopping/order/step/ConfirmAddressOption.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-10-04
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'DaoShoppingOrder.class.php');
class shopping_order_step_ConfirmAddressOption extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_step_ConfirmAddressOption() {
		array_push($this->require_module_array,'shopping.LoadConfig');
		array_push($this->require_module_array,'shopping.order.option.LoadList');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
		if( isset($_GET['shpoi']) && strlen(trim($_GET['shpoi'])) > 0 ) {
			array_push($this->require_module_array,'shopping.order.CartAdmin');
		} else {
			array_push($this->require_module_array,'shopping.order.Cart');
		}
		array_push($this->require_module_array,'shopping.order.step.ConfirmStock');
	}
	/**
	 * executeメソッド
	 */
	function execute( & $request ) {
		// カートオブジェクトの取得
		$shoppingOrderObject	= $request->getAttribute('shopping.order.orderObject');
		$redirect			= $request->getParam('redirect','post');
		// 現在の申し込みで住所入力が必要か確認
		$shoppingOrderObject->requireAddress	= false;
		$deliveryTypeArray	= $shoppingOrderObject->getDeliveryTypeArray( $request );
		foreach( $deliveryTypeArray as $deliveryType ) {
			if( $deliveryType < 10 || $deliveryType >= 200 ) {
				$shoppingOrderObject->requireAddress	= true;
				break;
			}
		}
		// 住所オブジェクト追加情報を設定して妥当性検査
		foreach( $shoppingOrderObject->shoppingOrderAddressObjectArray as $num => $addressObject ) {
			$shoppingOrderAddressObject	= & $shoppingOrderObject->shoppingOrderAddressObjectArray[$num];
			// ラッピング関連
			if( isset($_POST['wrapping_type']) ) {
				$shoppingOrderAddressObject->wrapping_type	= $request->getParam('wrapping_type','post',null,$num);
			}
			if( isset($_POST['wrapping_words1']) ) {
				$shoppingOrderAddressObject->wrapping_words1	= $request->getParam('wrapping_words1','post',null,$num);
			}
			if( isset($_POST['wrapping_words2']) ) {
				$shoppingOrderAddressObject->wrapping_words2	= $request->getParam('wrapping_words2','post',null,$num);
			}
			// お届け希望日を暫定で受け取り
			if( isset($_POST['wishful_date']) ) {
				$shoppingOrderAddressObject->wishful_date	= $request->getParam('wishful_date','post',null,$num);
			}
			if( isset($_POST['wishful_time']) ) {
				$shoppingOrderAddressObject->wishful_time	= $request->getParam('wishful_time','post',null,$num);
			}
		}
		// 入力情報を整理
		$shoppingOrderObject->optimize();
		$shoppingOrderObject->calculated	= false;
		// エラーがある場合は前のページにリダイレクトを設定
		if( $request->isError()
		&& preg_match('/^([fF](|[aA][lL][sS][eE])|[nN][oO](|[nN][eE]))$/',$redirect) == 0 ) {
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS_OPTION);
			if( strlen($_SERVER['HTTP_REFERER']) > 0 ) {
				$request->redirectTo($_SERVER['HTTP_REFERER']);
			} else if( preg_match('/^\\.\\//',trim($_POST['referer'])) > 0 ) {
				$request->redirectTo(trim($_POST['referer']));
			}
		} else {
			$confirmResult	= 'OK';
			$shoppingOrderObject->columnErrorHash	= array();
			$request->setSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS_OPTION,$confirmResult);
		}
		$request->setAttribute('shopping.order.orderObject',	$shoppingOrderObject );
	}
}
?>