<?php
/*
 * shopping/order/member/Purchase.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Hiroki Koga
 * Last Update: 2010-08-16
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_order_history_Purchase extends system_login_ModuleBase {
	
	function shopping_order_history_Purchase() {
	}
	function execute( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		$loginUserObject	= $this->getLoginUserObject( $request );
		$memberId			= $loginUserObject->getUniqueId();
		$pageRows			= stripslashes( $_GET['pr'] );
		$pageNumber			= stripslashes( $_GET['pn'] );
		
		$userAgentClass			= $request->getAttribute('spider.access_agent_class');
		
		// ページング制御
		if ( !is_numeric( $pageNumber ) || $pageNumber < 1 ) {
			$pageNumber	= 1;
		}
		if ( !is_numeric( $pageRows ) || $pageRows < 1 ) {
			if( 'au'==$userAgentClass || 'docomo'==$userAgentClass || 'docomo2'==$userAgentClass || 'softbank'==$userAgentClass) {
				$pageRows		= 3;
			} else {
				$pageRows		= 8;
			}
		} else if ( $pageRows > 100 ) {
			if( 'au'==$userAgentClass || 'docomo'==$userAgentClass || 'docomo2'==$userAgentClass || 'softbank'==$userAgentClass) {
				$pageRows		= 3;
			} else {
				$pageRows		= 8;
			}
		}
		
		$conditionArray	= array();
		// 状態フラグ
		$str	= TABLE_NAME_SHOPPING_ORDER.'.status_flag<200';
		array_push( $conditionArray, $str );

		$conditionString	= '';
		if ( strlen(trim($memberId)) > 0 ) {
			$str	= TABLE_NAME_SHOPPING_ORDER.'.member_id='.$dbo->quote($memberId);
			array_push( $conditionArray, $str );
		}
		
		if ( count( $conditionArray ) > 0 ) {
			$conditionString	= ' WHERE '.implode( ' AND ', $conditionArray );
		}
		// 最近購入した販売単にIDの取得
		$UnitObjectArray = array();
		$sql	= 'SELECT '.TABLE_NAME_SHOPPING_ORDER_ITEM.'.unit_id '
			.' , MAX('.TABLE_NAME_SHOPPING_ORDER.'.registered_date) AS orderRegiDate '
			.' FROM '.TABLE_NAME_SHOPPING_ORDER_ITEM
			.' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_ORDER
			.' ON ' . TABLE_NAME_SHOPPING_ORDER . '.order_id='.TABLE_NAME_SHOPPING_ORDER_ITEM.'.order_id '
			.$conditionString
			.' GROUP BY '.TABLE_NAME_SHOPPING_ORDER_ITEM.'.unit_id'
			.' ORDER BY orderRegiDate DESC'
		;
		$dbo->setLimit( $pageRows, ( $pageNumber - 1 ) * $pageRows );
		$dataArray	= $dbo->queryAll( $sql, 'hash' );
		if ( $dataArray === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			foreach ( $dataArray as $row ) {
				// 取得した販売単位IDからオブジェクトを取得
				$unitId = trim($row['unit_id']);
				$unitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
				if( $dbo->loadById( $unitObject, $unitId ) ) {
					$unitObject->shoppingProductObject->loadRelatedSearchData( $dbo );
					$UnitObjectArray[$unitId] = $unitObject;
				}
			}
		}
		$request->setAttribute( 'shopping.order.history.purchase.unitObjectArray', $UnitObjectArray );
	}
}
?>