<?php
/*
 * shopping/order/file/Download.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-12-16
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_order_file_Download extends system_login_ModuleBase {
	function shopping_order_file_Download(){
		array_push( $this->require_module_array, 'shopping.order.Load' );
	}
	function execute( & $request ) {
		$dbo						= $request->getAttribute('dbo');
		$itemNumber					= $request->getParam('shpoin','get');
		$orderNumber				= $request->getParam('shpoinn','get');
		$shoppingOrderItemObject	= spider_Controller::createObject('shopping_DaoShoppingOrderItem');
		$loginUserObject			= $this->getLoginUserObject( $request );
		$shoppingOrderObject		= $request->getAttribute( 'shopping.order.orderObject' );
		
		if( defined('SHOPPING_ORDER_ITEM_FILE_USE') && '1' == SHOPPING_ORDER_ITEM_FILE_USE ){
		} else {
			$request->addLocaledError('shopping.error.order.file.unavairable',SPIDER_LOG_LEVEL_FATAL,array(''));
			return;
		}
		// 入力の確認
		if( preg_match('/^[0-9]{1,2}$/',$orderNumber) == 0 ) {
			$request->addLocaledError('system.error.common.invalidaccess',SPIDER_LOG_LEVEL_FATAL,array(''));
			return;
		}
		// 編集権限の確認
		if( $this->isLogin( $request ) ) {
			if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
				// 管理者ログインは編集可
			} else if ( $loginUserObject->getUniqueId() == $shoppingOrderObject->member_id ) {
				// 申込者は編集可
			} else {
				$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
			}
		} else {
			$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
		}
		
		$fileObjectOrgHash	= array();
		if( !$request->isError() ) {
			if( strlen(trim($itemNumber)) > 0 ) {
				// 商品番号が指定されているなら情報読み込み
				if( $dbo->loadByNumber( $shoppingOrderItemObject, $itemNumber ) ) {
				} else {
					$request->addLocaledError('shopping.error.order.file.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				$request->addLocaledError('shopping.error.order.file.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		// エラーがなければダウンロード
		if( !$request->isError() ) {
			$targetFilePath	= $shoppingOrderItemObject->getUploadFilePath( $request, $orderNumber );
			preg_match('/\\.(jpg|png|xls|txt|zip|lzh|doc|pdf|ai|eps|ppt)$/',basename($targetFilePath),$matches);
			$request->setResponseHeader('Content-Disposition', 'attachment; filename="'.$shoppingOrderItemObject->order_id.'_'.$shoppingOrderItemObject->item_id.'_'.sprintf('%02d',$orderNumber).$matches[0].'"' );
			if( function_exists('mime_content_type') ) {
				$request->setResponseHeader('Content-Type', mime_content_type(basename($targetFilePath)) );
			} else {
				$request->setResponseHeader('Content-Type', 'application/octet-stream' );
			}
			$request->setResponseFile( $targetFilePath );
		}
		$request->setAttribute('shopping.order.file.item_object',	$shoppingOrderItemObject);
		$request->setAttribute('shopping.order.file.item_number',	$itemNumber);
		$request->setAttribute('shopping.order.file.order_number',	$orderNumber);
	}
}
?>