<?php
/*
 * shopping/order/download/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_order_download_Confirm extends system_login_ModuleBase {
	
	function shopping_order_download_Confirm(){
	}
	function execute( & $request ) {
		// 変数取得
		$dbo					= $request->getAttribute( 'dbo' );
		$sessionHashName		= 'shopping.order.download.columnSelectedArray';
		$columnSelectedArray	= $_POST['selected_items'];

		// ダウンロードする対象クエリの確認
		$totalCount		= 0;
		$queryHash	= $request->getSession(SHOPPING_SESSION_NAME_ORDER_SEARCH_LAST_QUERY, SPIDER_SESSION_SCOPE_GLOBAL);
		if( !is_array($queryHash) ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_FATAL,array());
		} else if( strlen($queryHash['countQuery']) == 0 || strlen($queryHash['loadQuery']) == 0 ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_FATAL,array());
		} else {
			$totalCount	= $dbo->queryOne($queryHash['countQuery']);
			if ( $totalCount === false ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($queryHash['countQuery']));
			}
		}

		if( !is_array($columnSelectedArray) && strlen($columnSelectedArray) == 0 ) {
			$request->addLocaledError('system.error.common.csvdl.selectcolumn',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			if( !is_array($columnSelectedArray) ) {
				$str	= $columnSelectedArray;
				$columnSelectedArray	= array();
				array_push($columnSelectedArray,$str);
			}
			foreach( $columnSelectedArray as $orderNumber => $columnName ) {
				if( !array_key_exists($columnName, $GLOBALS['SHOPPING_ORDER_CSV_DEFINITION']) ) {
					$request->addLocaledError('system.error.common.csvdl.columnnotfound',SPIDER_LOG_LEVEL_FATAL,array($orderNumber));
				}
			}
			// 商品を左端に追加するフラグ
			if ( preg_match('/^[tT][rR][uU][eE]$/',$_POST['unitOrderItem'])>0 ) {
				array_push($columnSelectedArray,'item_all');
			}
			if( $request->isError() ) {
				$request->removeSession($sessionHashName);
			} else {
				$request->setSession( $sessionHashName, $columnSelectedArray );
			}
		}
		
		$request->setAttribute('shopping.order.download.culumnSelectedArray', $columnSelectedArray );
		$request->setAttribute('shopping.order.download.totalCount', $totalCount );
	}
}
?>