<?php
/*
 * shopping/category/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoShoppingCategory.class.php');
class shopping_category_LoadList extends system_login_ModuleBase {
	
	function shopping_category_LoadList() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo				= $request->getAttribute( 'dbo' );
		
		// 検索条件
		$conditionArray	= array();
		// 状態フラグ
		$str	= TABLE_NAME_SHOPPING_CATEGORY.'.status_flag<200';
		array_push( $conditionArray, $str );
		// ルートカテゴリのみ
		$str	= '( '.TABLE_NAME_SHOPPING_CATEGORY.'.parent_id IS NULL'
			. ' OR '
			. TABLE_NAME_SHOPPING_CATEGORY.'.parent_id="" )'
		;
		array_push( $conditionArray, $str );

		// 条件整理
		$condition_string	= '';
		if( count( $conditionArray ) > 0 ) {
			$condition_string	= ' WHERE ( ' . implode(' ) AND ( ', $conditionArray) . ' )';
		}
		
		$sql	= 'SELECT * '
			. ' FROM ' . TABLE_NAME_SHOPPING_CATEGORY
			. $condition_string
			. ' ORDER BY '
			. TABLE_NAME_SHOPPING_CATEGORY . '.order_number ASC'
			. ',' . TABLE_NAME_SHOPPING_CATEGORY . '.category_kana ASC'
		;
		$shoppingCategoryObject = spider_Controller::createObject('shopping_DaoShoppingCategory');
		$categoryObjectArray	= $dbo->queryAll( $sql, $shoppingCategoryObject, true, false );
		if ( $categoryObjectArray === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			// カテゴリIDをキーとするハッシュも作って属性登録する。オブジェクトはメモリ考慮し全て参照
			$categoryNameHash	= array();
			$categoryObjectHash	= array();
			foreach( $categoryObjectArray as $key => $categoryObject ) {
				$categoryNameHash[$categoryObject->category_id]	= $categoryObject->category_name;
				$categoryObjectHash[$categoryObject->category_id]	= & $categoryObjectArray[$key];
				if( is_array( $categoryObject->child_category_object_array) ) {
					foreach( $categoryObject->child_category_object_array as $ckey => $childCategoryObject ) {
						$categoryNameHash[$childCategoryObject->category_id]	= $childCategoryObject->category_name;
						$categoryObjectHash[$childCategoryObject->category_id]	= & $categoryObjectArray[$key]->child_category_object_array[$ckey];
						if( is_array( $childCategoryObject->child_category_object_array) ) {
							foreach( $childCategoryObject->child_category_object_array as $gckey => $gChildCategoryObject ) {
								$categoryNameHash[$gChildCategoryObject->category_id]	= $gChildCategoryObject->category_name;
								$categoryObjectHash[$gChildCategoryObject->category_id]	= & $categoryObjectArray[$key]->child_category_object_array[$ckey]->child_category_object_array[$gckey];
							}
						}
					}
				}
			}
			
			$request->setAttribute('shopping.category.data_array', $categoryObjectArray );
			$request->setAttribute('shopping.category.nameHash', $categoryNameHash );
			$request->setAttribute('shopping.category.objectHash', $categoryObjectHash );
		}
		$request->setAttribute('shopping.category.require_columns_hash',$GLOBALS['SHOPPING_CATEGORY_REQUIRE_COLUMNS_HASH']);
	}
}
?>