<?php
/*
 * shopping/DaoShoppingOrderOption.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
/**
 * shopping_DaoShoppingOrderOption
 * shoppingパッケージ データアクセスオブジェクトクラス shopping_order_optionテーブル用
 */
class shopping_DaoShoppingOrderOption extends database2_AbstractData {
	// 設定メンバ
	/** オプション番号	*/
	var $optionNumber;
	/** オプション項目名	*/
	var $optionName;
	/** 入力欄幅		*/
	var $width		= 20;
	/** 入力欄行数		*/
	var $height		= 1;
	/** 必須フラグ		*/
	var $required	= true;
	/** 計算フラグ：0=注文数に乗算する, 1=注文数に乗算しない	*/
	var $calculate_flag	= 0;
	/** オプション		*/
	var $options	= '';
	/** オプション金額	*/
	var $prices		= '';
	/** オプション仕入値	*/
	var $costs		= '';
	/** 説明文			*/
	var $explain	= '';
	
	// データベースメンバ
	/** シリアル番号	*/
	var $option_number;
	/** 注文ID	*/
	var $order_id;
	/** 宛先ID	*/
	var $address_id;
	/** 注文アイテムID：注文に直接紐づける際はNULLのままとします	*/
	var $item_id;
	/** 注文アイテム順序	*/
	var $item_order	= 0;
	/** オプション名（ラベル	*/
	var $option_name;
	/** オプション値文字列	*/
	var $option_value;
	/** オプションクラス名	*/
	var $option_class;
	/** オプション単価(注文発生時点の単価	)	*/
	var $option_price	= 0;
	/** オプションコスト(注文発生時点のコスト)	*/
	var $option_cost	= 0;
	/** 注文個数	*/
	var $order_count	= 1;
	/** オプションのサービス開始日時*/
	var $svc_start_date;
	/** オプションのサービス終了日時*/
	var $svc_limit_date;
	/**
	 * コンストラクタ
	 */
	function shopping_DaoShoppingOrderOption() {
	}
	/**
	 * フィールドデータの妥当性検査を実行します
	 * @param $request spider_HttpRequestオブジェクトインスタンス参照
	 */
	function validateFields( & $request ) {
		// エラーを一度クリア
		$this->clearColumnErrors();
		if( $this->required ) {
			// 必須の場合
			if( is_array($this->option_value) ) {
				if( count($this->option_value) == 0 ) {
					$this->addColumnError($request,'option_value','shopping.error.cart.option.requireselect',array($this->optionName));
				}
			} else if( strlen($this->option_value) == 0 ) {
				$this->addColumnError($request,'option_value','shopping.error.cart.option.requireinput',array($this->optionName));
			}
		}
	}
	/**
	 * 本オブジェクトが保持するデータのデータベーステーブル名を取得します。
	 * テーブル名は実装クラス名を_で区切った末尾文字列に対して大文字部分を_[小文字]に置き換えた文字列です。
	 * 例えばDaoAdminMemberならadmin_memberとなります。
	 */
	function getTableName() {
		return TABLE_NAME_SHOPPING_ORDER_OPTION;
	}
	/**
	 * 入力フォームを表示する抽象メソッド 
	 * @param $request spider_HttpRequestオブジェクトインスタンス参照
	 * @param $value 入力値
	 * @param $background 背景色
	 * @param $formNameNames フォーム名：オプション名
	 * @param $formNameValue フォーム名:オプション値
	 * @return strings 入力フォームHTML文字列
	 */
	function getInputForm( & $request, $value='', $background=null, $formNameNames=null, $formNameValue=null ) {
	}
	/**
	 * オプションタイプを取得
	 * @return string オプションタイプ文字列
	 */
	function getOptionType() {
		$name		= get_class($this);
		$elms		= explode('_',$name);
		$typeName	= ucfirst(array_pop($elms));
		return $typeName;
	}
	/**
	 * インサート前に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function pre_insert( $dbo ) {
		$this->option_class	= get_class($this);
		return true;
	}
	/**
	 * オプションに入力された値を文字列で取得します
	 */
	function getInputValues( $value='' ) {
		if( is_array($value) ) {
			return implode('/',$value);
		} else {
			return $value;
		}
	}
	//
	// 計算
	//
	/**
	 * 現在のオプション情報を取得して金額を再計算
	 * タイプにより実装をオーバーライドする
	 * 注文個数は予め設定してから呼び出してください
	 * @param $request spider_HttpRequestオブジェクト参照
	 */
	function calculate( & $request, $renew=false ) {
		if( $renew ) {
			$this->option_price	= 0;
			$this->option_cost	= 0;
		}
	}
	/**
	 * 合計金額を取得
	 * @param $request spider_HttpRequestオブジェクト参照
	 */
	function getTotalPrice( & $request ) {
		return $this->option_price * $this->order_count;
	}
	/**
	 * 合計コストを取得
	 * @param $request spider_HttpRequestオブジェクト参照
	 */
	function getTotalCost( & $request ) {
		return $this->option_cost * $this->order_count;
	}
	// スタティックメンバ
	/**
	 * 商品に登録されたオプションをoption_values文字列でオブジェクト精製
	 */
	function createProductOptionObject( $optionName, $strings, $explanation='' ) {
		if( strlen(trim($optionName)) == 0 ) {
			return false;
		} else if( strlen(trim($strings)) == 0 ) {
			return false;
		}
		$strings	= str_replace("\r\n","\n",trim($strings));
		$strings	= str_replace("\r","\n",$strings);
		$optionItemLines	= explode("\n",$strings);
		// 項目タイプを取り出し
		$optionClassType	= trim(array_shift($optionItemLines));
		$optionObject			= null;
		if( '__INPUT_TYPE_TEXTAREA__' == $optionClassType ) {
			$optionObject	= spider_Controller::createObject('shopping_order_option_type_TextArea');
			if( count($optionItemLines) > 0 ){
				$optionObject->width	= trim(array_shift($optionItemLines));
				if( count($optionItemLines) > 0 ){
					$optionObject->height	= trim(array_shift($optionItemLines));
				} else {
					$optionObject->height	= 2;
				}
			} else {
				$optionObject->width	= 20;
				$optionObject->height	= 2;
			}
		} else if( '__INPUT_TYPE_TEXT__' == $optionClassType ) {
			$optionObject	= spider_Controller::createObject('shopping_order_option_type_Text');
			if( count($optionItemLines) > 0 ){
				$optionObject->width	= trim(array_shift($optionItemLines));
			} else {
				$optionObject->width	= 20;
			}
		} else if( '__INPUT_TYPE_TEXT_COUNT_CHARGE__' == $optionClassType ) {
			$optionObject	= spider_Controller::createObject('shopping_order_option_type_TextCountCharge');
			$optionObject->width	= 1;
			if( count($optionItemLines) > 0 ){
				// 2行目単価
				$optionObject->prices	= trim(array_shift($optionItemLines));
				if( count($optionItemLines) > 0 ){
					// 3行目 最大数
					$optionObject->maxCount	= trim(array_shift($optionItemLines));
				} else {
					$optionObject->maxCount	= -1;
				}
			} else {
				$optionObject->prices	= 0;
			}
		} else {
			$optionObject	= spider_Controller::createObject('shopping_order_option_type_Select');
			array_unshift($optionItemLines,$optionClassType);
			foreach( $optionItemLines as $line ) {
				$line	= trim($line);
				if( strlen($line) == 0 ) {
					if( count($optionItemLines) == 1 ){
						break;
					} else {
						$optionObject->options	.= "\n";
						$optionObject->prices	.= "0\n";
						$optionObject->costs	.= "0\n";
					}
				} else {
					$elmArray	= explode(':',$line);
					$cost=0;$price=0;$label='';
					if( count($elmArray) >= 3 ) {
						$cost	= array_pop($elmArray);
						$price	= array_pop($elmArray);
						$label	= implode(':',$elmArray);
					} else if( count($elmArray) >= 2 ){
						$price	= array_pop($elmArray);
						$label	= implode(':',$elmArray);
					} else {
						$label	= implode(':',$elmArray);
					}
					$optionObject->options	.= $label."\n";
					$optionObject->prices	.= $price."\n";
					$optionObject->costs	.= $cost."\n";
				}
			}
			$optionObject->options	= trim($optionObject->options);
			$optionObject->prices	= trim($optionObject->prices);
			$optionObject->costs	= trim($optionObject->costs);
		}
		$optionObject->optionName		= $optionName;
		$optionObject->option_name	= $optionName;
		$optionObject->explanation	= $explanation;
		$optionObject->required			= true;
		return $optionObject;
	}
	/**
	 * この宛先に紐づいた購入情報の指定率の金額を計算して取得
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $rate int 割合(百分率の整数)
	 * @param $roundMethod int 0=切り捨て, 1=切り上げ, 2=四捨五入, 3=五捨六入
	 * @param $denominator 分母（デフォルト100)
	 * @return int 金額
	 */
	function calculatePriceRate( & $request, $rate=5, $roundMethod=0, $denominator=100 ) {
		$price	= ( $this->option_price * $rate / $denominator );
		$price	= shopping_PackageConfig::_roundNumeric($price, $roundMethod);
		$price	= $price * $this->order_count;
		return $price;
	}
	
	/**
	 * 注文商品情報メール送信用文字列を注文内容に変換した文字列を取得
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $shoppingOrderObject shopping_DaoShoppingOrderオブジェクト
	 * @param $targetAddress 送信先メールアドレス
	 * @param $infoType wholesale/other
	 * @return string 変換後文字列
	 */
	function getMailStrings( & $request, $shoppingOrderObject, $targetAddress, $infoType=null, $searchDataObject ) {
		// フォーマット決定
		$formatName	= 'SHOPMAILSUBOPTSP';
		if( 'wholesale' == $infoType ) {
			$formatName	= 'SHOPMAILSUBOPTSA';
		}
		$optionFormatHash	= shopping_PackageConfig::getMailTemplateInformation( $request, $formatName, $targetAddress );
		if( false === $optionFormatHash ) {
			return false;
		}
		$optionFormat	= $optionFormatHash['strings'];
		// 置換処理
		$replaceHash	= array(
		'option_name'	=> $this->option_name,
		'option_value'	=> $this->option_value,
		'option_price'	=> $this->option_price,
		'option_cost'	=> $this->option_cost,
		'order_count'	=> $this->order_count,
		'option_price_total'	=> $this->getTotalPrice( $request ),
		'option_cost_total'		=> $this->getTotalCost( $request ),
		'search'	=> $searchDataObject,
		);
		spider_Controller::loadClassDefinition('util_Mail');
		$optionFormat	= util_Mail::replaceFormatStrings( $optionFormat, $replaceHash );
		return $optionFormat;
	}
	//
	// 非推奨メソッド
	//
	/**
	 * 妥当性検査を行うメソッド
	 * @param $request spider_HttpRequestオブジェクトインスタンス参照
	 * @param $value 妥当性検査を行う入力値
	 * @return array エラーメッセージの配列
	 * @deprecated
	 */
	function validate( & $request, $value ) {
		$errors	= array();
		if( $this->required ) {
			// 必須の場合
			if( is_array($value) ) {
				if( count($value) == 0 ) {
					array_push( $errors, $this->optionName.'は一つ以上入力してください。');
				}
			} else if( strlen($value) == 0 ) {
				array_push( $errors, $this->optionName.'を入力してください。');
			}
		}
		return $errors;
	}
	/**
	 * オブジェクト比較して要素の違いを抽出します
	 * @param spider_HttpRequest &$request spider_HttpRequestインスタンス参照
	 * @param object $compareObject 比較対象オブジェクト
	 * @return array 違いのキーと値ハッシュ
	 */
	function getDifference( & $request, $compareObject ) {
		$defferenceHash	= parent::getDifference( $request, $compareObject );
		$newDefferenceHash	= array();
		$GLOBALS['SHOPPING_DEFFERENCE_ORDER_OPTION_HASH']	= array(
			'option_name'	=>'オプション名',
			'option_value'	=>'オプション値',
			'option_price'	=>'単価',
			'option_cost'	=>'コスト単価',
			'order_count'	=>$GLOBALS['SHOPPING_LABEL_ORDER'].'数',
			'svc_start_date'	=>'チェックイン日時',
			'svc_limit_date'	=>'チェックアウト日時',
		);
		foreach( $defferenceHash as $key => $val ){
			if( array_key_exists($key,$GLOBALS['SHOPPING_DEFFERENCE_ORDER_OPTION_HASH']) ){
				$newKey	= $GLOBALS['SHOPPING_DEFFERENCE_ORDER_OPTION_HASH'][$key];
				$newDefferenceHash[$newKey]	= $val;
			}
		}
		return $newDefferenceHash;
	}
	/**
	 * オプション行を配列で取得
	 */
	function getOptionLineArray(){
		$this->options	= trim($this->options);
		$this->options	= str_replace("\r\n","\n",$this->options);
		$this->options	= str_replace("\r","\n",$this->options);
		return explode("\n",$this->options);
	}
}
// オプションクラスファイルを要求
$shoppingOrderOptionDir = dirname(__FILE__)
.DIRECTORY_SEPARATOR.'order'.DIRECTORY_SEPARATOR.'option'.DIRECTORY_SEPARATOR.'type';
if( $optionDirHandle = @opendir($shoppingOrderOptionDir) ) {
  while (($optionClassFileName = readdir($optionDirHandle)) !== false) {
    if( preg_match('/\\.class\\.php$/',$optionClassFileName) > 0 ){
      $optionClassAbsolutePath  = $shoppingOrderOptionDir.DIRECTORY_SEPARATOR.$optionClassFileName;
      require_once($optionClassAbsolutePath);
    }
  }
  @closedir($optionDirHandle);
}
?>