<?php
/*
 * member/scripts/join.cmd.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 * 
 * 空メールユーザー登録を処理するコマンドスクリプト
 * 2009/07/07
 */
// コマンド共通モジュール取り込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'spider'
.DIRECTORY_SEPARATOR.'spider.cmd.php');
// データベース接続クラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'Connect.class.php');
// 文字操作ユーティリティ
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'CharUtility.class.php');
// メール送信クラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'Mail.class.php');
// メール送信クラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'mail'
.DIRECTORY_SEPARATOR.'Mime.class.php');
// システム設定クラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
// 会員パッケージ設定クラスの読み込み
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
// 会員DAOクラスの読み込み
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoMember.class.php');
// 会員パッケージメールアドレス一時保存テーブルクラス
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoMemberRegistTemporary.class.php');
// 会員メールテンプレートDAOクラスの読み込み
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoMemberMailTemplate.class.php');

// メール送信可能な設定を通過したかのフラグ
$canSendMail	= false;
// スクリプト実行ログファイルURI
$scriptLogUri	= '/member/script/join/'.date('Y').'/'.date('m').'.log';
//
// 処理開始
//
$request	= $GLOBALS['request'];
$systemPackageConfigObject	= new system_PackageConfig();
if( $systemPackageConfigObject->load($GLOBALS['request']) ) {
} else {
	$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_FATAL,array(''));
}
$memberPackageConfigObject	= new member_PackageConfig();
if( $memberPackageConfigObject->load($GLOBALS['request']) ) {
} else {
	$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_FATAL,array(''));
}
// メール送信オブジェクト作成
$mailClassName	= '';
$mailSendOptions		= array();
if( defined('MEMBER_MAIL_SEND_METHOD') && strlen(MEMBER_MAIL_SEND_METHOD) > 0 ) {
	// 会員パッケージの設定
	if( is_array($GLOBALS['SYSTEM_SEND_METHOD'][MEMBER_MAIL_SEND_METHOD]) ) {
		$mailClassName	= $GLOBALS['SYSTEM_SEND_METHOD'][MEMBER_MAIL_SEND_METHOD]['class_name'];
		if( is_array($GLOBALS['MEMBER_MAIL_SEND_METHOD_OPTIONS']) ) {
			$mailSendOptions		= $GLOBALS['MEMBER_MAIL_SEND_METHOD_OPTIONS'];
		}
	}
}
if( strlen($mailClassName) == 0 ) {
	// 会員パッケージの設定がないならシステム設定の取得を試みる
	if( file_exists(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'system.define.inc.php') ) {
		require_once(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'system.define.inc.php');
		if( defined('SYSTEM_MAIL_SEND_METHOD') && strlen(SYSTEM_MAIL_SEND_METHOD) > 0 ) {
			if( is_array($GLOBALS['SYSTEM_SEND_METHOD'][SYSTEM_MAIL_SEND_METHOD]) ) {
				$mailClassName	= $GLOBALS['SYSTEM_SEND_METHOD'][SYSTEM_MAIL_SEND_METHOD]['class_name'];
				if( is_array($GLOBALS['SYSTEM_MAIL_SEND_METHOD_OPTIONS']) ) {
					$mailSendOptions		= $GLOBALS['SYSTEM_MAIL_SEND_METHOD_OPTIONS'];
				}
			}
		}
	}
}
if( strlen($mailClassName) == 0 ) {
	$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_FATAL,array(''));
}

// スタンダードインからメールデータを取得
$mailData		= file_get_contents("php://stdin");
$receiveMail	= new util_mail_Mime($mailData);
// 設定に従ってメール送信オブジェクトを作成
if( strlen($receiveMail->from) == 0 ) {
	$request->addLocaledError('member.error.common.failtogetfrom',SPIDER_LOG_LEVEL_FATAL,array(''));
}
//
// メール送信可能状態での確認
//
if( $GLOBALS['request']->isError() ) {
	// ここまででエラーがある場合はログを記録して終了
	foreach( $GLOBALS['request']->errors as $error ) {
		$GLOBALS['request']->error( $receiveMail->from.' - '. $error, $scriptLogUri );
	}
	exit(0);
} else {
	// メール送信自体は可能な場合
	$canSendMail	= true;
	// 登録可能なFQDNからのメールか確認する
	$canRegist	= false;
	foreach( $GLOBALS['MOBILE_MAIL_DOMAIN_ARRAY'] as $fqdn ) {
		if( preg_match('/'.util_CharUtility::escapeRegxStr($fqdn).'$/', $receiveMail->from) > 0 ) {
			$canRegist	= true;
			break;
		}
	}
	if( !$canRegist ) {
		$request->addLocaledError('member.error.common.requiremobilemail',SPIDER_LOG_LEVEL_FATAL,array(''));
	}
}

//
// データベースに接続する
//
database2_Connect::execute( $GLOBALS['request'] );
$dbo	= $GLOBALS['request']->getAttribute('dbo');
$joinFormUrl	= $memberPackageConfigObject->definitionHash['MEMBER_REGIST_MAIL_URL'].$registKey;
list($protocol,$sp,$fqdn,$etc)	= explode('/',$joinFormUrl);
$baseUrl		= $protocol.'//'.$fqdn.'/';

//
// 登録済み会員の確認
//
if( !$GLOBALS['request']->isError() ) {
	$sql	= 'SELECT * FROM '.TABLE_NAME_MEMBER
		.' WHERE mb_mail='.$dbo->quote($receiveMail->from)
		.' AND status_flag >= 100 AND status_flag < 200'
	;
	$memberObject	= new member_DaoMember();
	$result			= $dbo->queryAll( $sql,$memberObject,true );
	if ( false === $result ) {
		$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
	} else if( count($result) == 1 ) {
		// 該当の会員レコードがあるなら
		$memberObject	= $result[0];
		// メールテンプレートをデータベースから読み込み
		$mailTemplateObject	= new member_DaoMemberMailTemplate();
		if( $dbo->loadById($mailTemplateObject,'MEMBERPASSWD') ) {
			// 置換ワード設定
			$replaceHash		= array();
			$replaceHash['url_base']	= $baseUrl;
			$replaceHash['base_url']	= $baseUrl;
			$replaceHash['member']		= $memberObject;
			// リマインダ送信処理
			$deliveryStatus		= $mailTemplateObject->sendMail( $GLOBALS['request'], $receiveMail->from, $replaceHash );
			// 送信状態ごとのエラーメッセージ
			switch ( $deliveryStatus ) {
				case 254:
					$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_FATAL,array($deliveryStatus));
					break;
				case 1:
					database2_Connect::post_process( $GLOBALS['request'] );
					$GLOBALS['request']->error( $receiveMail->from.' - 通知メールを送信しました', $scriptLogUri );
					exit(0);
				default:
					$request->addLocaledError('member.error.common.sendmail',SPIDER_LOG_LEVEL_FATAL,array($deliveryStatus));
					break;
			}
		} else {
			$request->addLocaledError('member.error.common.mailnobody',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
	} else if( count($result) > 1 ) {
		// 該当の会員レコードが複数あるならシステム上の矛盾が発生しているのでエラー
		$request->addLocaledError('member.error.common.duplicatedregistration',SPIDER_LOG_LEVEL_FATAL,array(''));
	} else {
		$result	= null;
	}
}
//
// 固有キーの生成と登録
//
$registKey	= null;
if( !$GLOBALS['request']->isError() ) {
	// 年月日と登録固有キーを生成
	$year		= date('Y');
	$month		= date('m');
	$day		= date('d');
	$uniqueKey	= util_CharUtility::get_rundom_key(24);
	$registKey	= $year.$month.$day.$uniqueKey;
	// 固有キーとFromメールアドレスを一時テーブルにインサートする
	$sql		= 'INSERT INTO '.TABLE_NAME_MEMBER_REGIST_TEMPORARY.'(temporary_id,email,registered_date) VALUES ('
		.$dbo->quote($registKey)
		.','.$dbo->quote($receiveMail->from)
		.',NOW() )';
	$result	= $dbo->query($sql);
	if( false === $result ) {
		$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array($sql));
	} else {
		$joinFormUrl	.= $registKey;
	}
}
//
// メール送信テンプレートの読み込み
//
$mailTemplateObject	= null;
if( $GLOBALS['request']->isError() ) {
	// エラーがあるならエラーメールテンプレート
	$mailTemplateObject	= new member_DaoMemberMailTemplate();
	if( $dbo->loadById($mailTemplateObject,'MEMBERERRORRT') ) {
	} else {
		$request->addLocaledError('member.error.common.mailnobody',SPIDER_LOG_LEVEL_FATAL,array(''));
	}
} else {
	// エラーがないなら登録準備OKテンプレート
	$mailTemplateObject	= new member_DaoMemberMailTemplate();
	if( $dbo->loadById($mailTemplateObject,'MEMBERMBRTNREADY') ) {
	} else {
		$request->addLocaledError('member.error.common.mailnobody',SPIDER_LOG_LEVEL_FATAL,array(''));
	}
}
//
// データベース切断
//
database2_Connect::post_process( $GLOBALS['request'] );

//
// メール返信処理
//
if( !is_null($mailTemplateObject) ) {
	// 空の会員オブジェクトを作成
	$memberObject				= new member_DaoMember();
	$memberObject->view_name	= $receiveMail->from;
	$memberObject->mb_mail		= $receiveMail->from;
	// 共通置換ワード
	$replaceHash		= array();
	$replaceHash['url_base']		= $baseUrl;
	$replaceHash['base_url']		= $baseUrl;
	$memberObject->view_name	= $receiveMail->from;
	$memberObject->mb_mail		= $receiveMail->from;
	$replaceHash['member']		= $memberObject;
	// メール送信処理分岐
	if( !$GLOBALS['request']->isError() ) {
		// 置換ワード設定
		$replaceHash['join_form_url']	= $joinFormUrl;
		// エラーがないなら正常メール返信
		$deliveryStatus		= $mailTemplateObject->sendMail( $GLOBALS['request'], $receiveMail->from, $replaceHash );
		// 送信状態ごとのエラーメッセージ
		switch ( $deliveryStatus ) {
			case 254:
				$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_FATAL,array($deliveryStatus));
				break;
			case 1:
				break;
			default:
				$request->addLocaledError('member.error.common.sendmail',SPIDER_LOG_LEVEL_FATAL,array($deliveryStatus));
				break;
		}
		$sended	= true;;
	} else if( $canSendMail ) {
		// 置換ワード設定
		$replaceHash['join_form_url']	= '';
		$replaceHash['errors']			= implode("\n",$GLOBALS['request']->errors);
		// エラーメール送信処理
		$deliveryStatus		= $mailTemplateObject->sendMail( $GLOBALS['request'], $receiveMail->from, $replaceHash );
		// 送信状態ごとのエラーメッセージ
		switch ( $deliveryStatus ) {
			case 254:
				$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_FATAL,array($deliveryStatus));
				break;
			case 1:
				break;
			default:
				$request->addLocaledError('member.error.common.sendmail',SPIDER_LOG_LEVEL_FATAL,array($deliveryStatus));
				break;
		}
	}
}
// ログを記録
if( $GLOBALS['request']->isError() ) {
	// エラーがあるならエラーログを記録
	$GLOBALS['request']->fatal( '[error]'.$receiveMail->from.' - '.implode(':',$GLOBALS['request']->errors), $scriptLogUri );
	exit(0);
} else {
	// エラーがないなら正常送信ログを記録
	$GLOBALS['request']->fatal( '[SENT OK]'.$receiveMail->from.' - '.implode(':',$GLOBALS['request']->errors), $scriptLogUri );
	exit(0);
}
?>