<?php
/*
 * member/member/point/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 ポイント編集実行用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_point_Execute extends system_login_ModuleBase {
	function member_member_point_Execute() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$memberId				= stripslashes( $_GET['mi'] );
		$sessionObjectName		= 'member.member.point.modify.object.'.$memberId;
		$sessionConfirmName		= 'member.member.point.modify.confirm.'.$memberId;
		$memberObject			= $request->getSession($sessionObjectName);
		$compareMemberObject	= spider_Controller::createObject('member_DaoMember');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$comfirmResult			= $request->getSession($sessionConfirmName);

		if( 'OK' != $comfirmResult ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( get_class($memberObject) != get_class($compareMemberObject) ){
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			// 変更者のIDを登録
			$memberObject->modifier_id	= $loginUserObject->getUniqueId();
			if( strlen(trim($memberObject->member_id)) > 0 ) {
				// 会員IDが設定済みなら更新
				$memberObject->updated_date	= date('Y-m-d H:i:s');
				if( $memberObject->canEditData( $request, $loginUserObject ) ) {
					if( $this->lockData( $request, $memberObject ) ) {
						// 編集ロックを再取得できたらポイントのみ更新して履歴はとらない
						$memberObject->point	+= $memberObject->action_point;
						if( $dbo->update($memberObject,false) ) {
							// ポイント履歴を入力
							$pointHistory	= spider_Controller::createObject('member_DaoMemberPointHistory');
							$pointHistory->member_id		= $memberObject->member_id;
							$pointHistory->action_point		= $memberObject->action_point;
							$pointHistory->action_label		= $memberObject->action_label;
							$pointHistory->action_detail	= $memberObject->action_detail;
							$pointHistory->modifier_id		= $loginUserObject->getUniqueId();
							$pointHistory->owner_id			= $loginUserObject->getUniqueId();
							if( $dbo->insert($pointHistory) ){
							} else {
								$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(""));
							}
						} else {
							$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(""));
						}
						$this->unlockData( $request, $memberObject );
					} else {
						$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				// 会員IDがないならエラー
				$request->addLocaledError('member.error.common.selectmember',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('member.member.point.memberObject',$memberObject);
		$request->setAttribute('member.member.point.registItems',$GLOBALS['MEMBER_REGIST_ITEM']);
		$request->setAttribute('member.member.point.requireItems',$GLOBALS['MEMBER_REQUIRE_ITEM']);
	}
}
?>