<?php
/*
 * member/mail/DeliveryStatus.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール 配信実行用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_DeliveryStatus extends system_login_ModuleBase {
	function member_mail_DeliveryStatus(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		// 実行PIDファイルの状態を確認
		// 0=実行されていない, 1=実行中, 201=原因不明で停止している
		$delivery_running	= 0;
		if( file_exists(MEMBER_MAIL_FILE_PATH_DELIVERY_RUNNING_PID) ) {
			if( time() - filemtime(MEMBER_MAIL_FILE_PATH_DELIVERY_RUNNING_PID) > 60 * 60 ) {
				// 最後の配信実行実行から1時間以上経過している場合
				$delivery_running	= 201;
			} else {
				// 1時間以内に配信ループが実行されている
				$delivery_running	= 1;
			}
		} else {
			// 実行されていない
			$delivery_running	= 0;
		}
		
//		// 実行されていないならバックグラウンド処理呼び出し
//		$process_file	= MEMBER_MAIL_FILE_PATH_DELIVERY_RUNNING_PID;
//		if( !file_exists($process_file) || time() - filemtime($process_file) > 60 * 5 ) {
//			// 実行指令ファイルが作成されていないなら作成して実行
//			if( @touch($process_file) ) {
//				@chmod($process_file,0666);
//				if( defined('MEMBER_MAIL_EXECUTE_PHP_COMMAND_PATH')
//					&& strlen(trim(MEMBER_MAIL_EXECUTE_PHP_COMMAND_PATH)) > 0
//					&& file_exists(MEMBER_MAIL_EXECUTE_PHP_COMMAND_PATH)
//					) {
//					// 配信に利用するphpコマンドパスが指定されている
//					if( preg_match('/[wW][iI][nN][dD][oO][wW][sS]/',php_uname()) > 0 ) {
//						// Windowsの場合はatコマンドで一分後に一回タスクを実行するようにする
//						$cmd	= 'runas /user:'.MEMBER_MAIL_EXECUTE_PHP_COMMAND_USER_ACCOUNT
//							.' "at '.date('H:i',strtotime('+ 2 minutes') ) .' '
//							.trim(MEMBER_MAIL_EXECUTE_PHP_COMMAND_PATH)
//							.' '.dirname(__FILE__).DIRECTORY_SEPARATOR.'send.cmd.php"'
//						;
//						$pp		= @popen($cmd,'r+');
//						if($pp) {
//							echo fgets($pp);
//							fwrite($pp,MEMBER_MAIL_EXECUTE_PHP_COMMAND_USER_PASSWORD);
//							pclose($pp);
//						} else {
//							$request->addError('バックグラウンドコマンド実行失敗');
//						}
//					} else {
//						 Unix/Linux バックグラウンド処理
//						$cmd	= trim(MEMBER_MAIL_EXECUTE_PHP_COMMAND_PATH)
//							.' '.__FILE__
//							.' > /dev/null &';
//						$res	= shell_exec($cmd);
//					}
//				} else {
//					 phpコマンドパスが指定されていないか見つからない
//					$request->addError('PHPコマンドのパスが指定されていません。システム設置者に問い合わせてください。');
//				}
//			} else {
//				$request->addError('プロセスファイルの作成に失敗しました。');
//			}
//			if( $request->isError() ) {
//				if( file_exists($process_file) ) {
//					@unlink($process_file);
//				}
//			}
//			
//		}
		$request->setAttribute('member.mail.delivery_running', $delivery_running );

	}
}
?>