<?php
/*
 * member/DaoMemberLoginHistory.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname( __FILE__ )
.DIRECTORY_SEPARATOR.'package_define.inc.php');
require_once( dirname( __FILE__ )
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'AbstractData.class.php');
/**
 * 会員ログイン履歴テーブルレコード対応 DAOクラス
 * 
 * @package member 会員管理パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_DaoMemberLoginHistory extends database2_AbstractData {
	/** ログイン履歴番号シリアル	*/
	var $history_number;
	/** 会員ID	*/
	var $member_id;
	/** ログイン日時	*/
	var $login_date;
	/** リモートアドレス	*/
	var $remote_address;
	/** リモートホスト	*/
	var $remote_host;
	/** ユーザーエージェント	*/
	var $user_agent;
	/** ログイン動作結果：0=成功, 201=パスワード間違い	*/
	var $login_result = 0;
	/**
	 * コンストラクタ
	 */
	function member_DaoMemberLoginHistory(){
		$this->remote_address	= $_SERVER['REMOTE_ADDR'];
		$this->remote_host		= $_SERVER['REMOTE_HOST'];
		$this->user_agent		= $_SERVER['HTTP_USER_AGENT'];
		$this->login_date		= date('Y-m-d H:i:s');
	}
	/**
	 * 履歴を削除する
	 */
	function deleteHistory( $dbo, $days ) {
		if( !is_numeric($days) || $days < 1 || $days > 1000 ) {
			$days = 90;
		}
		$sql	= 'DELETE FROM '.$this->table_name
			.' WHERE TO_DAYS(NOW()) - TO_DAYS(login_date) > '.$days
		;
		$dbo->query($sql);
	}
}
?>