<?php
/*
 * design/template/Delete.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'util'
	.DIRECTORY_SEPARATOR.'CharUtility.class.php');
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'DaoTemplate.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'content'
	.DIRECTORY_SEPARATOR.'LoadFolders.class.php');
class design_template_Delete extends system_login_ModuleBase {
	function design_template_Delete() {
	}
	function execute( & $request ) {
		$templateFileName		= strtolower(trim(stripslashes($_POST['file_name'])));
		if( strlen(trim($templateFileName)) == 0 ) {
			$request->addError('テンプレートファイル名を指定してください');
		} else if( $templateFileName == 'default.fmt' ) {
			$request->addError('標準テンプレートは削除できません!');
		}
		// 利用チェック
		$useTemplateStrings	= '{template:'.$templateFileName.'}';
		$usePageUriArray	= array();
		$folderUriArray		= content_LoadFolders::digFolderChilds( SPIDER_BASE_PATH );
		foreach( $folderUriArray as $folderUri ) {
			$folderAbsolutePath	= util_File::suri2path( $folderUri );
			if ($dh = opendir($folderAbsolutePath)) {
				while (($fileName	= readdir($dh)) !== false) {
					if( preg_match('/^\\./',$fileName) == 0 ) {
						$absolutePath	= $folderAbsolutePath.DIRECTORY_SEPARATOR.$fileName;
						$uri			= util_File::path2suri($absolutePath);
						if( file_exists( $absolutePath ) ) {
							if( preg_match('/\\.[pP][hH][pP]$/',$fileName) > 0  ) {
								// phpファイルの場合のみ
								$strings	= file_get_contents($absolutePath);
								if( preg_match('/'.util_CharUtility::escapeRegxStr($useTemplateStrings).'/',$strings) > 0 ) {
									array_push($usePageUriArray,$uri);
								}
							}
						}
					}
				}
				closedir($dh);
			}
		}
		if( count($usePageUriArray) > 0 ) {
			$message	= '次のページがこのテンプレートを利用している為削除できません'."\n";
			foreach( $usePageUriArray as $uri ) {
				$message	.= "\n".$uri;
			}
			$request->addError($message);
		}
		if( !$request->isError() ) {
			$templateObject	= new design_DaoTemplate($templateFileName);
			$templateObject->deleteAll( $request );
			$request->setAttribute('design.template.templateObject',$templateObject );
		}
	}
}
?>