<?php
/*
 * database2/AbstractData.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'AbstractData.class.php');
/**
 * データアクセスオブジェクトの基底抽象クラス
 *
 * テーブルレコードに対応したデータアクセスオブジェクトクラスの基底クラスです。
 * 本クラスの拡張クラスとしてデータアクセスオブジェクトクラスを実装することで
 * 様々な機能を提供します。
 * 本オブジェクトの実装で扱うクラスは必ずひとつの自動番号フィールドと
 * ひとつ以上のユニークフィールドを保持する必要があります。
 * 
 * @package database2 データベースパッケージ
 * @version 2.0.0
 * @author <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class database2_AbstractData extends system_AbstractData {
	/** シリアル番号フィールド名	*/
	var $baseSerialFieldName		= null;
	/** ユニークキーフィールド名	*/
	var $baseUniqueKeyFiledNames	= null;
	/**
	 * 本オブジェクトが保持するデータのデータベーステーブル名を取得します。
	 * テーブル名は実装クラス名を_で区切った末尾文字列に対して大文字部分を_[小文字]に置き換えた文字列です。
	 * 例えばDaoAdminMemberならadmin_memberとなります。
	 */
	function getTableName() {
		if( preg_match('/^4/',phpversion()) > 0 || preg_match('/^3/',phpversion()) > 0 ) {
			// phpのバージョンが3か4の場合
			list( $packageName, $baseName )	= explode('_',get_class($this));
			$baseDir	= DIR_PATH_LIB.DIRECTORY_SEPARATOR.$packageName;
			// パッケージライブラリ直下のDaoファイルを検索
			if (is_dir($baseDir)) {
				if ($dh = opendir($baseDir)) {
					while (($fileName = readdir($dh)) !== false) {
						if( preg_match('/^Dao/',$fileName) > 0 ) {
							$fileClass	= str_replace('.class.php','',$fileName);
							if( strtolower($fileClass) == $baseName ) {
								// クラス名部分と一致したら該当ファイル
								$tableName	= preg_replace('/([A-Z])/','_${0}',$fileClass);
								$tableName	= preg_replace('/^(.)*Dao\\_/','',$tableName);
								break;
							}
						}
					}
					closedir($dh);
				}
			}
		} else {
			// phpが5以上の場合
			$elements	= explode('_',get_class($this));
			$baseName	= array_pop($elements);
			$tableName	= preg_replace('/([A-Z])/','_${0}',$baseName);
			$tableName	= preg_replace('/^(.)*Dao\\_/','',$tableName);
		}
		return strtolower($tableName);
	}
	/**
	 * インサート前に行いたい処理を記述する抽象メソッドです。
	 * @param MDBObject $dbo オブジェクト互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function pre_insert( $dbo ) {
		return true;
	}
	/**
	 * インサート後に行いたい処理を記述する抽象メソッドです。
	 * @param MDBObject $dbo オブジェクト互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function post_insert( $dbo, $result ) {
		return true;
	}
	/**
	 * アップデート前に行いたい処理を記述する抽象メソッドです。
	 * @param MDBObject $dbo オブジェクト互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function pre_update( $dbo ) {
		return true;
	}
	/**
	 * アップデート後に行いたい処理を記述する抽象メソッドです。
	 * @param MDBObject $dbo オブジェクト互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function post_update( $dbo, $result ) {
		return true;
	}
	/**
	 * デリート前に行いたい処理を記述する抽象メソッドです。
	 * @param MDBObject $dbo オブジェクト互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function pre_delete( $dbo ) {
		return true;
	}
	/**
	 * デリート後に行いたい処理を記述する抽象メソッドです。
	 * @param MDBObject $dbo オブジェクト互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function post_delete( $dbo, $result ) {
		return true;
	}
	/**
	 * ロードされた時の状態と差分があるか確認します
	 */
	function is_changed( $dbo ) {
		$this->error_messages	= array();
		$table_info_hash		= $dbo->getTableInformation( $this );
		$is_changed				= false;
		foreach( $table_info_hash as $fname => $info_hash ) {
			$fname_org		= $fname.'_org';
			if( trim($this->$fname) != trim($this->$fname_org) ) {
				$is_changed	= true;
				break;
			}
		}
		return $is_changed;
	}
	//
	// AbstractDataの実装
	//
	/**
	 * データ保存区分名を取得する抽象メソッド
	 */
	function getDataClassName(){
		return $this->getTableName();
	}
	/**
	 * データの保存区分名を設定する抽象メソッド
	 */
	function setDataClassName( $dataClassName ) {
		return true;
	}
	/**
	 * データ固有のIDを取得する抽象メソッド
	 */
	function getUniqueId(){
		$uniqueStrings	= '';
		if( is_array( $this->baseUniqueKeyFiledNames ) ) {
			foreach( $this->baseUniqueKeyFiledNames as $fieldName ) {
				$uniqueStrings	.= $this->$fieldName;
			}
			return $uniqueStrings;
		} else {
			return false;
		}
	}
	/**
	 * データ固有のIDを設定する抽象メソッド
	 */
	function setUniqueId( $uniqueId ) {
		return true;
	}
}
?>