<?php
/*
 * content/editor/Load.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
class content_editor_Load extends system_login_ModuleBase {
	function content_editor_Load() {
	}
	function execute( & $request ) {
		
		$targetType	= strtolower(trim(stripslashes($_GET['cttype'])));
		$fileUri	= strtolower(trim(stripslashes($_GET['cturi'])));
		$agentType	= strtolower(trim(stripslashes($_GET['ctagent'])));
		if( DIR_NAME_TEMPLATES != $targetType && DIR_NAME_PAGES != $targetType && DIR_NAME_WIDGETS != $targetType ) {
			$targetType	= 'public';
		}
		if( strlen($fileUri) < 1 ) {
			$request->addError('ファイルを指定してください');
		} else if( preg_match('/\\.[cC][sS][sS]$/',$fileUri) == 0
			&& preg_match('/\\.[jJ][sS]$/',$fileUri) == 0
			&& preg_match('/\\.[hH][tT][mM]([lL]|)$/',$fileUri) == 0
			&& preg_match('/\\.[tT][xX][tT]$/',$fileUri) == 0
			&& preg_match('/\\.[pP][hH][pP]$/',$fileUri) == 0
		) {
			$request->addError('指定のファイルはテキスト形式ではありません。');
		}
		if( !array_key_exists($agentType,$GLOBALS['SPIDER_USER_AGENT_CLASS_HASH']) ) {
			$agentType	= 'default';
		}
		
		if( !$request->isError() ) {
			$targetBody		= '';
			// エラーがないなら種別に合わせて本文取得
			if( 'public' == $targetType ) {
				// 公開フォルダ内ファイルなら
				$targetBody	= system_DataFileWriter::getContents( $request, $fileUri, 'public' );
			} else {
				// 公開フォルダ以外のファイルなら
				$targetBody	= system_DataFileWriter::getContents( $request, '/'.$agentType.$fileUri, $targetType );
			}
			$request->setAttribute('content.file.edit.targetUri',$fileUri );
			$request->setAttribute('content.file.edit.targetType',$targetType );
			$request->setAttribute('content.file.edit.agentType',$agentType );
			$request->setAttribute('content.file.edit.targetBody',$targetBody );
		}
		
	}
}
?>