<?php include_once( "../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:design.template.LoadList}
{module:topic.Form}
{preset:page_title '記事管理 > 記事登録・変更'}

	<div class="panc">
		<a href="../" title="管理パネルのトップページを表示します">管理パネルトップ</a>
		&gt; <a href="./" title="投稿済み記事の一覧を表示します">記事管理</a>
		&gt; 記事作成と編集
	</div>
	<h1>
		記事管理
		&gt; 記事作成と編集
	</h1>
	
{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<br />
{else}

	<form name="cform" action="./confirm.php?tid={write:topic.topicObject->'topicId'}" method="post">
	
	<div style="width:96%;margin:0 auto;padding:5px;border:dotted 1px #808080;background-color:#f0f0f0;">
		<div style="margin-bottom:10px;">
			<input type="text" name="subject" size="70" value="{write:topic.topicObject->'subject'}" style="width:98%;font-size:16px;padding:3px;" />
		</div>
		<div style="margin-bottom:10px;">
			<input type="text" name="description" size="100" value="{write:topic.topicObject->'description'}" style="width:98%;padding:3px;" />
		</div>
		<div style="margin-bottom:10px;">
			<div style="width:20%;float:right;background-color:#ffffff;">
				<div style="font-weight:bold;background-color:#008000;color:#ffffff;padding:3px;">アップロード画像</div>
				<select name="targetFolder" style="width:100%;" onchange="topicCreateGetImages()">
					<option value="/upload">フォルダ選択</option>
				</select>
				<input type="button" value="画像アップロード" style="width:100%;" onclick="contentFileViewUploadForm(document.cform.targetFolder.options[document.cform.targetFolder.selectedIndex].value,'',true,topicCreateGetImages)" />
				<div id="insert-image-panel"></div>
			</div>
			<div style="width:80%;float:left;"><textarea name="body" cols="70" rows="20">{write:topic.topicObject->'body'}</textarea></div>
			<br style="clear:both;" />
		</div>
		<div style="margin-bottom:10px;">
			<select name="topicDate_year">
			<?php for($GLOBALS['year']=date('Y');$GLOBALS['year']<date('Y')+3;$GLOBALS['year']++) { ?>
				<option value="{write:year}"
					{if:topic.topicObject->'topicDate_year'==year} selected{/if}
					>{write:year}</option>
			<?php } ?>
			</select>年<select name="topicDate_month">
			<?php for($GLOBALS['month']=1;$GLOBALS['month']<=12;$GLOBALS['month']++) { ?>
				<option value="{write:sprintf('%02d',month)}"
					{if:topic.topicObject->'topicDate_month'==month} selected{/if}
					>{write:sprintf('%02d',month)}</option>
			<?php } ?>
			</select>月<select name="topicDate_day" tabindex="150">
			<?php for($GLOBALS['day']=1;$GLOBALS['day']<=31;$GLOBALS['day']++) { ?>
				<option value="{write:sprintf('%02d',day)}"
					{if:topic.topicObject->'topicDate_day'==day} selected{/if}
					>{write:sprintf('%02d',day)}</option>
			<?php } ?>
			</select>日

			<select name="topicDate_hour">
			<?php for($GLOBALS['hour']=0;$GLOBALS['hour']<24;$GLOBALS['hour']++) { ?>
				<option value="{write:sprintf('%02d',hour)}"
					{if:topic.topicObject->'topicDate_hour'==hour} selected{/if}
					>{write:sprintf('%02d',hour)}</option>
			<?php } ?>
			</select>時<select name="topicDate_min">
			<?php for($GLOBALS['min']=0;$GLOBALS['min']<60;$GLOBALS['min']++) { ?>
				<option value="{write:sprintf('%02d',min)}"
					{if:topic.topicObject->'topicDate_min'==min} selected{/if}
					>{write:sprintf('%02d',min)}</option>
			<?php } ?>
			</select>分<select name="topicDate_sec">
			<?php for($GLOBALS['sec']=0;$GLOBALS['sec']<60;$GLOBALS['sec']++) { ?>
				<option value="{write:sprintf('%02d',sec)}"
					{if:topic.topicObject->'topicDate_sec'==sec} selected{/if}
					>{write:sprintf('%02d',sec)}</option>
			<?php } ?>
			</select>秒
		</div>
		<div style="margin-bottom:10px;">
			記事カテゴリ&nbsp;<input type="text" name="category" size="60" value="{write:topic.topicObject->'category'}"/><br />
			&nbsp;&nbsp;<span style="color:#f06030;font-size:x-small;">※カンマ区切りで複数入力できます。&nbsp;(例）&nbsp;ショッピング, ソフトウェア, カート</span>
		</div>
		<div style="margin-bottom:10px;">
			配信者名<span style="color:#f06030;font-size:x-small;">※</span>&nbsp;<input type="text" name="author" size="20" value="{if:strlen(topic.topicObject->'author')>0}{write:topic.topicObject->'author'}{else}<?php echo htmlspecialchars(TOPIC_RSS_SITE_EDITOR_NAME); ?>{/if}"/>
		</div>
		<div style="margin-bottom:10px;">
			<nobr><input type="checkbox" name="enableNl2Br" value="1"{if:topic.topicObject->'enableNl2Br'=='1'} checked{/if}> 改行を反映する</nobr
			>&nbsp;<nobr><input type="checkbox" name="enableHtml" value="1"{if:topic.topicObject->'enableHtml'=='1'} checked{/if}> HTML有効</nobr
			>
		</div>
	</div>
	
	<p style="text-align:center;">
		<input type="submit" value="{if:topic.topicObject->'topic_number'==''}作成{else}編集{/if}する"
		/><br />
	</p>
	</form>

<script language="JavaScript" type="text/javascript" src="/js/textformer/textformer.js"></script>  
<script language="JavaScript" type="text/javascript"><!--
var topicCreateTextformerObject;
if(window.attachEvent){
	window.attachEvent('onload',topicCreateMassageFormInitialize);
}else{
	window.addEventListener('DOMContentLoaded',topicCreateMassageFormInitialize,false);
}
function topicCreateMassageFormInitialize() {
	topicCreateTextformerObject	= TextFormer( document.cform.body, "topicCreateSaveBody()", "topicCreateEditClose()" );
//	var previewButton	= new TextFormer.ButtonCommon(
//		topicCreateTextformerObject,
//		'design-template-html-preview-button',
//		'../content/images/button/preview.gif',
//		'../content/images/button/preview_on.gif',
//		'topicCreatePreview()'
//	);
//	topicCreateTextformerObject.addButton(previewButton,'left');
	topicCreateTextformerObject.setSubject('記事本文');
	document.cform.subject.onfocus	= topicCreateConfirmSubjectFocus;
	document.cform.subject.onblur	= topicCreateConfirmSubjectBlur;
	document.cform.description.onfocus	= topicCreateConfirmDescriptionFocus;
	document.cform.description.onblur	= topicCreateConfirmDescriptionBlur;
	document.cform.description.focus();
	document.cform.subject.focus();
	document.cform.subject.blur();
	topicCreateGetImages();
	contentGetFolderList('/upload',topicCreateFolderOptions);
}
function topicCreateSaveBody() {
	document.cform.submit();
}
function topicCreateEditClose() {
	
}
function topicCreatePreview() {
	
}
function topicCreateConfirmSubjectFocus() {
	if( document.cform.subject.value == '<< タイトルをいれてください >>' ) {
		document.cform.subject.value	= '';
		document.cform.subject.style.color	= '#000000';
	}
}
function topicCreateConfirmSubjectBlur() {
	if( document.cform.subject.value.length == 0 ) {
		document.cform.subject.value		= '<< タイトルをいれてください >>';
		document.cform.subject.style.color	= '#a0a0a0';
	}
}
function topicCreateConfirmDescriptionFocus() {
	if( document.cform.description.value == '<< 記事の概要を入力してください >>' ) {
		document.cform.description.value	= '';
		document.cform.description.style.color	= '#000000';
	}
}
function topicCreateConfirmDescriptionBlur() {
	if( document.cform.description.value.length == 0 ) {
		document.cform.description.value		= '<< 記事の概要を入力してください >>';
		document.cform.description.style.color	= '#a0a0a0';
	}
}
function topicCreateGetImages() {
	var targetFolderUri	= document.cform.targetFolder.options[document.cform.targetFolder.selectedIndex].value;
	contentToImagePastePanel( document.getElementById('insert-image-panel'), targetFolderUri, topicCreateTextformerObject );
}
function topicCreateFolderOptions( folderObjectArray ) {
	var selectObject	= document.cform.targetFolder;
	for( var num=selectObject.length-1; num>=0; num-- ) {
		var optionObject	= document.cform.targetFolder.options[num];
		selectObject.removeChild(optionObject);
	}
	var optionObject	= new Option();
	optionObject.label	= 'フォルダ選択';
	optionObject.text	= 'フォルダ選択';
	optionObject.value	= '/upload';
	selectObject.appendChild(optionObject);
	for( var num=0; num<folderObjectArray.length; num++ ) {
		var folderInfo	= folderObjectArray[num];
		var uri			= folderInfo.parent + '/' + folderInfo.name;
		var extOption	= new Option();
		extOption.label	= folderInfo.name;
		extOption.text	= folderInfo.name;
		extOption.value	= uri;
		selectObject.appendChild(extOption);

	}
}
//--></script>
{/if}
	<div style="width:96%;margin:0 auto;text-align:right;margin-top:1em;">
		<hr style="" />
	</div>
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="./">&gt;&gt; 記事管理</a>
		&nbsp;
		<a href="../">&gt;&gt; 管理パネルトップ</a>
	</div>
