<?php include_once( "../../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.category.LoadList}
{module:shopping.flag.LoadList}
{module:shopping.product.unit.Form}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_PRODUCT . '管理 > 販売単位の追加・編集'}

	{set:shoppingProductObject shopping.product.unit.unit_object->'shoppingProductObject'}
	{set:searchDataObject shoppingProductObject->'searchDataObject'}
	<div class="panc">
		<a href="../../../">管理パネルトップ</a>
		{if:is_object(shoppingProductObject->'searchDataObject')}
		&gt; <a href="../../../search/data/detail.php?schdi={write:shoppingProductObject->'searchDataObject'->'data_id'}">{write:shoppingProductObject->'searchDataObject'->'subject'}</a>
		&gt; <a href="../?schdi={write:shoppingProductObject->'searchDataObject'->'data_id'}">{write:SHOPPING_LABEL_PRODUCT}一覧</a>
		{else}
		&gt; <a href="../../">ショップ管理</a>
		&gt; <a href="../">{write:SHOPPING_LABEL_PRODUCT}管理</a>
		{/if}
		&gt; <a href="../detail.php?shpdn={write:shoppingProductObject->'product_number'}">{write:shoppingProductObject->'product_name'}</a>
		{if:strlen(shopping.product.unit.unit_object->'unit_number')==0}
		&gt; 販売単位の新規作成
		{else}
		&gt; <a href="./detail.php?shpun={write:shopping.product.unit.unit_object->'unit_number'}">{write:shopping.product.unit.unit_object->'unit_name'}</a>
		&gt; 編集
		{/if}
	</div>

	<h1>
		{write:SHOPPING_LABEL_PRODUCT}管理 &gt; {write:shoppingProductObject->'product_name'}
		{if:strlen(shopping.product.unit.unit_object->'unit_number')==0}
		&gt; 販売単位の新規作成
		{else}
		&gt; {write:shopping.product.unit.unit_object->'unit_name'}
		&gt; 編集
		{/if}
	</h1>

{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<br />
{else}
	
	{if:shoppingProductObject->'status_flag'<100}
	<div style="width:96%;margin:0 auto;color:#ff0000;">
		この販売単位が属する{write:SHOPPING_LABEL_PRODUCT}は現在非公開です。公開するには{write:SHOPPING_LABEL_PRODUCT}の状態を「掲載中」に変更してください。
	</div>
	{/if}
	{if:shopping.product.unit.unit_object->'status_flag'<100}
	<div style="width:96%;margin:0 auto;color:#ff0000;">
		この販売単位は現在非公開です。公開するには販売単位の状態を「掲載中」に変更してください。
	</div>
	{/if}

	<form name="cform" action="./confirm.php?shpun={write:shopping.product.unit.unit_object->'unit_number'}" method="post" enctype="multipart/form-data">
	<input type="hidden" id="unit_number" name="unit_number" value="{write:shopping.product.unit.unit_object->'unit_number'}" />
	<input type="hidden" id="product_id" name="product_id" value="{write:shopping.product.unit.unit_object->'product_id'}" />
	<input type="hidden" id="require_unit_id" name="require_unit_id" value="{write:shopping.product.unit.unit_object->'require_unit_id'}" />
	<input type="hidden" name="delivery_type" value="{write:shopping.product.unit.unit_object->'delivery_type'}" />
	<input type="hidden" name="service_term" value="{write:shopping.product.unit.unit_object->'service_term'}" />
	<p style="text-align:center;">
		フォームに入力して{if:strlen(shopping.product.unit.unit_object->'unit_number')==0}作成{else}編集{/if}するボタンをクリックしてください。<br />
	</p>

	<h2 class="global">{write:SHOPPING_LABEL_PRODUCT}の基本情報</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}ID</th>
		<td>{write:shoppingProductObject->'product_id'}</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}の状態</th>
		<td>
			{write:SHOPPING_PRODUCT_STATUS_HASH[shoppingProductObject->'status_flag']}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}名</th>
		<td>{write:shoppingProductObject->'product_name'}</td>
	</tr>
	</tbody>
	</table>
	<br />

	<h2 class="global">販売単位の基本情報</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">販売単位ID</th>
		<td>
			<input type="text" name="unit_id" size="20" value="{write:shopping.product.unit.unit_object->'unit_id'}" />
			<br />
			<span class="form_attention">※半角英数字16文字以内で入力してください。入力しない場合自動で割り当てられます。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">販売単位名<span class="required">※</span></th>
		<td>
			<input type="text" name="unit_name" size="30" value="{write:shopping.product.unit.unit_object->'unit_name'}" />
			<br />
			<span class="form_attention">※60文字以内で入力してください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">販売単位名フリガナ</th>
		<td>
			<input type="text" name="unit_kana" size="30" value="{write:shopping.product.unit.unit_object->'unit_kana'}" />
			<br />
			<span class="form_attention">※並び順にのみ利用されます。60文字以内で入力してください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">Web用在庫数<span class="required">※</span></th>
		<td>
			<input type="radio" name="stock_type" id="stock_type_p1" value="1"{if:shopping.product.unit.unit_object->'stock'>=0} checked{/if}
				onclick="shoppingProductUnitChangeStockType(this)"
			/><label for="stock_type_p1" style="cursor:pointer;">数入力</label>
			<input type="radio" name="stock_type" id="stock_type_m1" value="-1"{if:shopping.product.unit.unit_object->'stock'==-1} checked{/if}
				onclick="shoppingProductUnitChangeStockType(this)"
			/><label for="stock_type_m1" style="cursor:pointer;">無制限</label>
			<input type="radio" name="stock_type" id="stock_type_m2" value="-2"{if:shopping.product.unit.unit_object->'stock'==-2} checked{/if}
				onclick="shoppingProductUnitChangeStockType(this)"
			/><label for="stock_type_m2" style="cursor:pointer;">在庫連動(最少)</label>
			<input type="radio" name="stock_type" id="stock_type_m3" value="-3"{if:shopping.product.unit.unit_object->'stock'==-3} checked{/if}
				onclick="shoppingProductUnitChangeStockType(this)"
			/><label for="stock_type_m3" style="cursor:pointer;">在庫連動(最多)</label>
			<input type="radio" name="stock_type" id="stock_type_m4" value="-4"{if:shopping.product.unit.unit_object->'stock'==-4} checked{/if}
				onclick="shoppingProductUnitChangeStockType(this)"
			/><label for="stock_type_m4" style="cursor:pointer;">在庫連動(合計)</label>
			<div id="stock_input_num"{if:shopping.product.unit.unit_object->'stock'<0} style="display:none;visibility:hidden;position:absolute;z-index:-999;"{/if}>
				<input type="text" name="stock" size="5" value="{write:shopping.product.unit.unit_object->'stock'}" /><br />
				<span class="form_attention">※半角数字のみ8ケタ以下で入力してください。</span>
			</div>
			<div id="stock_input_relation"{if:shopping.product.unit.unit_object->'stock'>=0} style="display:none;visibility:hidden;position:absolute;z-index:-999;"{/if}>
				<input type="text" name="stock_relation" size="90" value="{write:shopping.product.unit.unit_object->'stock_relation'}" /><br />
				<span class="form_attention">※在庫を連動させる{write:SHOPPING_LABEL_PRODUCT}販売単位IDを入力してください。/(半角スラッシュ)で区切って複数と連動できます。</span><br />
				在庫共有減算数:<input type="text" size="2" name="stock_relation_count" value="{write:shopping.product.unit.unit_object->'stock_relation_count'}"
				/>個
			</div>
<script type="text/javascript"><!--
function shoppingProductUnitChangeStockType(radioObject){
	document.cform.stock.value = radioObject.value;
	var inputNumPanel = document.getElementById('stock_input_num');
	var inputRelation = document.getElementById('stock_input_relation');
	if( document.cform.stock.value == '-1' ) {
		inputNumPanel.style.display = 'none';
		inputNumPanel.style.visibility = 'hidden';
		inputNumPanel.style.position   = 'absolute';
		inputNumPanel.style.zIndex     = '-99';
		inputRelation.style.display = 'none';
		inputRelation.style.visibility = 'hidden';
		inputRelation.style.position   = 'absolute';
		inputRelation.style.zIndex     = '-99';
	} else if( parseInt(document.cform.stock.value) < 0 ) {
		inputNumPanel.style.display = 'none';
		inputNumPanel.style.visibility = 'hidden';
		inputNumPanel.style.position   = 'absolute';
		inputNumPanel.style.zIndex     = '-99';
		inputRelation.style.display = 'block';
		inputRelation.style.visibility = 'visible';
		inputRelation.style.position   = 'static';
		inputRelation.style.zIndex     = '99';
	} else {
		inputNumPanel.style.display = 'block';
		inputNumPanel.style.visibility = 'visible';
		inputNumPanel.style.position   = 'static';
		inputNumPanel.style.zIndex     = '99';
		inputRelation.style.display = 'none';
		inputRelation.style.visibility = 'hidden';
		inputRelation.style.position   = 'absolute';
		inputRelation.style.zIndex     = '-99';
	}
}
//--></script>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">実在庫数<span class="required">※</span></th>
		<td>
			<input type="radio" name="stockd_type" id="stockd_type_p" value=""{if:strlen(shopping.product.unit.unit_object->'stock_display')==0} checked{/if}
				onclick="shoppingProductUnitChangeStockdType(this)"
			/><label for="stockd_type_p" style="cursor:pointer;">Web在庫と同じ</label>
			<input type="radio" name="stockd_type" id="stockd_type_p1" value="1"{if:strlen(shopping.product.unit.unit_object->'stock_display')>0 && shopping.product.unit.unit_object->'stock_display'>=0} checked{/if}
				onclick="shoppingProductUnitChangeStockdType(this)"
			/><label for="stockd_type_p1" style="cursor:pointer;">数入力</label>
			<input type="radio" name="stockd_type" id="stockd_type_m1" value="-1"{if:strlen(shopping.product.unit.unit_object->'stock_display')>0 && shopping.product.unit.unit_object->'stock_display'==-1} checked{/if}
				onclick="shoppingProductUnitChangeStockdType(this)"
			/><label for="stockd_type_m1" style="cursor:pointer;">無制限</label>
			<div id="stockd_input_num"{if:strlen(shopping.product.unit.unit_object->'stock_display')==0 || shopping.product.unit.unit_object->'stock_display'<0} style="display:none;visibility:hidden;position:absolute;z-index:-999;"{/if}>
				<input type="text" name="stock_display" size="5" value="{write:shopping.product.unit.unit_object->'stock_display'}" /><br />
				<span class="form_attention">※半角数字のみ8ケタ以下で入力してください。</span>
			</div>
			<div id="stockd_input_relation"{if:strlen(shopping.product.unit.unit_object->'stock_display')==0 || shopping.product.unit.unit_object->'stock_display'>=0} style="display:none;visibility:hidden;position:absolute;z-index:-999;"{/if}>
				<input type="text" name="stock_display_relation" size="90" value="{write:shopping.product.unit.unit_object->'stock_display_relation'}" /><br />
				<span class="form_attention">※在庫を連動させる{write:SHOPPING_LABEL_PRODUCT}販売単位IDを入力してください。/(半角スラッシュ)で区切って複数と連動できます。</span>
			</div>
<script type="text/javascript"><!--
function shoppingProductUnitChangeStockdType(radioObject){
	document.cform.stock_display.value = radioObject.value;
	var inputNumPanel = document.getElementById('stockd_input_num');
	var inputRelation = document.getElementById('stockd_input_relation');
	if( document.cform.stock_display.value == '-1' ) {
		inputNumPanel.style.display = 'none';
		inputNumPanel.style.visibility = 'hidden';
		inputNumPanel.style.position   = 'absolute';
		inputNumPanel.style.zIndex     = '-99';
		inputRelation.style.display = 'none';
		inputRelation.style.visibility = 'hidden';
		inputRelation.style.position   = 'absolute';
		inputRelation.style.zIndex     = '-99';
	} else if( parseInt(document.cform.stock_display.value) < 0 ) {
		inputNumPanel.style.display = 'none';
		inputNumPanel.style.visibility = 'hidden';
		inputNumPanel.style.position   = 'absolute';
		inputNumPanel.style.zIndex     = '-99';
		inputRelation.style.display = 'block';
		inputRelation.style.visibility = 'visible';
		inputRelation.style.position   = 'static';
		inputRelation.style.zIndex     = '99';
	} else if( document.cform.stock_display.value == '' ) {
		inputNumPanel.style.display = 'none';
		inputNumPanel.style.visibility = 'hidden';
		inputNumPanel.style.position   = 'absolute';
		inputNumPanel.style.zIndex     = '-99';
		inputRelation.style.display = 'none';
		inputRelation.style.visibility = 'hidden';
		inputRelation.style.position   = 'absolute';
		inputRelation.style.zIndex     = '-99';
	} else {
		inputNumPanel.style.display = 'block';
		inputNumPanel.style.visibility = 'visible';
		inputNumPanel.style.position   = 'static';
		inputNumPanel.style.zIndex     = '99';
		inputRelation.style.display = 'none';
		inputRelation.style.visibility = 'hidden';
		inputRelation.style.position   = 'absolute';
		inputRelation.style.zIndex     = '-99';
	}
}
//--></script>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">最大同時{write:SHOPPING_LABEL_ORDER}数</th>
		<td>
			<input type="text" name="max_at_once" size="5" value="{write:shopping.product.unit.unit_object->'max_at_once'}" />
			<br />
			<span class="form_attention">※一度にまとめてカートに入れられる最大数を設定できます。0未満や空の場合は制限なしになります。</span>
			<br />
			<span class="form_attention">※予約{write:SHOPPING_LABEL_PRODUCT}の場合は同時に申し込める最大枠数になります。例）宿泊予約で30に設定すると30日まで。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">公開販売期間</th>
		<td>
			<input type="text" size="20" name="open_date" value="{write:shopping.product.unit.unit_object->'open_date'}" />
			から
			<input type="text" size="20" name="close_date" value="{write:shopping.product.unit.unit_object->'close_date'}" />
			まで<br />
			<span class="form_attention">※2010-01-01 00:00:00の書式、半角英数字で入力してください。販売期間を制限しない場合は入力しないでください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}フラグ</th>
		<td>
			<table style="width:100%;">
			<tbdy>
			<tr>
				<th style="border-style:none;">{write:SHOPPING_LABEL_PRODUCT}フラグ種別</th>
				<th style="border-style:none;">表示順序</th>
				<th style="border-style:none;">公開日</th>
			</tr>
			{foreach:shopping.flag.flag_object_array num flagObject}
			<tr>
				{set:flagObjectHash shopping.product.unit.unit_object::flagObjectHash}
				<td style="border-style:none;vertical-align:top;">
					<span style="white-space:nowrap;"> <input type="checkbox" name="flag_id[]" value="{write:flagObject->'flag_id'}"
						{if:array_key_exists(flagObject->'flag_id',flagObjectHash)} checked{/if}
						/>{write:flagObject->'flag_name'}</span>
					<input type="hidden" name="flag_name[{write:flagObject->'flag_id'}]" value="{write:flagObject->'flag_name'}">
				</td>
				<td style="border-style:none;vertical-align:top;">
					<input type="text" name="flag_order_number[{write:flagObject->'flag_id'}]" size="3" value="{write:flagObjectHash[flagObject->'flag_id']['order_number']}" />
				</td>
				<td style="border-style:none;line-height:2em;vertical-align:top;">
					<span style="white-space:nowrap;"><select name="open_date_year[{write:flagObject->'flag_id'}]">
						<option value=""{if:strlen(open.year)==0} selected{/if}></option>
					<?php for( $i=date('Y'); $i<=date('Y')+1; $i++ ) { $request->setAttribute('open.year',$i); ?>
						<option value="{write:open.year}"{if:open.year==flagObjectHash[flagObject->'flag_id']['open_date_year']} selected{/if}>{write:open.year}</option>
					<?php } ?>
					</select>年<select name="open_date_month[{write:flagObject->'flag_id'}]">
						<option value=""{if:strlen(open.month)==0} selected{/if}></option>
					<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('open.month',$i); ?>
						<option value="{write:open.month}"{if:open.month==flagObjectHash[flagObject->'flag_id']['open_date_month']} selected{/if}>{write:open.month}</option>
					<?php } ?>
					</select>月<select name="open_date_day[{write:flagObject->'flag_id'}]">
						<option value=""{if:strlen(open.day)==0} selected{/if}></option>
					<?php for( $i=1; $i<=31; $i++ ) { $request->setAttribute('open.day',$i); ?>
						<option value="{write:open.day}"{if:open.day==flagObjectHash[flagObject->'flag_id']['open_date_day']} selected{/if}>{write:open.day}</option>
					<?php } ?>
					</select>日
					&nbsp;～
					<select name="close_date_year[{write:flagObject->'flag_id'}]">
						<option value=""{if:strlen(close.year)==0} selected{/if}></option>
					<?php for( $i=date('Y'); $i<=date('Y')+1; $i++ ) { $request->setAttribute('close.year',$i); ?>
						<option value="{write:close.year}"{if:close.year==flagObjectHash[flagObject->'flag_id']['close_date_year']} selected{/if}>{write:close.year}</option>
					<?php } ?>
					</select>年<select name="close_date_month[{write:flagObject->'flag_id'}]">
						<option value=""{if:strlen(close.month)==0} selected{/if}></option>
					<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('close.month',$i); ?>
						<option value="{write:close.month}"{if:close.month==flagObjectHash[flagObject->'flag_id']['close_date_month']} selected{/if}>{write:close.month}</option>
					<?php } ?>
					</select>月<select name="close_date_day[{write:flagObject->'flag_id'}]">
						<option value=""{if:strlen(close.day)==0} selected{/if}></option>
					<?php for( $i=1; $i<=31; $i++ ) { $request->setAttribute('close.day',$i); ?>
						<option value="{write:close.day}"{if:close.day==flagObjectHash[flagObject->'flag_id']['close_date_day']} selected{/if}>{write:close.day}</option>
					<?php } ?>
					</select>日</span>
				</td>
			</tr>
			{/foreach}
			</tbody>
			</table>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">付与ポイント数</th>
		<td>
			<input type="text" name="present_point" size="5" value="{write:shopping.product.unit.unit_object->'present_point'}" />Pt.
			<br />
			<span class="form_attention">※半角数字で入力してください。ポイント付与は会員ログインでの{write:SHOPPING_LABEL_ORDER}の場合だけです。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">標準価格(税込)<span class="required">※</span></th>
		<td>
			<input type="text" name="price_standard" size="10" value="{write:shopping.product.unit.unit_object->'price_standard'}" />円
			<br />
			<span class="form_attention">※半角数字のみ8ケタ以下でメーカー希望小売価格などを入力してください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">販売価格(税込)<span class="required">※</span></th>
		<td>
			<input type="text" name="price_sell" size="10" value="{write:shopping.product.unit.unit_object->'price_sell'}" />円
			<br />
			<span class="form_attention">※半角数字のみ8ケタ以下で入力してください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">仕入れ値(税込)<span class="required">※</span></th>
		<td>
			<input type="text" name="cost" size="10" value="{write:shopping.product.unit.unit_object->'cost'}" />円
			<br />
			<span class="form_attention">※半角数字のみ8ケタ以下で入力してください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">順序番号<span class="required">※</span></th>
		<td>
			<input type="text" name="order_number" size="3" value="{write:shopping.product.unit.unit_object->'order_number'}" />
			<br />
			<span class="form_attention">※半角数字のみ8ケタ以下で入力してください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">プロモ割引</th>
		<td>
			<input type="radio" name="discount_exception" value="0"{if:shopping.product.unit.unit_object->'discount_exception'!=1} checked{/if} />通常
			<input type="radio" name="discount_exception" value="1"{if:shopping.product.unit.unit_object->'discount_exception'==1} checked{/if} />割引しない
		</td>
	</tr>

	<tr>
		<th style="width:12em;">紹介文</th>
		<td>
			<textarea name="description" cols="50" rows="5">{write:shopping.product.unit.unit_object->'description'}</textarea><br />
			<span class="form_attention">※全角1,000文字まで</span>
		</td>
	</tr>
	</tbody>
	</table><br />

	<div id="shopping-product-delivery">
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">梱包目安値<span class="required">※</span></th>
		<td>
			<input type="text" name="delivery_weight" size="10" value="{write:shopping.product.unit.unit_object->'delivery_weight'}" />
			<br />
			<span class="form_attention">
				※半角数字のみ7ケタ以下入力してください。<br />
				お客様{write:SHOPPING_LABEL_ORDER}の際に{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}のこの数字の合計で配送量サイズ設定が決定します。
			</span>
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	</div>
	
	<div id="shopping-product-monthly">
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">月次課金価格(税込)<span class="required">※</span></th>
		<td>
			<input type="text" name="price_monthly" size="10" value="{write:shopping.product.unit.unit_object->'price_monthly'}" />円
			<br />
			<span class="form_attention">※半角数字のみ8ケタ以下で入力してください。</span>
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	</div>

	<div id="shopping-product-reserve">
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;white-space:nowrap;">カレンダー種別</th>
		<td>
			<select name="calendar_type">
				<option value="0">全体カレンダー利用</option>
				<option value="1"{if:'1'==shopping.product.unit.unit_object->'calendar_type'} selected{/if}>個別カレンダー利用</option>
				<option value="2"{if:'2'==shopping.product.unit.unit_object->'calendar_type'} selected{/if}>プロダクトカレンダー利用</option>
			</select>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">予約制限</th>
		<td>
			<input type="text" size="5" name="rsv_permit_start" value="{write:shopping.product.unit.unit_object->'rsv_permit_start'}"
			/>営業日後から<input type="text" size="5" name="rsv_permit_limit" value="{write:shopping.product.unit.unit_object->'rsv_permit_limit'}"
			/>日後まで予約可能<br />
			<span class="form_attention">※半角数字で入力してください。制限しない場合は入力の必要はありません。</span><br />
		</td>
	</tr>
	</tbody>
	</table>
	<br />

	<div id="shopping-product-reserve-stay">
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">チェックイン時間</th>
		<td>
			<select name="default_start_time" onchange="chengeServiceTerm()">
				<?php for( $hour=1; $hour<24; $hour++ ) { $GLOBALS['thour'] = sprintf('%02d',$hour).':00'; ?>
				<option value="{write:thour}"
					{if:shopping.product.unit.unit_object->'default_start_time'==thour . ':00'} selected{/if}
				>{write:thour}</option>
				<?php } ?>
			</select>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">チェックアウト時間</th>
		<td>
			{set:checkoutTime substr(shopping.product.unit.unit_object->'default_start_time',strpos(':',shopping.product.unit.unit_object->'default_start_time')) + (shopping.product.unit.unit_object->'service_term'/(60*60)) - 24}
			<select name="checkout_time" onchange="chengeServiceTerm()">
				<option value=""></option>
				<?php for( $hour=0; $hour<24; $hour++ ) { $GLOBALS['thour'] = sprintf('%02d',$hour).':00'; ?>
				<option value="<?php echo $hour; ?>"
					<?php if($GLOBALS['checkoutTime']==$hour){ ?> selected<?php } ?>
				>{write:thour}</option>
				<?php } ?>
			</select>
<script type="text/javascript"><!--
function chengeServiceTerm(){
	var checkInSelect = document.cform.default_start_time;
	var checkOutSelect = document.cform.checkout_time;
	if( checkOutSelect.options[checkOutSelect.selectedIndex].value.length > 0 ) {
		var sHS = checkInSelect.options[checkInSelect.selectedIndex].value;
		var sH = sHS.substring(0,sHS.indexOf(':'));
		var eH = checkOutSelect.options[checkOutSelect.selectedIndex].value;
		var th = 24 - parseInt(sH) + parseInt(eH);
		document.cform.service_term.value = new String(th*60*60);
	} else {
		document.cform.service_term.value = new String(16*60*60);
	}
}
//--></script>
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	</div>

	<div id="shopping-product-reserve-hour">
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">サービス提供時間</th>
		<td>
			<input type="text" size="5" name="service_term_text" value="{if:(shopping.product.unit.unit_object->'service_term' % (60*60))==0}{write:(shopping.product.unit.unit_object->'service_term' / (60*60))}{else-if:(shopping.product.unit.unit_object->'service_term' % (60))==0}{write:(shopping.product.unit.unit_object->'service_term' / (60))}{else}{write:(shopping.product.unit.unit_object->'service_term')}{/if}"
			onblur="chengeServiceTerm()"
			/><select name="service_term_select" onchange="chengeServiceTerm()">
				<option value="min">分</option>
				<option value="hour"{if:(shopping.product.unit.unit_object->'service_term' % (60*60))==0} selected{/if}>時間</option>
			</select>
<script type="text/javascript"><!--
function chengeServiceTerm(){
	var termSelectObj	= document.cform.service_term_select;
	var termText 		= document.cform.service_term_text.value;
	if( termSelectObj.options[termSelectObj.selectedIndex].value.length > 0 ) {
		var sHS = termSelectObj.options[termSelectObj.selectedIndex].value;
		if( 'hour' == sHS ) {
			document.cform.service_term.value	= 60*60*parseInt(termText);
		} else {
			document.cform.service_term.value	= 60*parseInt(termText);
		}
	} else {
		document.cform.service_term.value = new String(1*60*60);
	}
}
//--></script>
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	</div>
	</div>
	
	<h2 class="global">{write:SHOPPING_LABEL_PRODUCT}販売単位の画像</h2>
	{set:fileIdArray shopping.product.unit.unit_object->'fileIdArray_org'}
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<?php for( $GLOBALS['num']=0; $GLOBALS['num']<3; $GLOBALS['num']++ ) { ?>
	<tr>
		<th style="width:12em;">画像{write:(num+1)}</th>
		<td>
			{if:isset(fileIdArray[num])}
				<input type="checkbox" name="delete_fileIdArray[]" value="{write:fileIdArray[num]}"
					onclick="if(this.checked){document.getElementById('unitfiles_{write:number}').disabled='disabled';}else{document.getElementById('unitfiles_{write:number}').disabled='';}"
					/> 削除<br />
				<img src="/file/download.php?fi={write:fileIdArray[num]}&amp;w=180&amp;h=180" /><br />
			{/if}
			<input type="file" id="unitfiles_{write:number}" name="unitfiles[]" size="60" value="" /><br />
		</td>
	</tr>
	<?php } ?>
	</tbody>
	</table>
	
	<!-- {write:SHOPPING_LABEL_PRODUCT}ダウンロードファイル	-->
	<div id="shopping-product-download-files"{if:'11'==shopping.product.unit.unit_object->'delivery_type'}{else} style="position:absolute;z-index:-999;top:0px;left:0px;display:none;visibility:hidden;"{/if}>
	<h2 class="global">ダウンロード用ファイル</h2>
	<?php for( $GLOBALS['num']=100; $GLOBALS['num']<103; $GLOBALS['num']++ ) { ?>
	{set:fileBinObject shopping.product.unit.fileObjectOrgHash[num]}
<script language="JavaScript" type="text/javascript"><!--
function shoppingProductDetailViewDownloadFileEdit{write:num}(linkElm) {
	var editPanel	= document.getElementById('shopping-product-download-files-upload-{write:num}');
	if( editPanel ) {
		if( editPanel.style && editPanel.style.visibility == 'hidden' ) {
			editPanel.style.display	= 'block';
			editPanel.style.visibility	= 'visible';
			editPanel.style.position	= 'static';
			if( linkElm.firstChild && linkElm.firstChild.nodeValue ) {
				linkElm.prevText	= linkElm.firstChild.nodeValue;
				linkElm.firstChild.nodeValue	= '登録フォームを隠す';
			}
		} else {
			editPanel.style.display	= 'none';
			editPanel.style.visibility	= 'hidden';
			editPanel.style.position	= 'absolute';
			if( linkElm.firstChild && linkElm.firstChild.nodeValue ) {
				linkElm.firstChild.nodeValue	= linkElm.prevText;
			}
		}
	}
}
function shoppingProductDetailViewDownloadFileDetailEdit{write:num}(linkElm) {
	var editPanel	= document.getElementById('shopping-product-download-files-detail-{write:num}');
	if( editPanel ) {
		if( editPanel.style && editPanel.style.visibility == 'hidden' ) {
			editPanel.style.display	= 'block';
			editPanel.style.visibility	= 'visible';
			editPanel.style.position	= 'static';
			if( linkElm.firstChild && linkElm.firstChild.nodeValue ) {
				linkElm.prevText	= linkElm.firstChild.nodeValue;
				linkElm.firstChild.nodeValue	= '▲拡張情報登録を隠す';
			}
		} else {
			editPanel.style.display	= 'none';
			editPanel.style.visibility	= 'hidden';
			editPanel.style.position	= 'absolute';
			if( linkElm.firstChild && linkElm.firstChild.nodeValue ) {
				linkElm.firstChild.nodeValue	= linkElm.prevText;
			}
		}
	}
}
function shoppingProductDetailViewDownloadFilePanel{write:num}() {
	var upFile		= document.getElementById('shopping-product-download-files-form-{write:num}');
	var agentForm	= document.getElementById('shopping-product-download-files-agent-{write:num}');
	var editPanel	= document.getElementById('shopping-product-download-files-panel-{write:num+1}');
	if( editPanel && upFile ) {
		if( agentForm.value && agentForm.value.length > 0 && upFile.value && upFile.value.length > 0 ) {
			editPanel.style.display	= 'block';
			editPanel.style.visibility	= 'visible';
			editPanel.style.position	= 'static';
		} else {
			editPanel.style.display	= 'none';
			editPanel.style.visibility	= 'hidden';
			editPanel.style.position	= 'absolute';
		}
	}
}
//--></script>
	<div id="shopping-product-download-files-panel-{write:num}" style="width:95%;margin:0 auto;border-bottom:dotted 1px #808080;padding-top:0.5em;padding-bottom:0.5em;{if:num==100 || strlen(prevFileBinObject->'target_agent')>0}{else}display:none;visibility:hidden;position:absolute;{/if}">
		<div style="">
			<div style="font-weight:bold;font-size:14px;color:#008000;width:40%;float:left;">
				ダウンロード用ファイル{write:(num-99)} : {if:!is_null(fileBinObject)}{write:fileBinObject->'file_name'}{else}登録なし{/if}
			</div>
			<div style="width:40%;float:right;text-align:right;text-align:right;font-size:x-small;">
				{if:isset(fileIdArray[num]) && strlen(fileIdArray[num])>0}
					&nbsp;&nbsp;[<a href="/file/download.php?fi={write:fileIdArray[num]}&amp;dt=download" target="_blank"
					>ダウンロード確認</a>][<a href="javascript:" onclick="shoppingProductDetailViewDownloadFileEdit{write:num}(this)">変更</a>][<input type="checkbox" name="delete_fileIdArray[]" value="{write:fileIdArray[num]}" /> 削除]
				{else}
					[<a href="javascript:" onclick="shoppingProductDetailViewDownloadFileEdit{write:num}(this)">登録</a>]
				{/if}
			</div>
			<br style="clear:both;" />
		</div>
	
		<div id="shopping-product-download-files-upload-{write:num}" style="display:none;position:absolute;visibility:hidden;padding-top:0.5em;">
			<table class="detail" style="width:100%;margin-left:0px;margin-bottom:0px;">
			<tbody>
			<tr>
				<th style="width:12em;">{if:!is_null(fileBinObject)}差し換え{else}登録{/if}ファイル</th>
				<td>
					<input type="file" id="shopping-product-download-files-form-{write:num}" name="unitfiles[{write:num}]" size="60" value=""
						onclick="shoppingProductDetailViewDownloadFilePanel{write:num}()"
						onblur="shoppingProductDetailViewDownloadFilePanel{write:num}()"
						/><br />
				</td>
			</tr>
			</tbody>
			</table>
			<div style="text-align:right;font-size:x-small;">
				<a href="javascript:" onclick="shoppingProductDetailViewDownloadFileDetailEdit{write:num}(this)">▼拡張情報登録</a>
			</div>
		
			<div id="shopping-product-download-files-detail-{write:num}" style="display:none;position:absolute;visibility:hidden;">
			<table class="detail" style="width:100%;margin-left:0px;">
			<tbody>
			<tr>
				<th style="width:12em;">ダウンロード時ファイル名</th>
				<td>
					<input type="text" name="unitfiles_file_names[{write:num}]" size="60" value="{if:!is_null(fileBinObject)}{write:fileBinObject->'file_name'}{/if}" />
					<input type="hidden" name="unitfiles_open_flags[{write:num}]" value="11" />
				</td>
			</tr>
			<tr>
				<th style="width:12em;">Content-Type</th>
				<td>
					<input type="text" name="unitfiles_mime_types[{write:num}]" size="60" value="{if:!is_null(fileBinObject)}{write:fileBinObject->'mime_type'}{/if}" />
				</td>
			</tr>
			<tr>
				<th style="width:12em;">対象ユーザーエージェント<br />正規表現</th>
				<td>
					<textarea name="unitfiles_target_agents[{write:num}]" cols="50" rows="3"
						id="shopping-product-download-files-agent-{write:num}"
						onclick="shoppingProductDetailViewDownloadFilePanel{write:num}()"
						onblur="shoppingProductDetailViewDownloadFilePanel{write:num}()"
					>{if:!is_null(fileBinObject)}{write:fileBinObject->'target_agent'}{/if}</textarea>
				</td>
			</tr>
			<tr>
				<th style="width:12em;">追加レスポンスヘッダ</th>
				<td>
					<textarea name="unitfiles_response_headers[{write:num}]" cols="50" rows="3">{if:!is_null(fileBinObject)}{write:fileBinObject->'response_headers'}{/if}</textarea>
				</td>
			</tr>
			</tbody>
			</table>
			</div>
		</div>
	</div>
	{set:prevFileBinObject shopping.product.unit.fileObjectOrgHash[num]}
	<?php } ?>
	<br />
	</div>
	
	<!-- 詳細説明編集欄	-->
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a id="shopping-product-override-button" href="javascript:shoppingProductOverrideViewChange()"
			title="商品種別や閲覧・{write:SHOPPING_LABEL_ORDER}権限を{write:SHOPPING_LABEL_PRODUCT}の設定とは別に設定することができます"
		>▼{write:SHOPPING_LABEL_PRODUCT}情報の上書き設定を表示</a>
	</div>
	<div id="shopping-product-override"
		style="position:absolute;z-index:-999;top:0px;left:0px;display:none;visibility:hidden;">
	<h2>{write:SHOPPING_LABEL_PRODUCT}情報の上書き設定</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">商品種別</th>
		<td>
			<select name="delivery_type_select" onchange="shoppingProductDeliveryTypeChange(this)">
			{foreach:SHOPPING_DELIVERY_TYPE_HASH deliveryTypeKey deliveryTypeName}
				<option value="{write:deliveryTypeKey}"
				{if:deliveryTypeKey==shopping.product.unit.unit_object->'delivery_type'} selected{/if}
					>{write:deliveryTypeName}</option>
			{/foreach}
			</select>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">数え方</th>
		<td>
			<input type="text" name="unit_string" size="10" value="{write:shopping.product.unit.unit_object->'unit_string'}" />
		</td>
	</tr>
	<tr>
		<th style="width:12em;">閲覧許可</th>
		<td style="padding:0px;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<span style="white-space:nowrap;"><input type="checkbox" name="member_viewable[]" value="{write:key}"
			{if:in_array(key,shopping.product.unit.unit_object->'memberViewableArray')} checked{/if}
			/>{write:mb_substr(value,0,10)}</span>
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_ORDER}許可</th>
		<td style="padding:0px;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<span style="white-space:nowrap;"><input type="checkbox" name="member_purchasable[]" value="{write:key}"
			{if:in_array(key,shopping.product.unit.unit_object->'memberPurchasableArray')} checked{/if}
			/>{write:mb_substr(value,0,10)}</span>
			{/foreach}
		</td>
	</tr>
	</tbody>
	</table><br />
	</div>
	
	<!-- 詳細説明編集欄	-->
	<div style="width:96%;margin:0 auto;text-align:right;">
	{if:strlen(shopping.product.unit.unit_object->'detail_comment')>0}
		<a id="shopping-product-detail-button" href="javascript:shoppingProductDetailViewChange()"
			title="{write:SHOPPING_LABEL_PRODUCT}販売単位の詳しい追加説明文を登録できます"
		>▲追加説明(HTML可)設定を非表示</a>
	{else}
		<a id="shopping-product-detail-button" href="javascript:shoppingProductDetailViewChange()"
			title="{write:SHOPPING_LABEL_PRODUCT}販売単位の詳しい追加説明文を登録できます"
		>▼追加説明(HTML可)設定を表示</a>
	{/if}
	</div>
	<div id="shopping-product-detail"
		{if:strlen(shopping.product.unit.unit_object->'detail_comment')>0}
		{else}
		style="position:absolute;z-index:-999;top:0px;left:0px;display:none;visibility:hidden;"
		{/if} 
	>
	<h2 class="global">追加説明文(HTML可)</h2>
	<div style="width:96%;margin:0 auto;text-align:right;">
		※HTML可。全角換算5,000文字まで。
	</div>
	<div style="width:96%;margin:0 auto;">
		<textarea name="detail_comment" cols="60" rows="10"
		style="width:100%;"
		>{write:shopping.product.unit.unit_object->'detail_comment'}</textarea><br />
	</div>
	<br />
	</div>
	
	<div style="width:96%;margin:0 auto;text-align:right;">
	{if:strlen(shopping.product.unit.unit_object->'option1_name')>0 || strlen(shopping.product.unit.unit_object->'option2_name')>0 || strlen(shopping.product.unit.unit_object->'option3_name')>0 || strlen(shopping.product.unit.unit_object->'option4_name')>0 || strlen(shopping.product.unit.unit_object->'option5_name')>0}
		<a id="shopping-product-option-button" href="javascript:shoppingProductOptionViewChange()"
			title="{write:SHOPPING_LABEL_PRODUCT}と違う{write:SHOPPING_LABEL_ORDER}オプションを設定したい場合に変更してください"
		>▲固有{write:SHOPPING_LABEL_ORDER}オプション設定を非表示</a>
	{else}
		<a id="shopping-product-option-button" href="javascript:shoppingProductOptionViewChange()"
			title="{write:SHOPPING_LABEL_PRODUCT}と違う{write:SHOPPING_LABEL_ORDER}オプションを設定したい場合に変更してください"
		>▼固有{write:SHOPPING_LABEL_ORDER}オプション設定を表示</a>
	{/if}
	</div>
	<div id="shopping-product-option"
		{if:strlen(shopping.product.unit.unit_object->'option1_name')>0 || strlen(shopping.product.unit.unit_object->'option2_name')>0 || strlen(shopping.product.unit.unit_object->'option3_name')>0 || strlen(shopping.product.unit.unit_object->'option4_name')>0 || strlen(shopping.product.unit.unit_object->'option5_name')>0}
		{else}
		style="position:absolute;z-index:-999;top:0px;left:0px;display:none;visibility:hidden;"
		{/if} 
	>
	<h2 class="global">販売単位の固有の{write:SHOPPING_LABEL_ORDER}オプション</h2>
	
	<?php
		for( $GLOBALS['optionNumber']=1; $GLOBALS['optionNumber']<=5; $GLOBALS['optionNumber']++ ) {
			$GLOBALS['optionVarName']		= 'option'.$GLOBALS['optionNumber'].'_name';
			$GLOBALS['optionItemsName']	= 'option'.$GLOBALS['optionNumber'].'_items';
			$GLOBALS['optionUrlName']		= 'option'.$GLOBALS['optionNumber'].'_url';
			$GLOBALS['optionExpName']	= 'option'.$GLOBALS['optionNumber'].'_explanation';
			$GLOBALS['optionCalcName']		= 'option'.$GLOBALS['optionNumber'].'_calculate';
			$optionItemArray	= explode("\n",str_replace("\n\n","\n",str_replace("\r\n","\n",str_replace("\r","\n",trim($GLOBALS['shopping.product.unit.unit_object']->$GLOBALS['optionItemsName'])))));
			$GLOBALS['optionType']		= $optionItemArray[0];
			if( '__INPUT_TYPE_TEXT__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
			} else if( '__INPUT_TYPE_TEXTAREA__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
				$GLOBALS['optionRows']	= $optionItemArray[2];
			} else {
				$GLOBALS['optionType']	= '__SELECT__';
			}
	?>
<script language="JavaScript" type="text/javascript"><!--
function shoppingProductChangeOptionType{write:optionNumber}(radioObject) {
	var selectVal	= radioObject.value;
	var elmSelect	= document.getElementById('shopping-product-option{write:optionNumber}-setting-select');
	var elmText		= document.getElementById('shopping-product-option{write:optionNumber}-setting-text');
	var elmTextArea	= document.getElementById('shopping-product-option{write:optionNumber}-setting-textarea');
	if( 'text' == selectVal ) {
		elmSelect.style.display		= 'none';
		elmSelect.style.visibility		= 'hidden';
		elmSelect.style.position		= 'absolute';
		elmTextArea.style.display	= 'none';
		elmTextArea.style.visibility	= 'hidden';
		elmTextArea.style.position		= 'absolute';
		elmText.style.display		= 'block';
		elmText.style.visibility		= 'visible';
		elmText.style.position			= 'static';
	} else if( 'textarea' == selectVal ) {
		elmSelect.style.display		= 'none';
		elmSelect.style.visibility		= 'hidden';
		elmSelect.style.position		= 'absolute';
		elmTextArea.style.display	= 'block';
		elmTextArea.style.visibility	= 'visible';
		elmTextArea.style.position		= 'static';
		elmText.style.display		= 'none';
		elmText.style.visibility		= 'hidden';
		elmText.style.position			= 'absolute';
	} else {
		elmSelect.style.display		= 'block';
		elmSelect.style.visibility		= 'visible';
		elmSelect.style.position		= 'static';
		elmTextArea.style.display	= 'none';
		elmTextArea.style.visibility	= 'hidden';
		elmTextArea.style.position		= 'absolute';
		elmText.style.display		= 'none';
		elmText.style.visibility		= 'hidden';
		elmText.style.position			= 'absolute';
		document.cform.{write:optionItemsName}.value = '';
	}
	return true;
}
function shoppingProductOptionTypeText{write:optionNumber}(textObject) {
	document.cform.{write:optionItemsName}.value = '__INPUT_TYPE_TEXT__\n' + textObject.value;
}
function shoppingProductOptionTypeTextArea{write:optionNumber}(colText,rowText) {
	document.cform.{write:optionItemsName}.value = '__INPUT_TYPE_TEXTAREA__\n' + colText.value + '\n' + rowText.value;
}
//--></script>
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}項目名</th>
		<td>
			<input type="text" name="{write:optionVarName}" size="30" value="{write:shopping.product.unit.unit_object->optionVarName}" />
			<input type="radio" name="option_type{write:optionNumber}"  value="select" onclick="shoppingProductChangeOptionType{write:optionNumber}(this)"{if:optionType=='__SELECT__'} checked{/if} />セレクト
			<input type="radio" name="option_type{write:optionNumber}" value="text" onclick="shoppingProductChangeOptionType{write:optionNumber}(this)"{if:optionType=='__INPUT_TYPE_TEXT__'} checked{/if} />テキスト
			<input type="radio" name="option_type{write:optionNumber}" value="textarea" onclick="shoppingProductChangeOptionType{write:optionNumber}(this)"{if:optionType=='__INPUT_TYPE_TEXTAREA__'} checked{/if} />複数行テキスト
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}設定</th>
		<td>
			<div id="shopping-product-option{write:optionNumber}-setting-text" style="{if:optionType=='__INPUT_TYPE_TEXT__'}{else}display:none;visibility:hidden;position:absolute;{/if};">
				サイズ <input type="text" size="5" name="option{write:optionNumber}_text_width" value="{write:optionCols}" onblur="shoppingProductOptionTypeText{write:optionNumber}(this);" />
			</div>
			<div id="shopping-product-option{write:optionNumber}-setting-textarea" style="{if:optionType=='__INPUT_TYPE_TEXTAREA__'}{else}display:none;visibility:hidden;position:absolute;{/if};">
				幅 <input type="text" size="5" name="option{write:optionNumber}_textarea_cols" value="{write:optionCols}" onblur="shoppingProductOptionTypeTextArea{write:optionNumber}(this,document.cform.option{write:optionNumber}_textarea_rows);" />
				行数 <input type="text" size="5" name="option{write:optionNumber}_textarea_rows" value="{write:optionRows}" onblur="shoppingProductOptionTypeTextArea{write:optionNumber}(document.cform.option{write:optionNumber}_textarea_cols,this);" />
			</div>
			<div id="shopping-product-option{write:optionNumber}-setting-select" style="{if:optionType=='__SELECT__'}{else}display:none;visibility:hidden;position:absolute;{/if};">
				<textarea name="{write:optionItemsName}" cols="40" rows="5">{write:shopping.product.unit.unit_object->optionItemsName}</textarea><br />
				<span class="form_attention">選択ボックス：選択肢を改行区切りで入力してください。</span>
			</div>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}説明文</th>
		<td>
			<textarea name="{write:optionExpName}" cols="50" rows="2">{write:shopping.product.unit.unit_object->optionExpName}</textarea>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション金額計算方法</th>
		<td>
			<input type="radio" id="{write:optionCalcName}_0" name="{write:optionCalcName}" value="0"{if:'1'!=shopping.product.unit.unit_object->optionCalcName} checked{/if}
			/><label for="{write:optionCalcName}_0">注文数で乗算する</label>
			<input type="radio" id="{write:optionCalcName}_1" name="{write:optionCalcName}" value="1"{if:'1'==shopping.product.unit.unit_object->optionCalcName} checked{/if}
			/><label for="{write:optionCalcName}_1">注文数で乗算しない</label>
		</td>
	</tr>
	</tbody>
	</table><br />
	<?php } ?>
	
	</div>

	<p style="text-align:center;">
		<input type="submit" style="padding:10px;"
		value="入力内容の確認へ進む" />
	</p>
	<p style="text-align:center;">
	</p>
	</form>
	<br />
<script language="JavaScript" type="text/javascript" src="/js/textformer/textformer.js"></script>  
<script language="JavaScript" type="text/javascript"><!--
function shoppingProductOptionViewChange() {
	var optionButton	= document.getElementById('shopping-product-option-button');
	var optionPanel		= document.getElementById('shopping-product-option');
	if( optionPanel ) {
		if( optionPanel.style ) {
			if( optionPanel.style.visibility == 'hidden' ) {
				optionPanel.style.display	= 'block';
				optionPanel.style.visibility	= 'visible';
				optionPanel.style.position		= 'static';
				if( optionButton && optionButton.nodeName && optionButton.nodeName == 'input' ) {
					optionButton.value		= '▲{write:SHOPPING_LABEL_ORDER}オプション設定を非表示';
				} else {
					optionButton.innerHTML	= '▲{write:SHOPPING_LABEL_ORDER}オプション設定を非表示';
				}
			} else {
				optionPanel.style.display	= 'none';
				optionPanel.style.visibility	= 'hidden';
				optionPanel.style.position		= 'absolute';
				if( optionButton && optionButton.nodeName && optionButton.nodeName == 'input' ) {
					optionButton.value		= '▼{write:SHOPPING_LABEL_ORDER}オプション設定を表示';
				} else {
					optionButton.innerHTML	= '▼{write:SHOPPING_LABEL_ORDER}オプション設定を表示';
				}
			}
		}
	}
}
function shoppingProductDownloadFileViewChange( selectBox ) {
	var downloadFilePanel		= document.getElementById('shopping-product-download-files');
	if( downloadFilePanel && selectBox ) {
		var selectedIndex	= selectBox.selectedIndex;
		var selectVal		= selectBox.options[selectedIndex].value;
		if( downloadFilePanel.style ) {
			if( selectVal == '11' ) {
				downloadFilePanel.style.display	= 'block';
				downloadFilePanel.style.visibility	= 'visible';
				downloadFilePanel.style.position	= 'static';
			} else {
				downloadFilePanel.style.display	= 'none';
				downloadFilePanel.style.visibility	= 'hidden';
				downloadFilePanel.style.position	= 'absolute';
			}
		}
	}
}
function shoppingProductDetailViewChange() {
	var optionButton	= document.getElementById('shopping-product-detail-button');
	var optionPanel		= document.getElementById('shopping-product-detail');
	if( optionPanel ) {
		if( optionPanel.style ) {
			if( optionPanel.style.visibility == 'hidden' ) {
				optionPanel.style.display	= 'block';
				optionPanel.style.visibility	= 'visible';
				optionPanel.style.position		= 'static';
				if( optionButton && optionButton.nodeName && optionButton.nodeName == 'input' ) {
					optionButton.value		= '▲追加説明(HTML可)設定を非表示';
				} else {
					optionButton.innerHTML	= '▲追加説明(HTML可)設定を非表示';
				}
				if( shoppingProductTextFormerObject ){
				}else{
					shoppingProductDetailInit();
				}
			} else {
				shoppingProductTextFormerObject.remove();
				shoppingProductTextFormerObject	= null;
				optionPanel.style.display	= 'none';
				optionPanel.style.visibility	= 'hidden';
				optionPanel.style.position		= 'absolute';
				if( optionButton && optionButton.nodeName && optionButton.nodeName == 'input' ) {
					optionButton.value		= '▼追加説明(HTML可)設定を表示';
				} else {
					optionButton.innerHTML	= '▼追加説明(HTML可)設定を表示';
				}
			}
		}
	}
}
function shoppingProductOverrideViewChange() {
	var optionButton	= document.getElementById('shopping-product-override-button');
	var optionPanel		= document.getElementById('shopping-product-override');
	if( optionPanel ) {
		if( optionPanel.style ) {
			if( optionPanel.style.visibility == 'hidden' ) {
				optionPanel.style.display	= 'block';
				optionPanel.style.visibility	= 'visible';
				optionPanel.style.position		= 'static';
				if( optionButton && optionButton.nodeName && optionButton.nodeName == 'input' ) {
					optionButton.value		= '▲{write:SHOPPING_LABEL_PRODUCT}情報の上書き設定を非表示';
				} else {
					optionButton.innerHTML	= '▲{write:SHOPPING_LABEL_PRODUCT}情報の上書き設定を非表示';
				}
			} else {
				optionPanel.style.display	= 'none';
				optionPanel.style.visibility	= 'hidden';
				optionPanel.style.position		= 'absolute';
				if( optionButton && optionButton.nodeName && optionButton.nodeName == 'input' ) {
					optionButton.value		= '▼{write:SHOPPING_LABEL_PRODUCT}情報の上書き設定を表示';
				} else {
					optionButton.innerHTML	= '▼{write:SHOPPING_LABEL_PRODUCT}情報の上書き設定を表示';
				}
			}
		}
	}
}
//
// HTML編集エリア
//
var shoppingProductTextFormerObject;
function shoppingProductDetailInit() {
	shoppingProductTextFormerObject	= TextFormer( document.cform.detail_comment, "", "" );
	shoppingProductTextFormerObject.setSubject('詳細説明HTML編集');
}
//
// 商品種別変更
//
function shoppingProductDeliveryTypeChange(selectBox){
	document.cform.delivery_type.value	= selectBox.options[selectBox.selectedIndex].value;
	shoppingProductDownloadFileViewChange(selectBox);
	shoppingProductDeliveryTypeView();
}
function shoppingProductDeliveryTypeView(){
	var deliveryType	= document.cform.delivery_type.value;
	var weightBox			= document.getElementById('shopping-product-delivery');
	var monthlyBox		= document.getElementById('shopping-product-monthly');
	var reserveBox		= document.getElementById('shopping-product-reserve');
	var reserveStayBox	= document.getElementById('shopping-product-reserve-stay');
	var reserveHourBox	= document.getElementById('shopping-product-reserve-hour');
	if( parseInt(deliveryType) >= 200 ){
		reserveBox.style.display		= 'block';
		if( parseInt(deliveryType) == 900 ){
			reserveStayBox.style.display		= 'block';
			reserveHourBox.style.display		= 'none';
		}else if( parseInt(deliveryType) == 200 ){
			reserveStayBox.style.display		= 'none';
			reserveHourBox.style.display		= 'block';
		}
		weightBox.style.display	= 'none';
		monthlyBox.style.display	= 'none';
	} else if( parseInt(deliveryType) >= 100 ){
		reserveBox.style.display		= 'none';
		monthlyBox.style.display		= 'block';
		weightBox.style.display	= 'none';
	} else {
		reserveBox.style.display		= 'none';
		monthlyBox.style.display		= 'none';
		weightBox.style.display	= 'block';
	}
}
if(window.attachEvent){
{if:strlen(shopping.product.unit.unit_object->'detail_comment')>0}
	window.attachEvent('onload',shoppingProductDetailInit);
{/if}
	window.attachEvent('onload',shoppingProductDeliveryTypeView);
}else{
{if:strlen(shopping.product.unit.unit_object->'detail_comment')>0}
	window.addEventListener('DOMContentLoaded',shoppingProductDetailInit,false);
{/if}
	window.addEventListener('DOMContentLoaded',shoppingProductDeliveryTypeView,false);
}
//--></script>
{/if}
	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		{if:is_object(shoppingProductObject->'searchDataObject')}
		<span style="white-space:nowrap"><a href="../../../search/data/detail.php?schdi={write:shoppingProductObject->'searchDataObject'->'data_id'}"
		>&gt;&gt;{write:shoppingProductObject->'searchDataObject'->'subject'}の詳細</a></span>
		<span style="white-space:nowrap">&nbsp;&nbsp;<a href="../?schdi={write:shoppingProductObject->'searchDataObject'->'data_id'}"
		>&gt;&gt;{write:shoppingProductObject->'searchDataObject'->'subject'}の{write:SHOPPING_LABEL_PRODUCT}一覧</a></span>
		<span style="white-space:nowrap">&nbsp;&nbsp;<a href="../detail.php?shpdn={write:shoppingProductObject->'product_number'}"
		>&gt;&gt;{write:shoppingProductObject->'product_name'}の詳細</a></span>
		{else}
		<span style="white-space:nowrap"><a href="../">&gt;&gt;{write:SHOPPING_LABEL_PRODUCT}管理</a></span>
		<span style="white-space:nowrap">&nbsp;&nbsp;<a href="../">&gt;&gt;{write:SHOPPING_LABEL_PRODUCT}一覧</a></span>
		{/if}
		<span style="white-space:nowrap">&nbsp;&nbsp;<a href="./form.php?shpun={write:shopping.product.unit.unit_object->'unit_number'}" title="この内容を編集します"
		>&gt;&gt;編集する</a></a>
	</div>