<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:member.download.Form}
{preset:page_title MEMBER_PERSONAL_LABEL . '管理 > ＣＳＶデータダウンロード'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">{write:MEMBER_PERSONAL_LABEL}情報一覧</a>
		&gt; CSVデータダウンロード
	</div>

	<h1>
		{write:MEMBER_PERSONAL_LABEL}管理 &gt; CSVデータダウンロード
	</h1>
	
	{if:IS_ERROR}
	<ul class="error">
		{foreach:errors error}
		<li>{write:error}</li>
		{/foreach}
	</ul>
	<p style="text-align:center;">
		<input type="button" value="{write:MEMBER_PERSONAL_LABEL}管理一覧に戻る" onclick="window.location.href='/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/member/'" />
	</p>
	{else}
	<p style="text-align:left;">
		検索結果から
		{write:member.download.total_count}件の{write:MEMBER_PERSONAL_LABEL}データをダウンロードします。<br />
		ダウンロードしたい登録項目を右側に順序どおり並べて[ダウンロード]ボタンをクリックしてください。
	</p>
	<br />
	<form name="mform" id="mform" action="./confirm.php?mc=1&amp;stype={write:member.download.select_type}" method="post">
	<table style="width:40em;margin:0 auto;">
	<tr>
		<th style="text-align:center;padding:3px;">選択項目</th>
		<th style="text-align:center;padding:3px;"></th>
		<th style="text-align:center;padding:3px;">ダウンロード項目</th>
	</tr>
	<tr>
		<td style="width:15em;">
			<select name="items" style="width:15em;height:20em;" multiple>
			{foreach:MEMBER_UPLOAD_COLUMN_NAME_DEFINITION item_key item_name}
				<option value="{write:item_key}"
					>{write:item_name}</option>
			{/foreach}
			</select>
		</td>
		<td style="width:8em;text-align:center;">
			<input type="button" value="追加&gt;&gt;" onclick="add_select()" /><br />
			<input type="button" value="&lt;&lt;削除" onclick="remove_select()" />
		</td>
		<td style="width:15em;">
			<select name="selected_items" style="width:15em;height:20em;" multiple>
			</select>
		</td>
	</tr>
	</tbody>
	</table>
	
	<p style="text-align:center;">
		<input type="button" value="ダウンロード" onclick="click_submit()"
		/><br />
	</p>
	</form>


<script language="JavaScript" type="text/javascript"><!--
// 選択可能リスト
var selectableItems	= new Array();
// 選択リスト
var selectedItems	= new Array();
// 選択可能セレクトボックス
var selectableBox	= null;
// 選択セレクトボックス
var selecedBox		= null;
/**
 * ロード時初期化処理
 */
onload	= function() {
	
	// グローバルの選択可能リストと選択リストを初期化
	selectableItems	= new Array();
	selectedItems	= new Array();
	
	// 表示に利用するセレクトボックスを設定
	selectableBox	= document.mform.items;
	selecedBox		= document.mform.selected_items;
	
	// 選択済みキー配列の作成
	var selectedKeys	= new Array();
	selectedKeys.length	= {write:count(member.download.column_definition)};
	{foreach:member.download.column_definition key_name key_order}
	selectedKeys[{write:key_order}]	= '{write:key_name}';
	{/foreach}
	
	// 左側セレクトボックスを選択可能リストへ全て追加
	for( var order_number=0; order_number<selectableBox.length; order_number++ ) {
		var opt	= selectableBox.options[order_number];
		var is_selected	= false;
		for( var num=0; num<selectedKeys.length; num++ ) {
			var index	= num+1;
			var keyname	= selectedKeys[index];
			if( opt.value == keyname ) {
				is_selected	= true;
				selectedItems[num]	= opt;
				break;
			}
		}
		if( !is_selected ) {
			selectableItems.push( opt );
		}
	}
	
	// 選択状態に応じて再表示
	review_box();
}
/**
 * 項目追加
 */
function add_select() {
	selectableItems	= new Array();
	for( var num=0; num<selectableBox.length; num++ ) {
		var opt	= selectableBox.options[num];
		if( opt.selected ) {
			opt.selected	= false;
			selectedItems.push( opt );
		} else {
			selectableItems.push( opt );
		}
	}
	review_box();
}
/**
 * 項目削除
 */
function remove_select() {
	selectedItems	= new Array();
	for( var num=0; num<selecedBox.length; num++ ) {
		var opt	= selecedBox.options[num];
		if( opt.selected ) {
			opt.selected	= false;
			selectableItems.push( opt );
		} else {
			selectedItems.push( opt );
		}
	}
	review_box();
}
/**
 * 選択状態で表示
 */
function review_box() {
	selectableBox.length	= selectableItems.length;
	for( var num=0;num<selectableItems.length;num++ ) {
		var opt = document.createElement("option");
		opt.text	= selectableItems[num].text;
		opt.value	= selectableItems[num].value;
		selectableBox.options[num]	= opt;
	}
	selecedBox.length	= selectedItems.length;
	for( var num=0;num<selectedItems.length;num++ ) {
		var opt = document.createElement("option");
		opt.text	= selectedItems[num].text;
		opt.value	= selectedItems[num].value;
		selecedBox.options[num]	= opt;
	}
}
/**
 * submit機能
 */
function click_submit() {
	var formObj	= document.getElementById('mform');
	for( var num = 0; num<selectedItems.length; num++ ) {
		var opt			= selectedItems[num];
		var element 	= document.createElement('input');
		element.id		= "item_" + opt.value;
		element.type	= "hidden";
		element.name	= opt.value;
		element.value	= num + 1;
		formObj.appendChild(element);
	}
	document.mform.submit();
}
//--></script>
	{/if}

	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="../">&gt;&gt; {write:MEMBER_PERSONAL_LABEL}一覧へ戻る</a>
	</div>