/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	main.c
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 *
 *	Date		|Version	|Author		|Summary
 *	2011/02/02	|v0.01		|onakah		|初回版
 */

/*---- インクルードファイル ----*/

#include <jni.h>				//!<jniの使用
#include <use_sherry.h>			//!<Sherryライブラリを使用する

/*---- マクロ定義 ----*/


/*---- 構造体定義 ----*/


/*---- グローバル変数 ----*/

shTexture	g_testTex;			//!<テクスチャデータ
shMesh		g_testMesh;			//!<メッシュデータ

shShaderProg g_shaderpg;		//!<シェーダプログラム

// Vertex Shader
const char* source_vs= { "\
attribute vec3 vPos;\
attribute vec2 vTex;\
uniform mat4 u_worldViewProjMatrix;\
varying vec2 texCoord;\
void main(void) \
{ \
	texCoord = vTex;\
	gl_Position = u_worldViewProjMatrix * vec4(vPos,1); \
} "};

// Fragment Shader
const char* source_fs = { "\
#ifdef GL_ES \n \
precision mediump float;\n \
#endif \n \
uniform sampler2D sampler2d;\
varying vec2 texCoord;\
void main (void) \
{ \
	gl_FragColor = texture2D(sampler2d, texCoord); \
} " };

// 頂点要素配列
shVertexElements mushroom_ve[] = {
	{0,SHVETYPE_FLOAT3,SHVEUSAGE_POSITION,"vPos"},
	{0,SHVETYPE_FLOAT2,SHVEUSAGE_NORMAL,"vTex"},
	SHVE_TMT()	//ターミネータ
};

shVector2	g_mousePos;		//!<現在のマウス座標情報
shVector2	g_oldMousePos;	//!<1フレーム前のマウス座標情報
int			g_isTouch;		//!<タッチされているか
int			g_width, g_height;	//!<サイズ確認用


/*---- スタティックプロトタイプ宣言 ----*/

extern void InitMushroom(void);
extern void MoveMushroom(int isClick, float _x, float _y, shVector2 vec);
extern void UpdateMushroom(void);
extern void DrawMushroom(void);
extern void SetWindowSize(int _x, int _y);

int hoge;
int hoge2;
/*
 *	int Java_com_example_sherry_develop_developandroidAct_ndkInit(JNIEnv*  env, jobject thiz)
 *
 *	native アプリケーション初期化処理関数
 */
//extern "C"
int Java_com_example_sherry_demo_demoandroidAct_ndkInit(JNIEnv* env, jobject thiz)
{
	shInitCreateSherry("Sherryライブラリ テスト",800,480,OpenGL);	// OpenGLを使用する

	// スプライト初期化
	if(shInitSprite())
		return 1;

	// デバッグシステムの初期化
	if(shInitDebug())
		return 1;

	shSetSpriteScSize(800,480);

	// 情報をセット
	shSetClear(0.2f,0.2f,0.2f,1,
		SH_CLS_COLOR_BUFFER|SH_CLS_DEPTH_BUFFER);	//クリア情報

	hoge = 0;
	hoge2 = 0;
	if(shCreateTextureFromPNG(&g_testTex, "mnt/sdcard/external_sd/work/mushroom.png")){
		hoge = 1;
	}

	// モデルの作成
	shCreateShader(&g_shaderpg,source_vs,source_fs,mushroom_ve);
	if(shLoadMeshCOLLADA(&g_testMesh, "mnt/sdcard/external_sd/work/mushroom.dae")){
		hoge2 = 1;
	}

	// マウス座標の初期化
	g_mousePos.x = 0.0f;
	g_mousePos.y = 0.0f;
	g_oldMousePos.x = 0.0f;
	g_oldMousePos.y = 0.0f;
	g_isTouch = 0;

	// きのこ初期化
	InitMushroom();

	return 0;
}


/*
 *	void Java_com_example_sherry_demo_demoandroidAct_ndkExit(JNIEnv*  env, jobject thiz)
 *
 *	native アプリケーション終了処理関数
 */
void Java_com_example_sherry_demo_demoandroidAct_ndkExit(JNIEnv* env, jobject thiz)
{
	// テクスチャの削除
	shDeleteTexture(&g_testTex);

	// デバッグシステムの終了
	shExitDebug();

	// Sherryライブラリの終了処理
	shExitSherry();
}


/*
 *	void Java_com_example_sherry_demo_demoandroidAct_ndkSetCDP(JNIEnv* env, jobject thiz, char* path)
 *
 *	native Currect Directory Path セット関数
 */
//void Java_com_example_sherry_develop_developandroidAct_ndkSetCDP(JNIEnv* env, jobject thiz, jcharArray str)
void Java_com_example_sherry_demo_demoandroidAct_ndkSetCDP(JNIEnv* env, jobject thiz, jstring str)
{
	/*
	const char *s = (*env)->GetStringUTFChars(env, str, NULL);
	(*env)->ReleaseStringUTFChars(env, str, s);

	strcpy(g_CurrentDirectoryPath, s);

	shSetCDP(g_CurrentDirectoryPath);
	*/
}


/*
 *	void Java_com_example_sherry_develop_developandroidAct_ndkChanged(JNIEnv* env, jobject thiz, int width, int height)
 *
 *	＜引数＞
 *		int width		: スクリーンサイズ横幅
 *		int height		: スクリーンサイズ縦幅
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		native アプリケーションサーフェイスが変更されたときに呼び出されます。
 *		画面比の設定などを行います。
 */
void Java_com_example_sherry_demo_demoandroidAct_ndkChanged(JNIEnv* env, jobject thiz, int width, int height)
{
	// ビューポートの設定
	glViewport( 0, 0, width, height );

	g_width = width;
	g_height = height;
	// スプライトサイズ倍率の設定
	shSetSpriteScSize(width, height);
	// きのこ側へサイズをセット
	SetWindowSize(width, height);
}


/*
 *	void Java_com_example_sherry_develop_developandroidAct_ndkDraw(JNIEnv* env, jobject thiz)
 *
 *	native 描画関数（一定間隔で呼び出される。最大60fps?）
 */
void Java_com_example_sherry_demo_demoandroidAct_ndkDraw(JNIEnv* env, jobject thiz)
{
	// ローカル変数
	shMatrix drawmat, drawmat2, drawans;	// 変換用の行列
	shVector2 vec;

	shClear();

	vec.x = g_mousePos.x - g_oldMousePos.x;
	vec.y = g_mousePos.y - g_oldMousePos.y;
	MoveMushroom(g_isTouch, g_mousePos.x, g_mousePos.y, vec);

	g_isTouch = 0;
	g_oldMousePos.x = g_mousePos.x;
	g_oldMousePos.y = g_mousePos.y;

	DrawMushroom();

	shFontSize(16);
	shPrintf(g_width-112, 8, "Sherry Engine");

	char str[64];
	sprintf(str, "x:%f", g_mousePos.x);
	shPrintf(8, 8, str);
	sprintf(str, "y:%f", g_mousePos.y);
	shPrintf(8, 24, str);
	sprintf(str, "width :%d", g_width);
	shPrintf(8, 40, str);
	sprintf(str, "height:%d", g_height);
	shPrintf(8, 56, str);

	// ループします。
	glEnable(GL_DEPTH_TEST);
}


/*
 *	void Java_com_example_sherry_demo_demoandroidAct_ndkSetTouchEvent(JNIEnv* env, jobject thiz, int isTouch, float _x, float _y)
 *
 *	int isTouch		: 0:タッチしていない / 1:タッチしている
 *	float _x		: タッチされたx座標
 *	float _y		: タッチされたy座標
 *	native タッチ情報をセットする
 */
void Java_com_example_sherry_demo_demoandroidAct_ndkSetTouchEvent(JNIEnv* env, jobject thiz, int isTouch, float _x, float _y)
{
	g_isTouch = isTouch;
	g_mousePos.x = _x;
	g_mousePos.y = _y;
}
