﻿/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	shApplication_ios_sys.c
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 * 
 *	Date		|Version	|Author		|Summary
 *	2010/12/26	|v0.01		|Cap5ule	|初回版
 */
 
// Mac OS X(Snow Leopard)のみ
#ifdef MACOSX

/*---- インクルードファイル ----*/

#import <Cocoa/Cocoa.h>
#import <OpenGL/OpenGL.h>
#import <OpenGL/gl.h>

#include "sherry.h"				//!<共通ヘッダー
#include "shApplication.h"		//!<ヘッダー
#include "shApplication_osx_sys.h"

/*---- マクロ定義 ----*/


/*---- グローバル変数 ----*/

//extern
extern GLContextView*	g_sh_context;			//!<コンテキスト
extern shDrawMode		g_sh_DrawMode;			//!<描画モード
// 描画スレッド（メインスレッド）
extern void				(*g_sh_DrawFunc)();		//!<スレッド内で呼び出される関数のポインタ
// 更新スレッド
extern void				(*g_sh_UpdateFunc)();	//!<スレッド内で呼び出される関数のポインタ
extern int				g_sh_UdFrameRate;
// 描画設定
extern unsigned int		g_sh_clsFlag;			//!<クリアターゲットフラグ
// システム変数
extern unsigned long	g_sh_DrawPreTime;		//!<描画：前フレームの時間
extern float			g_sh_DrawFPS;			//!<描画：現在のFPS
extern unsigned long	g_sh_UpdatePreTime;		//!<更新：前フレームの時間
extern float			g_sh_UpdateFPS;			//!<更新：現在のFPS
// 入力系
extern int				g_sh_MButton;			//!<内部入力 押されているかどうか
extern float			g_sh_MCursor[2];		//!<内部入力 0:X,1:Y

/*---- クラス実装 ----*/

/*
 *	@interface GLContextView : UIView 
 *
 *	＜説明＞
 *　　*****
 */
@implementation GLContextView

-(id)initWithFrame:(CGRect)frame {
    /*
	 * initWithFrameで作成する
	 */
    if ((self = [super initWithFrame:frame])) {
		// 初期化・デフォルト
        animating = FALSE;
        animationInterval = (1.0 / 60.0);
        animationTimer = nil;
		
		// コンテキスト作成
		NSOpenGLPixelFormatAttribute attrs[] = {
			NSOpenGLPFADoubleBuffer, // ダブルバッファを使う
			NSOpenGLPFAAccelerated , // ハードウェアアクセラレーションを使う
			NSOpenGLPFAColorSize , 32, // 画像用バッファのビット数を32bitにする
			NSOpenGLPFADepthSize , 32, // デプスバッファのビット数を32bitにする
			0 // ターミネータ
		};
		
		NSOpenGLPixelFormat* pixFmt = [[NSOpenGLPixelFormat alloc]
									   initWithAttributes:attrs];
		//OpenGLコンテキスト
		m_GLcontext = [[NSOpenGLContext alloc] initWithFormat:pixFmt
												  shareContext:nil];	// OpenGL
		if (!m_GLcontext) {
			return 0;
		}
		
		[m_GLcontext makeCurrentContext];
		[m_GLcontext setView:self];
		
		[pixFmt release];
    }
	
    return self;
}

- (void)drawView:(id)sender {
	/*
	 * 描画が必要なときに呼び出される
	 * このプログラムはタイマーで呼び出している
	 */
	// フレームバッファをバインド
	
    [m_GLcontext makeCurrentContext];
	[m_GLcontext setView:self];

	if(g_sh_UpdateFunc!=NULL)
		g_sh_UpdateFunc();
	
	if(g_sh_DrawFunc!=NULL)
		g_sh_DrawFunc();
	
	[m_GLcontext flushBuffer];
}

- (void)setAnimationInterval:(double)interval {
	/*
	 * アニメーションのフレーム間隔を設定する
	 */
	animationInterval = interval;
	
	if (animating) {
		[self stopAnimation];
		[self startAnimation];
	}
}

- (void)startAnimation {
	/*
	 * アニメーションスタート
	 */
    if (!animating) {
		animationTimer =
		[NSTimer scheduledTimerWithTimeInterval:(NSTimeInterval)animationInterval
										 target:self
									   selector:@selector(drawView:)
									   userInfo:nil
										repeats:TRUE];
		 animating = TRUE;
    }
}

- (void)stopAnimation {
	/*
	 * アニメーションストップ
	 */
    if (animating) {
		[animationTimer invalidate];
		animationTimer = nil;
		
        animating = FALSE;
    }
}

- (void)dealloc {
	/*
	 * デストラクタ,リリース
	 */
	
	// コンテキストをリリース
    if ([NSOpenGLContext currentContext] == m_GLcontext)
        [NSOpenGLContext clearCurrentContext];
	
    [super dealloc];
}

// 入力系
- (void)mouseDown:(NSEvent *)theEvent
{
	g_sh_MButton = 1;
	[self mouseDragged:theEvent];
}

- (void)mouseUp:(NSEvent *)theEvent
{
	g_sh_MButton = 0;
	[self mouseDragged:theEvent];
}

- (void)mouseDragged:(NSEvent *)theEvent
{
	NSPoint locationInWindow = [theEvent locationInWindow];
    NSPoint location = [self convertPoint:locationInWindow fromView:self];
    g_sh_MCursor[0] = location.x;
    g_sh_MCursor[1] = [self bounds].size.height - location.y;
}


@end	/*GLContextView*/


/*
 *	@interface AppDelegate : NSObject<UIApplicationDelegate>
 *
 *	＜説明＞
 *　　*****
 */
@implementation AppDelegate

@synthesize m_window;

- (void)applicationDidFinishLaunching:(NSNotification *)application {
	/*
	 * アプリケーション起動後に呼び出し
	 */
/*
	NSRect mainScreen = [[NSScreen mainScreen] frame];
*/
	if(!g_sh_context) {
		return;
	}
	
	NSUInteger styleMask = (NSTitledWindowMask | NSClosableWindowMask);
	
	m_window = [[NSWindow alloc] initWithContentRect:[g_sh_context bounds] styleMask:styleMask backing: NSBackingStoreBuffered defer:NO];
	[m_window setBackgroundColor:[NSColor blackColor]];

	//FPS設定
	[g_sh_context setAnimationInterval:1.0 / (double)g_sh_UdFrameRate];
	
	// ウィンドウにアプリコントローラを追加
	[m_window setContentView:g_sh_context];
	
	// Windowを表示する
	[m_window makeKeyAndOrderFront:nil];
	[g_sh_context startAnimation];
	
}

- (void)applicationWillTerminate:(NSNotification *)application {
	/*
	 * アプリケーション終了直後に呼び出し
	 */
	[self dealloc];
}

- (void)applicationWillResignActive:(NSNotification *)application {
	/*
	 * アプリケーションが不活動にしようとしているときフレームを停止します
	 * このプログラムではストップします。
	 */
	[g_sh_context stopAnimation];
}

- (void)applicationDidBecomeActive:(NSNotification *)application {
	/*
	 * アプリケーションが活動しているときフレーム率を高くします
	 * このプログラムではスタートします。
	 */
	[g_sh_context startAnimation];
}

- (void)dealloc {
	/*
	 * デストラクタ,リリースします
	 */
	[m_window release];
	[super dealloc];
}

@end	/*AppDelegate*/

#endif	/*MACOSX*/
