﻿/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	shApplication_ios_sys.c
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 * 
 *	Date		|Version	|Author		|Summary
 *	2010/12/26	|v0.01		|Cap5ule	|初回版
 */
 
// iPhone,iPad,iPod touchのみ
#ifdef IOS

/*---- インクルードファイル ----*/

#import <UIKit/UIKit.h>
#import <QuartzCore/QuartzCore.h>

#import <OpenGLES/EAGL.h>
#import <OpenGLES/EAGLDrawable.h>
#import <OpenGLES/ES2/gl.h>
#import <OpenGLES/ES2/glext.h>

#include "sherry.h"				//!<共通ヘッダー
#include "shApplication.h"		//!<ヘッダー
#include "shApplication_ios_sys.h"

/*---- マクロ定義 ----*/


/*---- グローバル変数 ----*/

//extern
extern EAGLContext*		g_sh_context;			//!<コンテキスト
extern unsigned int		g_sh_defFramebuffer;	//!<OpenGL フレームバッファ
extern unsigned int		g_sh_clrRenderbuffer;
extern unsigned int		g_sh_dptRenderbuffer;
extern shDrawMode		g_sh_DrawMode;			//!<描画モード
// 描画スレッド（メインスレッド）
extern void				(*g_sh_DrawFunc)();		//!<スレッド内で呼び出される関数のポインタ
// 更新スレッド
extern void				(*g_sh_UpdateFunc)();	//!<スレッド内で呼び出される関数のポインタ
extern int				g_sh_UdFrameRate;
// 描画設定
extern unsigned int		g_sh_clsFlag;			//!<クリアターゲットフラグ
// システム変数
extern unsigned long	g_sh_DrawPreTime;		//!<描画：前フレームの時間
extern float			g_sh_DrawFPS;			//!<描画：現在のFPS
extern unsigned long	g_sh_UpdatePreTime;		//!<更新：前フレームの時間
extern float			g_sh_UpdateFPS;			//!<更新：現在のFPS
// 入力系
extern int				g_sh_MButton;			//!<内部入力 押されているかどうか
extern float			g_sh_MCursor[2];		//!<内部入力 0:X,1:Y

/*---- クラス実装 ----*/

/*
 *	@interface EAGLView : UIView 
 *
 *	＜説明＞
 *　　*****
 */
@implementation EAGLView

/* Synthesize */
@synthesize animating;

+ (Class)layerClass
{
	// 絶対に必要なクラスメソッドです
    return [CAEAGLLayer class];
}

-(id)initWithFrame:(CGRect)frame {
    /*
	 * initWithFrameで作成する
	 */
    if ((self = [super initWithFrame:frame])) {

		self.frame = CGRectMake(-80, 80, 480, 320);
		self.transform = CGAffineTransformMakeRotation(M_PI / -2);
		
		// 初期化・デフォルト
        animating = FALSE;
        animationInterval = (1.0 / 60.0);
        animationTimer = nil;
    }
	
    return self;
}

- (void)drawView:(id)sender {
	/*
	 * 描画が必要なときに呼び出される
	 * このプログラムはタイマーで呼び出している
	 */
	// フレームバッファをバインド
	
    [EAGLContext setCurrentContext:g_sh_context];
    glBindFramebuffer(GL_FRAMEBUFFER, g_sh_defFramebuffer);

	if(g_sh_UpdateFunc!=NULL)
		g_sh_UpdateFunc();
	
	if(g_sh_DrawFunc!=NULL)
		g_sh_DrawFunc();

	glBindRenderbuffer(GL_RENDERBUFFER, g_sh_clrRenderbuffer);
    [g_sh_context presentRenderbuffer:GL_RENDERBUFFER];
}

- (void)layoutSubviews {
	/*
	 * レイヤーが変更されたときに呼び出される
	 * そして再調整を行う
	 */
	int framebufWidth, framebufHeight;
	[EAGLContext setCurrentContext:g_sh_context];
	glBindRenderbuffer(GL_RENDERBUFFER, g_sh_clrRenderbuffer);
    [g_sh_context renderbufferStorage:GL_RENDERBUFFER fromDrawable:(CAEAGLLayer*)self.layer];
	glGetRenderbufferParameteriv(GL_RENDERBUFFER, GL_RENDERBUFFER_WIDTH, &framebufWidth);
	glGetRenderbufferParameteriv(GL_RENDERBUFFER, GL_RENDERBUFFER_HEIGHT, &framebufHeight);
	
	glBindRenderbuffer(GL_RENDERBUFFER, g_sh_dptRenderbuffer);
	glRenderbufferStorage(GL_RENDERBUFFER, GL_DEPTH_COMPONENT16, framebufWidth, framebufHeight);
	
    [self drawView:nil];
}

- (void)setAnimationInterval:(double)interval {
	/*
	 * アニメーションのフレーム間隔を設定する
	 */
	animationInterval = interval;
	
	if (animating) {
		[self stopAnimation];
		[self startAnimation];
	}
}

- (void)startAnimation {
	/*
	 * アニメーションスタート
	 */
    if (!animating) {
		animationTimer =
		[NSTimer scheduledTimerWithTimeInterval:(NSTimeInterval)animationInterval
										 target:self
									   selector:@selector(drawView:)
									   userInfo:nil
										repeats:TRUE];
        animating = TRUE;
    }
}

- (void)stopAnimation {
	/*
	 * アニメーションストップ
	 */
    if (animating) {
		[animationTimer invalidate];
		animationTimer = nil;
		
        animating = FALSE;
    }
}

- (void)dealloc {
	/*
	 * デストラクタ,リリース
	 */
    [super dealloc];
}

//マルチタッチを有効にするかどうか
- (BOOL)isMultipleTouchEnabled {
    return NO;	//シングル
}

//入力系
// タッチ開始のイベント処理
- (void)touchesBegan:(NSSet*)touches withEvent:(UIEvent*)event
{
	g_sh_MButton = 1;
	[self touchesMoved:touches withEvent:event];	//座標取得
}

// タッチ終了のイベント処理
- (void)touchesEnded:(NSSet*)touches withEvent:(UIEvent *)event
{
	g_sh_MButton = 0;
	[self touchesMoved:touches withEvent:event];	//座標取得
}

// タッチ移動のイベント処理
- (void)touchesMoved:(NSSet*)touches withEvent:(UIEvent *)event
{
	for(UITouch* touch in touches)
	{
		CGPoint pt = [touch locationInView:self];
		g_sh_MCursor[0] = pt.x;
		g_sh_MCursor[1] = pt.y;	//バグ？調査中
	}
}

@end	/*EAGLView*/


/*
 *	@interface AppDelegate : NSObject<UIApplicationDelegate>
 *
 *	＜説明＞
 *　　*****
 */
@implementation AppDelegate

- (void)applicationDidFinishLaunching:(UIApplication *)application {
	/*
	 * アプリケーション起動後に呼び出し
	 */
	CGRect rect = [[UIScreen mainScreen] bounds];	// 画面サイズ取得
	
	[application setStatusBarStyle:UIStatusBarStyleBlackTranslucent animated:NO];
	[application setStatusBarHidden:true];
	[[NSNotificationCenter defaultCenter] addObserver:self
										   selector:@selector(didRotate:)
											   name:UIDeviceOrientationDidChangeNotification
											  object:nil];

	// タイトルをCFBundleNameから取得
	//self.title = [[[NSBundle mainBundle] infoDictionary]
	//			  objectForKey:@"CFBundleName"];
	
	// フルスクリーンでウィンドウを作成
	m_window = [[UIWindow alloc] initWithFrame:rect];
	// OpenGL View
	m_glView = [[EAGLView alloc] initWithFrame:rect];
	[m_glView setAnimationInterval:1.0 / (double)g_sh_UdFrameRate];

	// ウィンドウにアプリコントローラを追加
	[m_window addSubview:m_glView];
	
	// Windowを表示する
	[m_window makeKeyAndVisible];
	[m_glView startAnimation];
	
}

- (void)applicationWillTerminate:(UIApplication *)application {
	/*
	 * アプリケーション終了直後に呼び出し
	 */
	[self dealloc];
}

- (void)applicationWillResignActive:(UIApplication *)application {
	/*
	 * アプリケーションが不活動にしようとしているときフレームを停止します
	 * このプログラムではストップします。
	 */
	[m_glView stopAnimation];
}

- (void)applicationDidBecomeActive:(UIApplication *)application {
	/*
	 * アプリケーションが活動しているときフレーム率を高くします
	 * このプログラムではスタートします。
	 */
	[m_glView startAnimation];
}

- (void)dealloc {
	/*
	 * デストラクタ,リリースします
	 */
	[m_window release];
	[m_glView release];
	[super dealloc];
}

- (void)didRotate:(NSNotification *)notification {
	UIDeviceOrientation orient = [[notification object] orientation];
	
	if(orient == UIDeviceOrientationLandscapeLeft) {
		
	} else {
		
	}
}

@end	/*AppDelegate*/

#endif	/*TARGET_OS_IPHONE*/
