/*
 * }`vbgtH[`GWuSherryv
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	main.c
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 * 
 *	Date		|Version	|Author		|Summary
 *	2010/02/01	|v0.01		|onakah		|
 */

/*---- CN[ht@C ----*/

#include <use_sherry.h>			//!<SherryCugp

/*---- }N` ----*/


/*---- \̒` ----*/


/*---- O[oϐ ----*/

shTexture	g_testTex;			//!<eNX`f[^
shMesh		g_testMesh;			//!<bVf[^

shShaderProg g_shaderpg;		//!<VF[_vO

const char* source_vs= { "\
attribute vec3 vPos;\
attribute vec2 vTex;\
uniform mat4 u_worldViewProjMatrix;\
varying vec2 texCoord;\
void main(void) \
{ \
	texCoord = vTex;\
	gl_Position = u_worldViewProjMatrix * vec4(vPos,1); \
} "};

const char* source_fs = { "\
uniform sampler2D sampler2d;\
varying vec2 texCoord;\
void main (void) \
{ \
	gl_FragColor = texture2D(sampler2d, texCoord); \
} " };

// _vfz
shVertexElements mushroom_ve[] = {
	{0,SHVETYPE_FLOAT3,SHVEUSAGE_POSITION,"vPos"},
	{0,SHVETYPE_FLOAT2,SHVEUSAGE_NORMAL,"vTex"},
	SHVE_TMT()	//^[~l[^
};

shVector2	g_mousePos;		//!<݂̃}EXW
shVector2	g_oldMousePos;	//!<1t[Õ}EXW


/*---- X^eBbNvg^Cv錾 ----*/

extern void InitMushroom(void);
extern void MoveMushroom(int isClick, float _x, float _y, shVector2 vec);
extern void UpdateMushroom(void);
extern void DrawMushroom(void);


/*---- X^eBbN֐ ----*/


/*
 *	void DrawFunc()
 *
 *	`֐FőptH[}XŌĂяo܂B
 */
void DrawFunc()
{
	// ʃNA
	shClear();

	// ̂̕`
	DrawMushroom();

	shFontSize(20);
	shPrintf(20, 20, "Sherry Library");
	shPrintf(20, 50, "mouseX:%d", (int)g_mousePos.x);
	shPrintf(20, 80, "mouseY:%d", (int)g_mousePos.y);
}

/*
 *	void UpdateFunc()
 *
 *	XV֐F60fpsŌĂяo܂B
 */
void UpdateFunc()
{
	int			isClick = 0;
	shVector2	vecWork;

	// }EX擾
	isClick = shGetCursorPos(&g_mousePos.x, &g_mousePos.y);

	vecWork.x = g_mousePos.x - g_oldMousePos.x;
	vecWork.y = g_mousePos.y - g_oldMousePos.y;

	// ̂̉]
	MoveMushroom(isClick, g_mousePos.x, g_mousePos.y, vecWork);

	// ݂̏i[
	g_oldMousePos.x = g_mousePos.x;
	g_oldMousePos.y = g_mousePos.y;

	// ̂̍XV
	UpdateMushroom();

	// [v܂B
}

/*
 *	int main()
 *
 *	Gg[|CgBX^[g܂B
 *@ R\[o߂main֐ɈꎞIɕύXB
 */
int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
					 char* szCmdLine, int nCmdShow )
//int main()
{
	// SherryCu
	shInitCreateSherry(GetModuleHandle(NULL),"SherryCu eXg",640,480,OpenGL);	// OpenGLgp

	// ֐Zbg
	shSetUpdateThread(60,UpdateFunc);	// XV
	shSetDrawThread(DrawFunc);			// `

	// XvCg
	if(shInitSprite())
		return 1;

	// fobOVXȅ
	if(shInitDebug())
		return 1;
	
	// fobOEBhE̐
	shCreateDebugWindow(100, 250, 100, 100);
	shCreateDebugWindow(300, 50, 300, 150);

	// Zbg
	shSetClear(0.2f,0.2f,0.2f,1,
		SH_CLS_COLOR_BUFFER|SH_CLS_DEPTH_BUFFER);	//NA

	// eNX`̍쐬
	shCreateTextureFromPNG(&g_testTex,shDCP("mushroom.png"));

	// VF[_[̍쐬
	shCreateShader(&g_shaderpg,source_vs,source_fs,mushroom_ve);

	// f̍쐬
	shLoadMeshCOLLADA(&g_testMesh, shDCP("mushroom.dae"));

	// }EXW̏
	g_mousePos.x = 0.0f;
	g_mousePos.y = 0.0f;
	g_oldMousePos.x = 0.0f;
	g_oldMousePos.y = 0.0f;

	// ̂
	InitMushroom();

	// SherryC[v
	shMainSherry();

	// eNX`̍폜
	shDeleteTexture(&g_testTex);
	shDeleteMesh(&g_testMesh);

	// fobOVXȅI
	shExitDebug();

	// SherryCȕI
	shExitSherry();

	return 0;
}
