﻿/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	main.c
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 * 
 *	Date		|Version	|Author		|Summary
 *	2010/02/01	|v0.01		|onakah		|初回版
 */

/*---- インクルードファイル ----*/

#include <use_sherry.h>			//!<Sherryライブラリを使用する

/*---- マクロ定義 ----*/


/*---- 構造体定義 ----*/


/*---- グローバル変数 ----*/

shTexture	g_testTex;			//!<テクスチャデータ
shMesh		g_testMesh;			//!<メッシュデータ

shShaderProg g_shaderpg;		//!<シェーダプログラム

const char* source_vs= { "\
attribute vec3 vPos;\
attribute vec2 vTex;\
uniform mat4 u_worldViewProjMatrix;\
varying vec2 texCoord;\
void main(void) \
{ \
	texCoord = vTex;\
	gl_Position = u_worldViewProjMatrix * vec4(vPos,1); \
} "};

const char* source_fs = { "\
uniform sampler2D sampler2d;\
varying vec2 texCoord;\
void main (void) \
{ \
	gl_FragColor = texture2D(sampler2d, texCoord); \
} " };

// 頂点要素配列
shVertexElements mushroom_ve[] = {
	{0,SHVETYPE_FLOAT3,SHVEUSAGE_POSITION,"vPos"},
	{0,SHVETYPE_FLOAT2,SHVEUSAGE_NORMAL,"vTex"},
	SHVE_TMT()	//ターミネータ
};

shVector2	g_mousePos;		//!<現在のマウス座標情報
shVector2	g_oldMousePos;	//!<1フレーム前のマウス座標情報


/*---- スタティックプロトタイプ宣言 ----*/

extern void InitMushroom(void);
extern void MoveMushroom(int isClick, float _x, float _y, shVector2 vec);
extern void UpdateMushroom(void);
extern void DrawMushroom(void);


/*---- スタティック関数 ----*/


/*
 *	void DrawFunc()
 *
 *	描画関数：最大パフォーマンスで呼び出されます。
 */
void DrawFunc()
{
	// 画面クリア
	shClear();

	// きのこの描画
	DrawMushroom();

	shFontSize(20);
	shPrintf(20, 20, "Sherry Library");
	shPrintf(20, 50, "mouseX:%d", (int)g_mousePos.x);
	shPrintf(20, 80, "mouseY:%d", (int)g_mousePos.y);
}

/*
 *	void UpdateFunc()
 *
 *	更新関数：60fpsで呼び出されます。
 */
void UpdateFunc()
{
	int			isClick = 0;
	shVector2	vecWork;

	// マウス情報を取得する
	isClick = shGetCursorPos(&g_mousePos.x, &g_mousePos.y);

	vecWork.x = g_mousePos.x - g_oldMousePos.x;
	vecWork.y = g_mousePos.y - g_oldMousePos.y;

	// きのこの回転処理
	MoveMushroom(isClick, g_mousePos.x, g_mousePos.y, vecWork);

	// 現在の情報を格納
	g_oldMousePos.x = g_mousePos.x;
	g_oldMousePos.y = g_mousePos.y;

	// きのこの更新処理
	UpdateMushroom();

	// ループします。
}

/*
 *	int main()
 *
 *	エントリーポイント。ここからスタートします。
 *　※ コンソールを出すためにmain関数に一時的に変更。
 */
//int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
//					 char* szCmdLine, int nCmdShow )
int main()
{
	// Sherryライブラリを初期化
	shInitCreateSherry("Sherryライブラリ テスト",640,480,OpenGL);	// OpenGLを使用する

	// 関数をセット
	shSetUpdateThread(60,UpdateFunc);	// 更新
	shSetDrawThread(DrawFunc);			// 描画

	// スプライト初期化
	if(shInitSprite())
		return 1;

	// デバッグシステムの初期化
	if(shInitDebug())
		return 1;
	
	// デバッグウィンドウの生成
	shCreateDebugWindow(100, 250, 100, 100);
	shCreateDebugWindow(300, 50, 300, 150);

	// 情報をセット
	shSetClear(0.2f,0.2f,0.2f,1,
		SH_CLS_COLOR_BUFFER|SH_CLS_DEPTH_BUFFER);	//クリア情報

	// テクスチャの作成
	shCreateTextureFromPNG(&g_testTex,shDCP("mushroom.png"));

	// シェーダーの作成
	shCreateShader(&g_shaderpg,source_vs,source_fs,mushroom_ve);

	// モデルの作成
	shLoadMeshCOLLADA(&g_testMesh, shDCP("mushroom.dae"));

	// マウス座標の初期化
	g_mousePos.x = 0.0f;
	g_mousePos.y = 0.0f;
	g_oldMousePos.x = 0.0f;
	g_oldMousePos.y = 0.0f;

	// きのこ初期化処理
	InitMushroom();

	// Sherryメインループへ
	shMainSherry();

	// テクスチャの削除
	shDeleteTexture(&g_testTex);
	shDeleteMesh(&g_testMesh);

	// デバッグシステムの終了
	shExitDebug();

	// Sherryライブラリの終了処理
	shExitSherry();

	return 0;
}
