/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	main.c
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 *
 *	Date		|Version	|Author		|Summary
 *	2011/01/03	|v0.01		|onakah		|初回版
 *	常に更新
 */

/*---- インクルードファイル ----*/

#include <jni.h>				//!<jniの使用
#include <use_sherry.h>			//!<Sherryライブラリを使用する
/*
#include <android/log.h>
#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>
#include <stdlib.h>
*/
/*---- マクロ定義 ----*/


/*---- 構造体定義 ----*/


/*---- グローバル変数 ----*/
shTexture	g_testTex;			//!<テクスチャデータ
shTexture	g_testTex2;			//!<テクスチャデータ
shMesh		g_testMesh;			//!<メッシュデータ

shShaderProg g_shaderpg;		//!<シェーダプログラム

// Vertex Shader
const char* source_vs= { "\
attribute vec3 vPos;\
attribute vec2 vTex;\
uniform mat4 u_worldViewProjMatrix;\
varying vec2 texCoord;\
void main(void) \
{ \
	texCoord = vTex;\
	gl_Position = u_worldViewProjMatrix * vec4(vPos,1); \
} "};

// Fragment Shader
const char* source_fs = { "\
#ifdef GL_ES \n \
precision mediump float;\n \
#endif \n \
uniform sampler2D sampler2d;\
varying vec2 texCoord;\
void main (void) \
{ \
	gl_FragColor = texture2D(sampler2d, texCoord); \
} " };

// 頂点要素配列
shVertexElements mushroom_ve[] = {
	{0,SHVETYPE_FLOAT3,SHVEUSAGE_POSITION,"vPos"},
	{0,SHVETYPE_FLOAT2,SHVEUSAGE_NORMAL,"vTex"},
	SHVE_TMT()	//ターミネータ
};


static float rot = 0;		// モデル回転テスト
static int ggrot = 0;		// モデル回転テスト
static float g_Scroll = 0;	// スプライトスクロールテスト
static float g_rtest = 0;	// 背景色テスト

int g_width, g_height;		// 画面サイズ出力用
char g_CurrentDirectoryPath[256];


/*---- スタティックプロトタイプ宣言 ----*/


/*
 *	int Java_com_example_sherry_develop_developandroidAct_ndkInit(JNIEnv*  env, jobject thiz)
 *
 *	native アプリケーション初期化処理関数
 */
//extern "C"
int Java_com_example_sherry_develop_developandroidAct_ndkInit(JNIEnv* env, jobject thiz)
{

	shInitCreateSherry("Sherryライブラリ テスト",800,480,OpenGL);	// OpenGLを使用する
	///sdcard/
	rot = 0;
	// 関数をセット
//	shSetUpdateThread(60,UpdateFunc);	// 更新
	//shSetDrawThread(DrawFunc);			// 描画

	// スプライト初期化
	if(shInitSprite())
		return 1;

	// デバッグシステムの初期化
	if(shInitDebug())
		return 1;

	shSetSpriteScSize(800,480);

	// 情報をセット
	shSetClear(0.2f,0.2f,0.2f,1,
		SH_CLS_COLOR_BUFFER|SH_CLS_DEPTH_BUFFER);	//クリア情報

	shCreateTextureFromPNG(&g_testTex, shDCP("testtex_a.png"));
	//shCreateTextureFromPNG(&g_testTex,"mnt/sdcard/external_sd/work/testtex_a.png");

	// テクスチャの作成
//	shCreateTextureFromPNG(&g_testTex2,"/mnt/sdcard/external_sd/work/mushroom.png");
	shCreateTextureFromPNG(&g_testTex2, shDCP("/mushroom.png"));

	// モデルの作成
	shCreateShader(&g_shaderpg,source_vs,source_fs,mushroom_ve);
//	ggrot = shLoadMeshCOLLADA(&g_testMesh, shDCP("/mushroom.dae"));
	shLoadMeshCOLLADA(&g_testMesh, "mnt/sdcard/external_sd/work/mushroom.dae");

	return 0;
}


/*
 *	void Java_com_example_sherry_develop_developandroidAct_ndkExit(JNIEnv*  env, jobject thiz)
 *
 *	native アプリケーション終了処理関数
 */
void Java_com_example_sherry_develop_developandroidAct_ndkExit(JNIEnv* env, jobject thiz)
{
	// テクスチャの削除
	shDeleteTexture(&g_testTex);
	shDeleteTexture(&g_testTex2);

	// デバッグシステムの終了
	shExitDebug();

	// Sherryライブラリの終了処理
	shExitSherry();
}


/*
 *	void Java_com_example_sherry_develop_developandroidAct_ndkSetCDP(JNIEnv* env, jobject thiz, char* path)
 *
 *	native Currect Directory Path セット関数
 */
//void Java_com_example_sherry_develop_developandroidAct_ndkSetCDP(JNIEnv* env, jobject thiz, jcharArray str)
void Java_com_example_sherry_develop_developandroidAct_ndkSetCDP(JNIEnv* env, jobject thiz, jstring str)
{
//	unsigned char charArray[256];
	/*
	char* charArray;
	charArray = (*env)->GetCharArrayElements(env, str, NULL);
	*/

	const char *s = (*env)->GetStringUTFChars(env, str, NULL);
	(*env)->ReleaseStringUTFChars(env, str, s);

	strcpy(g_CurrentDirectoryPath, s);

	shSetCDP(g_CurrentDirectoryPath);
}


/*
 *	void Java_com_example_sherry_develop_developandroidAct_ndkChanged(JNIEnv* env, jobject thiz, int width, int height)
 *
 *	＜引数＞
 *		int width		: スクリーンサイズ横幅
 *		int height		: スクリーンサイズ縦幅
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		native アプリケーションサーフェイスが変更されたときに呼び出されます。
 *		画面比の設定などを行います。
 */
void Java_com_example_sherry_develop_developandroidAct_ndkChanged(JNIEnv* env, jobject thiz, int width, int height)
{
	g_width = width;
	g_height = height;

	// ビューポートの設定
	glViewport( 0, 0, width, height );

	// スプライトサイズ倍率の設定
	shSetSpriteScSize(width, height);
}


/*
 *	void Java_com_example_sherry_develop_developandroidAct_ndkDraw(JNIEnv* env, jobject thiz)
 *
 *	native 描画関数（一定間隔で呼び出される。最大60fps?）
 */
void Java_com_example_sherry_develop_developandroidAct_ndkDraw(JNIEnv* env, jobject thiz)
{
	// ローカル変数
	shMatrix drawmat, drawmat2, drawans;	// 変換用の行列
/*
	g_rtest += 0.01f;
	if(g_rtest > 1){
		g_rtest = 0.0f;
	}
	shSetClear(g_rtest, 1, 1, 1, SH_CLS_COLOR_BUFFER);
*/

	shClear();

	//ポリゴン描画
	{
		int ii;
		shVector3 eye,at,up;

		eye.x = 0.0f;
		eye.y = 0.0f;
		eye.z = sinf(rot*0.02f)*1.6f+4.0f;
		at.x = 0.0f;
		at.y = 0.0f;
		at.z = 0.0f;
		up.x = 0.0f;
		up.y = 1.0f;
		up.z = 0.0f;

		shBeginShader(&g_shaderpg);

		// テクスチャを設定
		shSetTexture(&g_testTex2);

		// 行列変換
		shMatrixIdentity(&drawans);	// 単位行列化
		shMatrixPerspectiveFovRH(&drawmat,45,800.0f/480.0f,0.5f,20.0f);
		shLookAtMatrixRH(&drawmat2,&eye,&at,&up);
		shMatrixMultiply(&drawans,&drawmat2,&drawmat);
		shMatrixRotationYawPitchRoll(&drawmat2,rot,rot,rot);
		shMatrixMultiply(&drawans,&drawmat2,&drawans);

		for(ii = 0; ii < 9; ii++) {
			shMatrix drawmat_tran, drawmat_ans;

			const shVector3 pos[] = {
				{0,0,0},
				{0,0,1},
				{0,0,-1},
				{1,0,0},
				{-1,0,0},
				{0,0,2},
				{0,0,-2},
				{2,0,0},
				{-2,0,0},
			};

			// 平行移動
			shMatrixTranslation(&drawmat_tran,pos[ii].x,pos[ii].y,pos[ii].z);

			shMatrixMultiply(&drawmat_ans,&drawmat_tran,&drawans);
			// 行列を入れる
			glUniformMatrix4fv(glGetUniformLocation(g_shaderpg.shaderProg_gl,
					"u_worldViewProjMatrix"), 1, GL_FALSE, (float*)drawmat_ans.m);

			shDrawMesh(&g_testMesh);
		}

		shEndShader(&g_shaderpg);
	}
	glDisable(GL_DEPTH_TEST);

	// スクロールのテスト
	g_Scroll += 0.01f;
	if(g_Scroll >= 1.0f){
		g_Scroll = 0.0f;
	}
	rot+=5.0f;

	shSetSpriteTexCoord(g_Scroll, g_Scroll, 1.0f, 1.0f);
	shSetSpritePositionSize(128.0f,128.0f,-0.5f,196.0f,196.0f);
	shSetSpriteTexture(&g_testTex);
	shSpriteDraw();

	char str[64];
	shFontSize(32);
	shPrintf(300, 100, "Sherry");
	sprintf(str, "test:%d", (int)rot);
	shPrintf(300, 150, str);

	shFontSize(16);
	sprintf(str, "Width  : %d", g_width);
	shPrintf(10, 20, str);
//	shPrintf(10, 20, "Width:%d", g_width);
	sprintf(str, "Height : %d", g_height);
	shPrintf(10, 36, str);
//	shPrintf(10, 36, "Height:%d", g_height);

	shPrintf(10, 60, shDCP("/testtex_a.png"));
	shPrintf(10, 80, g_CurrentDirectoryPath);

	// ループします。
	glEnable(GL_DEPTH_TEST);
}
