package com.example.sherry.demo;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.*;

import android.app.Activity;
import android.app.ActivityManager;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.util.Log;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.os.Environment;
import android.view.Window;   
import android.view.WindowManager;
import android.content.res.AssetManager;
import java.io.InputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import android.view.MotionEvent;
import android.view.KeyEvent;

public class demoandroidAct extends Activity implements GLSurfaceView.Renderer{
	// NDKload
	static {
        System.loadLibrary("main");
    }
	//　native
    public native void ndkInit();		// 初期化
    public native void ndkExit();		// 終了処理
    public native void ndkSetCDP(String str);
    public native void ndkChanged(int width, int height);	//　画面変更
    public native void ndkDraw();		// 描画
    public native void ndkSetTouchEvent(int isTouch, float _x, float _y);

    //　View
    private GLSurfaceView glView = null;
    
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        glView = new GLSurfaceView( this );
        // デバイスがOpenGL ES2.0に対応しているか
        if(detectOpenGLES20()) 
        {
            // Tell the surface view we want to create an OpenGL ES 2.0-compatible
            // context, and set an OpenGL ES 2.0-compatible renderer.
            glView.setEGLContextClientVersion(2);
            glView.setRenderer( this );
        }
        else
        {
        	// 対応していなければ終了する
        	Log.e("develop_android", "OpenGL ES 2.0 not supported on device.  Exiting...");
        	finish();
           
        }
        // タイトルバーの削除   
        requestWindowFeature(Window.FEATURE_NO_TITLE);   
        // ステータスバー削除   
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN); 

        setContentView( glView );
    }

    @Override
    public void onDestroy(){
    	super.onDestroy();
    	
    	ndkExit();
    }

    @Override
    public void onResume(){
    	super.onResume();
    	if( glView != null ){
    		glView.onResume();
    	}
    }

    @Override
    public void onPause(){
    	super.onPause();
    	if( glView != null ){
    		glView.onPause();
    	}
    }

    //　初期化
    public void onSurfaceCreated( GL10 gl, EGLConfig config ){
    	// ファイルディレクトリを設定
    	/*
        String filePath = Environment.getExternalStorageDirectory().getPath();
    	Log.e("MyTag(Error)", filePath);
    	filePath = "/data/data/"+ this.getPackageName()+ "/files/";
    	ndkSetCDP(filePath);
    	// assetsフォルダリソースのインストール
    	try {
	    		installContents();
	    } catch (IOException e) {
	            e.printStackTrace();
	    }
	    */

		ndkInit();	//　初期化
    }


    //　サーフェース変更
    public void onSurfaceChanged( GL10 gl, int width, int height ){
    	ndkChanged( width, height );	//　画面変更
    }


    //　描画
    public void onDrawFrame( GL10 gl ){
		ndkDraw();		//　描画
    }
    
    @Override
    public boolean onTouchEvent(MotionEvent event) {
        String action = "";
        switch (event.getAction()) {
        case MotionEvent.ACTION_DOWN:
            action = "ACTION_DOWN";
            break;
        case MotionEvent.ACTION_UP:
            action = "ACTION_UP";
            break;
        case MotionEvent.ACTION_MOVE:
            action = "ACTION_MOVE";
            break;
        case MotionEvent.ACTION_CANCEL:
            action = "ACTION_CANCEL";
            break;
        }
        // タッチイベントを送る
        ndkSetTouchEvent(1 ,event.getX(), event.getY());
        
        return super.onTouchEvent(event);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
		if(keyCode == KeyEvent.KEYCODE_BACK){
			// プロセスを強制終了させる
		    System.exit(RESULT_OK);
		}
		return super.onKeyDown(keyCode, event);
	}

    // assets内のファイルをインストール
    private final void installContents() throws IOException {
        AssetManager as = getResources().getAssets();
        
        // ここへasset内のファイルを記述する
//        copyFile(as, "mushroom.png");
  //      copyFile(as, "mushroom.dae");
        // ここまで
        
        as.close();
    }
    
    private void copyFile(AssetManager asMng, String file) throws IOException {
        InputStream is = asMng.open(file); // アセットファイルのストリーム作成
        String toFile = file;
        copy2Apk(is, toFile); // appローカルにコピー
        is.close();
    }

    private void copy2Apk(InputStream input, String file) throws IOException {
		FileOutputStream output = openFileOutput(file, Context.MODE_WORLD_READABLE);
		int DEFAULT_BUFFER_SIZE = 1024 * 4;
		byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];	
		int n = 0;
		while (-1 != (n = input.read(buffer))) {
		    output.write(buffer, 0, n);
		}
		output.close();
	}
    
    // OpenGL ES2.0へ対応していればtrueを返す
    private boolean detectOpenGLES20() 
    {
        ActivityManager am =
            (ActivityManager) getSystemService(Context.ACTIVITY_SERVICE);
        ConfigurationInfo info = am.getDeviceConfigurationInfo();
        return (info.reqGlEsVersion >= 0x20000);
    }
}
